/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.item.LinkCore;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemInvLinkProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private final ItemStack stack;
    private final ItemStackHandler handler;
    private final LazyOptional<IItemHandler> optional;
    public static final String NBT_KEY = "Inventory";

    public ItemInvLinkProvider(ItemStack stack, int size) {
        this.stack = stack;
        this.handler = new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ItemInvLinkProvider.this.saveToStack();
            }
        };
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_KEY)) {
            this.handler.deserializeNBT(stack.m_41783_().m_128469_(NBT_KEY));
        }
        this.optional = LazyOptional.of(() -> this.handler);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.optional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.handler.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.handler.deserializeNBT(nbt);
    }

    private void saveToStack() {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128365_(NBT_KEY, (Tag)this.handler.serializeNBT());
    }

    public void writeToStack() {
        this.saveToStack();
    }
}

