/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.item.LinkCore;

import com.awesoft.cclink.libs.ComputerLib;
import com.awesoft.cclink.libs.LuaConverter;
import com.awesoft.cclink.libs.RaycastingUtil;
import com.awesoft.cclink.upgrades.luaFunctions.ChattyUpgradeFunctions;
import com.awesoft.cclink.upgrades.luaFunctions.IntrospectionUpgradeFunctions;
import com.awesoft.cclink.upgrades.luaFunctions.KineticUpgradeFunctions;
import com.awesoft.cclink.upgrades.luaFunctions.OverlayUpgradeFunctions;
import com.awesoft.cclink.upgrades.luaFunctions.ScannerUpgradeFunctions;
import com.awesoft.cclink.upgrades.luaFunctions.SensorUpgradeFunctions;
import com.awesoft.cclink.upgrades.luaFunctions.WorldUpgradeFunctions;
import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.pocket.IPocketAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkAPI
implements ILuaAPI {
    private static final Logger LOG = LoggerFactory.getLogger(LinkAPI.class);
    private final IComputerSystem computer;
    private final IPocketAccess pocket;

    public LinkAPI(IComputerSystem computer, IPocketAccess pocket) {
        this.computer = computer;
        this.pocket = pocket;
    }

    public String[] getNames() {
        return new String[]{"link"};
    }

    private static Object createOutput(String output) {
        return new Object[]{output};
    }

    public final Level getLevel() {
        return this.computer.getLevel();
    }

    public final ServerPlayer getPlayer() {
        Entity entity = this.pocket.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return player;
        }
        return null;
    }

    public final Container getLinkInventory() {
        return ComputerLib.getContainerFromLinkHolder((Entity)this.getPlayer());
    }

    public final Boolean isPlayerAlive() {
        return this.getPlayer() != null;
    }

    public final UUID getOwnerUUID() {
        if (this.getPlayer() != null) {
            return this.getPlayer().m_20148_();
        }
        return null;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult listUpgrades() {
        ArrayList<String> result = new ArrayList<String>();
        int size = this.getLinkInventory().m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.getLinkInventory().m_8020_(i);
            if (stack.m_41619_()) continue;
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
            result.add(id.toString());
        }
        return MethodResult.of((Object[])new Object[]{true, result});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult hasUpgrade(String upgradeid) {
        Item id = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(upgradeid));
        Set<Item> items = Set.of(id);
        return MethodResult.of((Object)this.getLinkInventory().m_18949_(items));
    }

    public final boolean hasUpgradeNonLua(String upgradeid) {
        Item id = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(upgradeid));
        Set<Item> items = Set.of(id);
        return this.getLinkInventory().m_18949_(items);
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getUpgradeFunctions() {
        Object funcs;
        HashMap<String, Object> functions = new HashMap<String, Object>();
        if (this.hasUpgradeNonLua("cclink:scanner_upgrade")) {
            funcs = new ScannerUpgradeFunctions((Entity)this.getPlayer(), this.computer);
            functions.put("scanner", ((ScannerUpgradeFunctions)funcs).getFunctions());
        }
        if (this.hasUpgradeNonLua("cclink:sensor_upgrade")) {
            funcs = new SensorUpgradeFunctions((Entity)this.getPlayer(), this.computer);
            functions.put("sensor", ((SensorUpgradeFunctions)funcs).getFunctions());
        }
        if (this.hasUpgradeNonLua("cclink:introspection_upgrade")) {
            funcs = new IntrospectionUpgradeFunctions((Entity)this.getPlayer());
            functions.put("introspection", ((IntrospectionUpgradeFunctions)funcs).getFunctions());
        }
        if (this.hasUpgradeNonLua("cclink:world_upgrade")) {
            funcs = new WorldUpgradeFunctions((Entity)this.getPlayer());
            functions.put("world", ((WorldUpgradeFunctions)funcs).getFunctions());
        }
        if (this.hasUpgradeNonLua("cclink:overlay_upgrade")) {
            funcs = new OverlayUpgradeFunctions((Entity)this.getPlayer());
            functions.put("overlay", ((OverlayUpgradeFunctions)funcs).getFunctions());
        }
        if (this.hasUpgradeNonLua("cclink:kinetic_upgrade")) {
            funcs = new KineticUpgradeFunctions((Entity)this.getPlayer());
            functions.put("kinetic", ((KineticUpgradeFunctions)funcs).getFunctions());
        }
        if (this.hasUpgradeNonLua("cclink:chatty_upgrade")) {
            funcs = new ChattyUpgradeFunctions((Entity)this.getPlayer());
            functions.put("chatty", ((ChattyUpgradeFunctions)funcs).getFunctions());
        }
        return functions;
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        ServerPlayer plr = this.getPlayer();
        if (plr != null) {
            info.put("name", plr.m_36316_().getName());
            info.put("dimension", plr.m_9236_().m_46472_().m_135782_().toString());
            info.put("health", Float.valueOf(plr.m_21223_()));
            info.put("hunger", plr.m_36324_().m_38702_());
            info.put("saturation", Float.valueOf(plr.m_36324_().m_38722_()));
            info.put("air", plr.m_20146_());
            info.put("armor", plr.m_21230_());
            info.put("speed", Float.valueOf(plr.m_6113_()));
            info.put("yaw", Float.valueOf(plr.m_5675_(1.0f)));
            info.put("pitch", Float.valueOf(plr.m_5686_(1.0f)));
            info.put("isInPowderedSnow", plr.f_146808_);
            info.put("isInWater", plr.m_20069_());
            info.put("isHungry", plr.m_36324_().m_38721_());
        }
        return info;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult swingMainHand() {
        ServerPlayer plr = this.getPlayer();
        if (plr != null) {
            plr.m_6674_(InteractionHand.MAIN_HAND);
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object[])new Object[]{false, "player forgor"});
    }

    @LuaFunction(mainThread=true)
    public final boolean isClientside() {
        return this.getPlayer().m_9236_().f_46443_;
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> raycastBlock(double inputReach, boolean hitFluids) {
        double reach = Math.min(5.0, Math.max(1.0, inputReach));
        ClipContext.Fluid pFluidMode = ClipContext.Fluid.ANY;
        ServerPlayer plr = this.getPlayer();
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (plr != null) {
            Level lvl = plr.m_9236_();
            HitResult hitResult = plr.m_19907_(5.0, 0.0f, hitFluids);
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockHit = (BlockHitResult)hitResult;
                BlockPos pos = blockHit.m_82425_();
                String name = String.valueOf(lvl.m_8055_(pos).m_60734_().m_49954_().toString());
                Block blk = lvl.m_8055_(pos).m_60734_();
                info.put("id", ForgeRegistries.BLOCKS.getKey((Object)blk).toString());
                info.put("name", new ItemStack((ItemLike)blk).m_41611_().getString());
                info.put("x", pos.m_123341_());
                info.put("y", pos.m_123342_());
                info.put("z", pos.m_123343_());
            }
        }
        return info;
    }

    @Nullable
    @LuaFunction(mainThread=true)
    public final Map<String, Object> raycastEntity(double inputReach) {
        double reach = Math.min(5.0, Math.max(1.0, inputReach));
        HashMap<String, Object> info = new HashMap<String, Object>();
        ServerPlayer plr = this.getPlayer();
        if (plr != null) {
            Optional<Entity> hitEntity = RaycastingUtil.raycastEntity((Player)plr, reach);
            if (hitEntity.isPresent()) {
                Entity entity = hitEntity.get();
                info.put("id", ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
                info.put("uuid", entity.m_20148_().toString());
                info.put("dimension", entity.m_9236_().m_46472_().m_135782_().toString());
                info.put("x", Math.floor(entity.m_20185_()));
                info.put("y", Math.floor(entity.m_20186_()));
                info.put("z", Math.floor(entity.m_20189_()));
                info.put("yaw", Float.valueOf(entity.m_5675_(1.0f)));
                info.put("pitch", Float.valueOf(entity.m_5686_(1.0f)));
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    info.put("health", Float.valueOf(livingEntity.m_21223_()));
                    info.put("maxHealth", Float.valueOf(livingEntity.m_21233_()));
                    info.put("air", livingEntity.m_20146_());
                    info.put("maxAir", livingEntity.m_6062_());
                    info.put("armor", livingEntity.m_21230_());
                    info.put("speed", Float.valueOf(livingEntity.m_6113_()));
                    info.put("isInPowderedSnow", livingEntity.f_146808_);
                    if (livingEntity instanceof Player) {
                        Player hitPlayer = (Player)livingEntity;
                        info.put("hunger", hitPlayer.m_36324_().m_38702_());
                        info.put("saturation", Float.valueOf(hitPlayer.m_36324_().m_38722_()));
                        info.put("isHungry", hitPlayer.m_36324_().m_38721_());
                        info.put("creative", hitPlayer.m_7500_());
                        info.put("spectator", hitPlayer.m_5833_());
                    }
                }
                if (entity instanceof Player) {
                    Player hitPlayer = (Player)entity;
                    info.put("name", hitPlayer.m_36316_().getName().toString());
                } else {
                    info.put("name", entity.m_5446_().getString());
                }
                return info;
            }
            return info;
        }
        return info;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult consume(int slot) {
        --slot;
        ServerPlayer plr = this.getPlayer();
        if (plr != null) {
            Inventory inv = plr.m_150109_();
            if (inv.m_8020_(slot).m_41614_()) {
                if (plr.m_36324_().m_38721_()) {
                    plr.m_5584_(plr.m_9236_(), inv.m_8020_(slot));
                    return MethodResult.of((Object)true);
                }
                return MethodResult.of((Object[])new Object[]{false, "Player isnt hungry!"});
            }
            return MethodResult.of((Object[])new Object[]{false, "Item isnt edible!"});
        }
        return MethodResult.of((Object[])new Object[]{false, "player forgor"});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult lookAtBlock(double x, double y, double z) {
        this.getPlayer().m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(x, y, z));
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult lookAt(double x, double y) {
        ServerPlayer plr = this.getPlayer();
        if (plr != null) {
            plr.m_146926_((float)x);
            plr.m_5616_((float)y);
            return MethodResult.of((Object)true);
        }
        return MethodResult.of((Object[])new Object[]{false, "player forgor"});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult list() throws LuaException {
        Inventory inventory = this.getPlayer().m_150109_();
        if (inventory == null) {
            throw new LuaException("Player isn't present");
        }
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            items.add(LuaConverter.stackToObjectWithSlot(stack, i));
        }
        return MethodResult.of(items);
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getSlot(int slot) throws LuaException {
        return LuaConverter.stackToObject(this.getPlayer().m_150109_().m_8020_(--slot));
    }

    @LuaFunction(mainThread=true)
    public final boolean moveItem(int fromSlot, int count, int toSlot) throws LuaException {
        --fromSlot;
        --toSlot;
        if (count > 0) {
            Inventory inv = this.getPlayer().m_150109_();
            ItemStack fromSlotItem = inv.m_8020_(fromSlot);
            ItemStack toSlotItem = inv.m_8020_(toSlot);
            if (inv.m_36063_(fromSlotItem) && fromSlotItem.m_41613_() >= count) {
                if (toSlotItem.m_41720_() == Items.f_41852_) {
                    ItemStack copiedItem = fromSlotItem.m_41777_();
                    copiedItem.m_41764_(count);
                    inv.m_6836_(toSlot, copiedItem);
                    fromSlotItem.m_41764_(fromSlotItem.m_41613_() - count);
                    return true;
                }
                if (toSlotItem.m_41720_() == fromSlotItem.m_41720_()) {
                    if (toSlotItem.m_41613_() + count > toSlotItem.m_41741_()) {
                        throw new LuaException("Cannot be above max stack size!");
                    }
                    toSlotItem.m_41764_(toSlotItem.m_41613_() + count);
                    fromSlotItem.m_41764_(fromSlotItem.m_41613_() - count);
                    return true;
                }
            }
        } else {
            throw new LuaException("Count cant be below zero!");
        }
        return false;
    }
}

