/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.item.LinkCore;

import com.awesoft.cclink.item.LinkCore.LinkCoreComputerItem;
import com.awesoft.cclink.item.LinkCore.LinkHolder;
import com.awesoft.cclink.item.LinkCore.LinkServerComputer;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public final class LinkBrain
implements IPocketAccess {
    private final LinkServerComputer computer;
    private LinkHolder holder;
    private Vec3 position;
    private boolean dirty = false;
    @Nullable
    private UpgradeData<IPocketUpgrade> upgrade;
    private int colour = -1;
    private int lightColour = -1;

    public LinkBrain(LinkHolder holder, @Nullable UpgradeData<IPocketUpgrade> upgrade, ServerComputer.Properties properties) {
        this.computer = new LinkServerComputer(this, holder, properties.terminalSize(39, 13));
        this.holder = holder;
        this.position = holder.pos();
        this.upgrade = UpgradeData.copyOf(upgrade);
        this.invalidatePeripheral();
    }

    public LinkServerComputer computer() {
        return this.computer;
    }

    public int getSelectedSlot() {
        return 1;
    }

    LinkHolder holder() {
        return this.holder;
    }

    public void addPeripheral(ComputerSide side, IPeripheral peripheral) {
        this.computer.setPeripheral(side, peripheral);
    }

    public boolean canPlayerUse(Player player) {
        return true;
    }

    public void updateHolder(LinkHolder newHolder) {
        this.position = newHolder.pos();
        this.computer.setPosition(newHolder.level(), newHolder.blockPos());
        LinkHolder oldHolder = this.holder;
        if (!this.holder.equals(newHolder)) {
            this.holder = newHolder;
            if (oldHolder instanceof LinkHolder.PlayerHolder) {
                LinkHolder.PlayerHolder p = (LinkHolder.PlayerHolder)oldHolder;
                ServerPlayer var10000 = p.entity();
            } else if (oldHolder instanceof LinkHolder.PlayerCuriosHolder) {
                LinkHolder.PlayerCuriosHolder p = (LinkHolder.PlayerCuriosHolder)oldHolder;
                ServerPlayer var10000 = p.entity();
            } else {
                Object var3_7 = null;
            }
        }
    }

    public boolean updateItem(ItemStack stack) {
        if (!this.dirty) {
            return false;
        }
        this.dirty = false;
        IColouredItem.setColourBasic((ItemStack)stack, (int)this.colour);
        LinkCoreComputerItem.setUpgrade(stack, (UpgradeData<IPocketUpgrade>)UpgradeData.copyOf(this.upgrade));
        return true;
    }

    public ServerLevel getLevel() {
        return this.computer.getLevel();
    }

    public Vec3 getPosition() {
        return this.position;
    }

    @Nullable
    public Entity getEntity() {
        LinkHolder.EntityHolder entity;
        LinkHolder var2 = this.holder;
        if (var2 instanceof LinkHolder.EntityHolder) {
            entity = (LinkHolder.EntityHolder)var2;
            if (this.holder.isValid(this.computer)) {
                Entity var10000 = entity.entity();
                return var10000;
            }
        }
        if (var2 instanceof LinkHolder.PlayerCuriosHolder) {
            entity = (LinkHolder.PlayerCuriosHolder)var2;
            if (this.holder.isValid(this.computer)) {
                ServerPlayer var10000 = ((LinkHolder.PlayerCuriosHolder)entity).entity();
                return var10000;
            }
        }
        Entity var10000 = null;
        return var10000;
    }

    public int getColour() {
        return this.colour;
    }

    public void setColour(int colour) {
        if (this.colour != colour) {
            this.dirty = true;
            this.colour = colour;
        }
    }

    public int getLight() {
        return this.lightColour;
    }

    public void setLight(int colour) {
        if (colour < 0 || colour > 0xFFFFFF) {
            colour = -1;
        }
        this.lightColour = colour;
    }

    public CompoundTag getUpgradeNBTData() {
        UpgradeData<IPocketUpgrade> upgrade = this.upgrade;
        return upgrade == null ? new CompoundTag() : upgrade.data();
    }

    public void updateUpgradeNBTData() {
        this.dirty = true;
    }

    public void invalidatePeripheral() {
        IPeripheral peripheral = this.upgrade == null ? null : ((IPocketUpgrade)this.upgrade.upgrade()).createPeripheral((IPocketAccess)this);
        this.computer.setPeripheral(ComputerSide.BACK, peripheral);
    }

    @Deprecated(forRemoval=true)
    public Map<ResourceLocation, IPeripheral> getUpgrades() {
        UpgradeData<IPocketUpgrade> upgrade = this.upgrade;
        return upgrade == null ? Map.of() : Collections.singletonMap(((IPocketUpgrade)upgrade.upgrade()).getUpgradeID(), this.computer.getPeripheral(ComputerSide.BACK));
    }

    @Nullable
    public UpgradeData<IPocketUpgrade> getUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(@Nullable UpgradeData<IPocketUpgrade> upgrade) {
        if (!Objects.equals(this.upgrade, upgrade)) {
            this.upgrade = UpgradeData.copyOf(upgrade);
            this.dirty = true;
            this.invalidatePeripheral();
        }
    }
}

