/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.libs;

import com.awesoft.cclink.Registration.ItemRegistry;
import com.awesoft.cclink.gui.LinkMenu;
import com.awesoft.cclink.gui.integrated.IntegratedLinkMenu;
import com.awesoft.cclink.item.LinkCore.Integrated.IntegratedLinkBrain;
import com.awesoft.cclink.item.LinkCore.Integrated.IntegratedLinkHolder;
import com.awesoft.cclink.item.LinkCore.Integrated.IntegratedLinkServerComputer;
import com.awesoft.cclink.item.LinkCore.LinkBrain;
import com.awesoft.cclink.item.LinkCore.LinkHolder;
import com.awesoft.cclink.item.LinkCore.LinkServerComputer;
import com.awesoft.cclink.libs.ItemHandlerContainer;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.container.SingleContainerData;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;

public class ComputerLib {
    @Nullable
    public static IPocketUpgrade getUpgrade(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        return compound != null && compound.m_128441_("Upgrade") ? (IPocketUpgrade)PocketUpgrades.instance().get(compound.m_128461_("Upgrade")) : null;
    }

    public static void openLinkImpl(Player player, ItemStack stack, LinkHolder holder, boolean isTypingOnly, ServerComputer computer, boolean curios) {
        PlatformHelper.get().openMenu(player, stack.m_41786_(), (id, inventory, entity) -> new LinkMenu(id, p -> true, ComputerFamily.ADVANCED, computer, null, player.m_150109_(), new ItemHandlerContainer((IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null)), (net.minecraft.world.inventory.ContainerData)new SingleContainerData(){

            public int get() {
                return 1;
            }
        }), (ContainerData)new ComputerContainerData(computer, stack));
    }

    public static void openIntegratedLinkImpl(Player player, ItemStack stack, IntegratedLinkHolder holder, boolean isTypingOnly, ServerComputer computer, boolean curios) {
        PlatformHelper.get().openMenu(player, stack.m_41786_(), (id, inventory, entity) -> new IntegratedLinkMenu(id, p -> true, ComputerFamily.ADVANCED, computer, null, player.m_150109_(), new ItemHandlerContainer((IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null)), (net.minecraft.world.inventory.ContainerData)new SingleContainerData(){

            public int get() {
                return 1;
            }
        }), (ContainerData)new ComputerContainerData(computer, stack));
    }

    public static Container getContainerFromItem(ItemStack item) {
        IItemHandler handler = (IItemHandler)item.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(null);
        if (handler != null) {
            return new ItemHandlerContainer(handler);
        }
        return null;
    }

    public static boolean hasUpgrade(String upgradeid, ItemStack stack) {
        Item id = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(upgradeid));
        Set<Item> items = Set.of(id);
        ItemHandlerContainer Inv = new ItemHandlerContainer((IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null));
        return Inv.m_18949_(items);
    }

    public static Container getContainerFromLinkHolder(Entity ent) {
        AtomicReference<ItemHandlerContainer> linkInv = new AtomicReference<ItemHandlerContainer>();
        if (ent instanceof ItemEntity) {
            ItemEntity itement = (ItemEntity)ent;
            IItemHandler handler = (IItemHandler)itement.m_32055_().getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(null);
            if (handler != null) {
                linkInv.set(new ItemHandlerContainer(handler));
            }
        } else if (ent instanceof ServerPlayer) {
            ServerPlayer plr = (ServerPlayer)ent;
            CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)plr, (Item)ItemRegistry.LINK_CORE.get()).ifPresent(slotResult -> {
                ItemStack linkItem = slotResult.stack();
                IItemHandler handler = (IItemHandler)linkItem.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(null);
                if (handler != null) {
                    linkInv.set(new ItemHandlerContainer(handler));
                }
            });
            CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)plr, (Item)ItemRegistry.LINK_CORE_COMMAND.get()).ifPresent(slotResult -> {
                ItemStack linkItem = slotResult.stack();
                IItemHandler handler = (IItemHandler)linkItem.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(null);
                if (handler != null) {
                    linkInv.set(new ItemHandlerContainer(handler));
                }
            });
            for (ItemStack stack : plr.m_6167_()) {
                IItemHandler handler;
                if (stack.m_41619_() || !stack.m_150930_((Item)ItemRegistry.LINK_CORE.get()) && !stack.m_150930_((Item)ItemRegistry.LINK_CORE_COMMAND.get()) || (handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(null)) == null) continue;
                linkInv.set(new ItemHandlerContainer(handler));
            }
        }
        return (Container)linkInv.get();
    }

    public static Container getContainerFromIntegratedLinkHolder(Entity ent) {
        AtomicReference<ItemHandlerContainer> linkInv = new AtomicReference<ItemHandlerContainer>();
        if (ent instanceof ItemEntity) {
            ItemEntity itement = (ItemEntity)ent;
            IItemHandler handler = (IItemHandler)itement.m_32055_().getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(null);
            if (handler != null) {
                linkInv.set(new ItemHandlerContainer(handler));
            }
        } else if (ent instanceof ServerPlayer) {
            ServerPlayer plr = (ServerPlayer)ent;
            CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)plr, (Item)ItemRegistry.INTEGRATED_LINK_CORE.get()).ifPresent(slotResult -> {
                ItemStack linkItem = slotResult.stack();
                IItemHandler handler = (IItemHandler)linkItem.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(null);
                if (handler != null) {
                    linkInv.set(new ItemHandlerContainer(handler));
                }
            });
            for (ItemStack stack : plr.m_6167_()) {
                IItemHandler handler;
                if (stack.m_41619_() || !stack.m_150930_((Item)ItemRegistry.INTEGRATED_LINK_CORE.get()) || (handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(null)) == null) continue;
                linkInv.set(new ItemHandlerContainer(handler));
            }
        }
        return (Container)linkInv.get();
    }

    public static LinkBrain getOrCreateBrain(ServerLevel level, LinkHolder holder, ItemStack stack, ComputerFamily family) {
        ServerComputerRegistry registry = ServerContext.get((MinecraftServer)level.m_7654_()).registry();
        LinkServerComputer computer = ComputerLib.getServerComputer(registry, stack);
        if (computer != null) {
            LinkBrain brain = computer.getBrain();
            brain.updateHolder(holder);
            return brain;
        }
        int computerID = ComputerLib.getComputerID(stack);
        if (computerID < 0) {
            computerID = ComputerCraftAPI.createUniqueNumberedSaveDir((MinecraftServer)level.m_7654_(), (String)"computer");
            ComputerLib.setComputerID(stack, computerID);
        }
        LinkBrain brain = new LinkBrain(holder, ComputerLib.getUpgradeWithData(stack), ServerComputer.properties((int)ComputerLib.getComputerID(stack), (ComputerFamily)family).label(ComputerLib.getLabel(stack)));
        LinkServerComputer computerSigma = brain.computer();
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("SessionId", registry.getSessionID());
        tag.m_128362_("InstanceId", computerSigma.register());
        if (ComputerLib.isMarkedOn(stack)) {
            computerSigma.turnOn();
        }
        ComputerLib.updateItem(stack, brain);
        holder.setChanged();
        return brain;
    }

    public static boolean updateItem(ItemStack stack, LinkBrain brain) {
        boolean on;
        String label;
        boolean changed = brain.updateItem(stack);
        LinkServerComputer computer = brain.computer();
        int id = computer.getID();
        if (id != ComputerLib.getComputerID(stack)) {
            changed = true;
            ComputerLib.setComputerID(stack, id);
        }
        if (!Objects.equals(label = computer.getLabel(), ComputerLib.getLabel(stack))) {
            changed = true;
            ComputerLib.setLabel(stack, label);
        }
        if ((on = computer.isOn()) != ComputerLib.isMarkedOn(stack)) {
            changed = true;
            stack.m_41784_().m_128379_("On", on);
        }
        return changed;
    }

    public static boolean updateIntegratedItem(ItemStack stack, IntegratedLinkBrain brain) {
        boolean on;
        String label;
        boolean changed = brain.updateItem(stack);
        IntegratedLinkServerComputer computer = brain.computer();
        int id = computer.getID();
        if (id != ComputerLib.getComputerID(stack)) {
            changed = true;
            ComputerLib.setComputerID(stack, id);
        }
        if (!Objects.equals(label = computer.getLabel(), ComputerLib.getLabel(stack))) {
            changed = true;
            ComputerLib.setLabel(stack, label);
        }
        if ((on = computer.isOn()) != ComputerLib.isMarkedOn(stack)) {
            changed = true;
            stack.m_41784_().m_128379_("On", on);
        }
        return changed;
    }

    public static IntegratedLinkBrain getOrCreateIntegratedBrain(ServerLevel level, IntegratedLinkHolder holder, ItemStack stack, ComputerFamily family) {
        ServerComputerRegistry registry = ServerContext.get((MinecraftServer)level.m_7654_()).registry();
        IntegratedLinkServerComputer computer = ComputerLib.getIntegratedServerComputer(registry, stack);
        if (computer != null) {
            IntegratedLinkBrain brain = computer.getBrain();
            brain.updateHolder(holder);
            return brain;
        }
        int computerID = ComputerLib.getComputerID(stack);
        if (computerID < 0) {
            computerID = ComputerCraftAPI.createUniqueNumberedSaveDir((MinecraftServer)level.m_7654_(), (String)"computer");
            ComputerLib.setComputerID(stack, computerID);
        }
        IntegratedLinkBrain brain = new IntegratedLinkBrain(holder, ComputerLib.getUpgradeWithData(stack), ServerComputer.properties((int)ComputerLib.getComputerID(stack), (ComputerFamily)family).label(ComputerLib.getLabel(stack)));
        IntegratedLinkServerComputer computerSigma = brain.computer();
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("SessionId", registry.getSessionID());
        tag.m_128362_("InstanceId", computerSigma.register());
        if (ComputerLib.isMarkedOn(stack)) {
            computerSigma.turnOn();
        }
        ComputerLib.updateIntegratedItem(stack, brain);
        holder.setChanged();
        return brain;
    }

    public static int getComputerID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_("ComputerId") ? nbt.m_128451_("ComputerId") : -1;
    }

    public static void setComputerID(ItemStack stack, int computerID) {
        stack.m_41784_().m_128405_("ComputerId", computerID);
    }

    @Nullable
    public static String getLabel(ItemStack stack) {
        return stack.m_41788_() ? stack.m_41786_().getString() : null;
    }

    public static boolean isMarkedOn(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128471_("On");
    }

    public static boolean setLabel(ItemStack stack, @Nullable String label) {
        if (label != null) {
            stack.m_41714_((Component)Component.m_237113_((String)label));
        } else {
            stack.m_41787_();
        }
        return true;
    }

    @Nullable
    public static LinkServerComputer getServerComputer(ServerComputerRegistry registry, ItemStack stack) {
        return (LinkServerComputer)registry.get(ComputerLib.getSessionID(stack), ComputerLib.getInstanceID(stack));
    }

    @Nullable
    public static IntegratedLinkServerComputer getIntegratedServerComputer(ServerComputerRegistry registry, ItemStack stack) {
        return (IntegratedLinkServerComputer)registry.get(ComputerLib.getSessionID(stack), ComputerLib.getInstanceID(stack));
    }

    @Nullable
    public static LinkServerComputer getServerComputer(MinecraftServer server, ItemStack stack) {
        return ComputerLib.getServerComputer(ServerContext.get((MinecraftServer)server).registry(), stack);
    }

    @Nullable
    public static UUID getInstanceID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128403_("InstanceId") ? nbt.m_128342_("InstanceId") : null;
    }

    public static int getSessionID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_("SessionId") ? nbt.m_128451_("SessionId") : -1;
    }

    @Nullable
    public static UpgradeData<IPocketUpgrade> getUpgradeWithData(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128441_("Upgrade")) {
            IPocketUpgrade upgrade = (IPocketUpgrade)PocketUpgrades.instance().get(compound.m_128461_("Upgrade"));
            return upgrade == null ? null : UpgradeData.of((UpgradeBase)upgrade, (CompoundTag)NBTUtil.getCompoundOrEmpty((CompoundTag)compound, (String)"UpgradeInfo"));
        }
        return null;
    }
}

