/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.upgrades.luaFunctions;

import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.ILuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;

public class IntrospectionUpgradeFunctions {
    public Map<String, Object> functions = new HashMap<String, Object>();
    Entity entity;
    public ILuaFunction list = args -> {
        Inventory inv = this.getInventory();
        PlayerEnderChestContainer ender = this.getEnderInventory();
        if (inv == null || ender == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player doesnt exist!"});
        }
        Inventory contain1 = null;
        if (args.getString(0).equalsIgnoreCase("inv")) {
            contain1 = inv;
        }
        if (args.getString(0).equalsIgnoreCase("ender")) {
            contain1 = ender;
        }
        if (contain1 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Invalid Inventory type! Please use \"inv\" or \"ender\"!"});
        }
        HashMap<Integer, Map> result = new HashMap<Integer, Map>();
        int size = contain1.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = contain1.m_8020_(i);
            if (stack.m_41619_()) continue;
            result.put(i + 1, VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)stack));
        }
        return MethodResult.of(result);
    };
    public ILuaFunction moveItems = args -> {
        Inventory inv = this.getInventory();
        PlayerEnderChestContainer ender = this.getEnderInventory();
        if (inv == null || ender == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player doesnt exist!"});
        }
        Inventory contain1 = null;
        Inventory contain2 = null;
        if (args.getString(0).equalsIgnoreCase("inv")) {
            contain1 = inv;
        }
        if (args.getString(1).equalsIgnoreCase("inv")) {
            contain2 = inv;
        }
        if (args.getString(0).equalsIgnoreCase("ender")) {
            contain1 = ender;
        }
        if (args.getString(1).equalsIgnoreCase("ender")) {
            contain2 = ender;
        }
        if (contain1 == null || contain2 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Invalid Inventories! Please use \"inv\" or \"ender\"!"});
        }
        int fromSlot = args.getInt(2);
        int limit = args.getInt(3);
        int toSlot = args.getInt(4);
        MethodResult result = this.moveItemTo((Container)contain1, (Container)contain2, fromSlot, limit, toSlot);
        return MethodResult.of((Object)result);
    };
    public ILuaFunction getItemDetail = args -> {
        Inventory inv = this.getInventory();
        PlayerEnderChestContainer ender = this.getEnderInventory();
        if (inv == null || ender == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player doesnt exist!"});
        }
        Inventory contain1 = null;
        if (args.getString(1).equalsIgnoreCase("inv")) {
            contain1 = inv;
        }
        if (args.getString(1).equalsIgnoreCase("ender")) {
            contain1 = ender;
        }
        if (contain1 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Invalid Inventory type! Please use \"inv\" or \"ender\"!"});
        }
        int slotNum = Math.max(0, Math.min(contain1.m_6643_(), args.getInt(0) - 1));
        return MethodResult.of((Object)VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)contain1.m_8020_(slotNum)));
    };
    public ILuaFunction getItemLimit = args -> {
        Inventory inv = this.getInventory();
        PlayerEnderChestContainer ender = this.getEnderInventory();
        if (inv == null || ender == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player doesnt exist!"});
        }
        Inventory contain1 = null;
        if (args.getString(1).equalsIgnoreCase("inv")) {
            contain1 = inv;
        }
        if (args.getString(1).equalsIgnoreCase("ender")) {
            contain1 = ender;
        }
        if (contain1 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Invalid Inventory type! Please use \"inv\" or \"ender\"!"});
        }
        int slotNum = Math.max(0, Math.min(contain1.m_6643_(), args.getInt(0) - 1));
        return MethodResult.of((Object)contain1.m_8020_(slotNum).m_41741_());
    };
    public ILuaFunction size = args -> {
        Inventory inv = this.getInventory();
        PlayerEnderChestContainer ender = this.getEnderInventory();
        if (inv == null || ender == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player doesnt exist!"});
        }
        Inventory contain1 = null;
        if (args.getString(0).equalsIgnoreCase("inv")) {
            contain1 = inv;
        }
        if (args.getString(0).equalsIgnoreCase("ender")) {
            contain1 = ender;
        }
        if (contain1 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Invalid Inventory type! Please use 'inv', 'ender' or 'curios'!"});
        }
        return MethodResult.of((Object)contain1.m_6643_());
    };

    public IntrospectionUpgradeFunctions(Entity entity) {
        this.entity = entity;
    }

    public final ServerPlayer getPlayer() {
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return player;
        }
        return null;
    }

    public final Inventory getInventory() {
        if (this.getPlayer() == null) {
            return null;
        }
        return this.getPlayer().m_150109_();
    }

    public PlayerEnderChestContainer getEnderInventory() {
        return this.getPlayer() != null ? this.getPlayer().m_36327_() : null;
    }

    public MethodResult moveItemTo(Container from, Container to, int fromSlot, int limit, int toSlot) {
        ItemStack fromItem = from.m_8020_(Math.max(0, fromSlot - 1));
        ItemStack toItem = to.m_8020_(Math.max(0, toSlot - 1));
        if (fromItem.m_41619_()) {
            return MethodResult.of((Object[])new Object[]{false, "From slot is empty!"});
        }
        if (toItem.m_41619_()) {
            if (fromItem.m_41613_() < limit) {
                return MethodResult.of((Object[])new Object[]{false, "From slot has too few items!"});
            }
            ItemStack moved = fromItem.m_41777_();
            moved.m_41764_(limit);
            fromItem.m_41774_(limit);
            from.m_6836_(Math.max(0, fromSlot - 1), fromItem);
            to.m_6836_(Math.max(0, toSlot - 1), moved);
            return MethodResult.of((Object[])new Object[]{true, limit});
        }
        if (toItem.m_41720_() != fromItem.m_41720_()) {
            return MethodResult.of((Object[])new Object[]{false, "To slot doesn't contain the same item!"});
        }
        if (!Objects.equals(toItem.m_41783_(), fromItem.m_41783_())) {
            return MethodResult.of((Object[])new Object[]{false, "Both items' NBT do not match."});
        }
        int transferable = Math.min(limit, fromItem.m_41613_());
        int space = toItem.m_41741_() - toItem.m_41613_();
        int movedAmount = Math.min(transferable, space);
        fromItem.m_41774_(movedAmount);
        toItem.m_41769_(movedAmount);
        from.m_6836_(Math.max(0, fromSlot - 1), fromItem);
        to.m_6836_(Math.max(0, toSlot - 1), toItem);
        return MethodResult.of((Object[])new Object[]{true, movedAmount});
    }

    public Map<String, Object> getFunctions() {
        this.functions.put("list", this.list);
        this.functions.put("moveItems", this.moveItems);
        this.functions.put("getItemDetail", this.getItemDetail);
        this.functions.put("getItemLimit", this.getItemLimit);
        this.functions.put("size", this.size);
        return this.functions;
    }
}

