/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.upgrades.luaFunctions;

import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.ILuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ScannerUpgradeFunctions {
    public Map<String, Object> functions = new HashMap<String, Object>();
    Entity entity;
    IComputerSystem computer;
    private static final Map<Integer, Integer> lastCalledMap = new HashMap<Integer, Integer>();
    private static final int cooldownTime = 2000;
    public ILuaFunction scan = args -> {
        if (!this.canCallFunction(this.computer.getID())) {
            return MethodResult.of((Object[])new Object[]{null, "On cooldown!"});
        }
        lastCalledMap.put(this.computer.getID(), (int)(System.currentTimeMillis() % Integer.MAX_VALUE));
        if (args.getInt(0) > 8) {
            return MethodResult.of((Object[])new Object[]{false, "Cannot be bigger than 8 block radius!"});
        }
        int radius = args.getInt(0);
        return MethodResult.of(ScannerUpgradeFunctions.scan(this.entity.m_9236_(), this.entity.m_20097_(), radius));
    };
    public ILuaFunction getOperationCooldown = args -> MethodResult.of((Object)this.getRemainingCooldownTime(this.computer.getID()));

    public ScannerUpgradeFunctions(Entity entity, IComputerSystem computer) {
        this.entity = entity;
        this.computer = computer;
    }

    public static void relativeTraverseBlocks(Level world, BlockPos center, int radius, BiConsumer<BlockState, BlockPos> consumer) {
        ScannerUpgradeFunctions.traverseBlocks(world, center, radius, consumer, true);
    }

    public static void traverseBlocks(Level world, BlockPos center, int radius, BiConsumer<BlockState, BlockPos> consumer, boolean relativePosition) {
        int x = center.m_123341_();
        int y = center.m_123342_();
        int z = center.m_123343_();
        for (int oX = x - radius; oX <= x + radius; ++oX) {
            for (int oY = y - radius; oY <= y + radius; ++oY) {
                for (int oZ = z - radius; oZ <= z + radius; ++oZ) {
                    BlockPos subPos = new BlockPos(oX, oY, oZ);
                    BlockState blockState = world.m_8055_(subPos);
                    if (blockState.m_60795_()) continue;
                    if (relativePosition) {
                        consumer.accept(blockState, new BlockPos(oX - x, oY - y, oZ - z));
                        continue;
                    }
                    consumer.accept(blockState, subPos);
                }
            }
        }
    }

    public static String convertToBlockId(Block blk) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)blk).toString();
    }

    public static <T> List<String> tagsToList(@NotNull Supplier<Stream<TagKey<T>>> tags) {
        if (tags.get().findAny().isEmpty()) {
            return Collections.emptyList();
        }
        return tags.get().map(ScannerUpgradeFunctions::tagToString).toList();
    }

    public static <T> String tagToString(@NotNull TagKey<T> tag) {
        return String.valueOf(tag.f_203867_().m_135782_()) + "/" + String.valueOf(tag.f_203868_());
    }

    private static List<Map<String, ?>> scan(Level level, BlockPos center, int radius) {
        ArrayList result = new ArrayList();
        ScannerUpgradeFunctions.relativeTraverseBlocks(level, center, radius, (state, pos) -> {
            HashMap<String, Object> data = new HashMap<String, Object>(6);
            data.put("x", pos.m_123341_());
            data.put("y", pos.m_123342_());
            data.put("z", pos.m_123343_());
            Block block = state.m_60734_();
            data.put("name", ScannerUpgradeFunctions.convertToBlockId(block));
            data.put("tags", ScannerUpgradeFunctions.tagsToList(() -> block.m_204297_().m_203616_()));
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                data.put("direction", ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122433_());
            }
            if (state.m_61138_((Property)BlockStateProperties.f_155997_)) {
                data.put("direction_vertical", ((Direction)state.m_61143_((Property)BlockStateProperties.f_155997_)).m_122433_());
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61402_)) {
                data.put("half", ((Half)state.m_61143_((Property)BlockStateProperties.f_61402_)).toString());
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
                data.put("axis", ((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)).toString());
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61448_)) {
                data.put("powered", state.m_61143_((Property)BlockStateProperties.f_61448_));
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61426_)) {
                data.put("powerlvl", state.m_61143_((Property)BlockStateProperties.f_61426_));
            }
            result.add(data);
        });
        return result;
    }

    private int getRemainingCooldownTime(int computerId) {
        int lastCalled = lastCalledMap.getOrDefault(computerId, 0);
        int currentTime = (int)(System.currentTimeMillis() % Integer.MAX_VALUE);
        int elapsed = currentTime - lastCalled;
        if (elapsed < 0) {
            elapsed += Integer.MAX_VALUE;
        }
        return Math.max(0, 2000 - elapsed);
    }

    private boolean canCallFunction(int computerId) {
        int remainingTime = this.getRemainingCooldownTime(computerId);
        return remainingTime <= 0;
    }

    public Map<String, Object> getFunctions() {
        this.functions.put("scan", this.scan);
        this.functions.put("getOperationCooldown", this.getOperationCooldown);
        return this.functions;
    }
}

