/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.cclink.upgrades.luaFunctions;

import com.awesoft.cclink.libs.LuaConverter;
import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.ILuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SensorUpgradeFunctions {
    public Map<String, Object> functions = new HashMap<String, Object>();
    Entity entity;
    IComputerSystem computer;
    private static final Map<Integer, Integer> lastCalledMap = new HashMap<Integer, Integer>();
    private static final int cooldownTime = 2000;
    public ILuaFunction sense = args -> {
        ArrayList<Map<String, Object>> entitiesList = new ArrayList<Map<String, Object>>(List.of());
        if (!this.canCallFunction(this.computer.getID())) {
            return MethodResult.of((Object[])new Object[]{null, "On cooldown!"});
        }
        lastCalledMap.put(this.computer.getID(), (int)(System.currentTimeMillis() % Integer.MAX_VALUE));
        if (args.getInt(0) > 16) {
            return MethodResult.of((Object[])new Object[]{false, "Cannot be bigger than 16 block radius!"});
        }
        int radius = args.getInt(0);
        Level level = this.entity.m_9236_();
        BlockPos pos = this.entity.m_20097_();
        AABB box = new AABB((double)(pos.m_123341_() - radius), (double)(pos.m_123342_() - radius), (double)(pos.m_123343_() - radius), (double)(pos.m_123341_() + radius), (double)(pos.m_123342_() + radius), (double)(pos.m_123343_() + radius));
        List entities = level.m_45933_(this.entity, box);
        for (Entity e : entities) {
            entitiesList.add(LuaConverter.completeEntityToLua(e, new ItemStack((ItemLike)Items.f_41852_)));
        }
        return MethodResult.of(entitiesList);
    };
    public ILuaFunction getOperationCooldown = args -> MethodResult.of((Object)this.getRemainingCooldownTime(this.computer.getID()));

    public SensorUpgradeFunctions(Entity entity, IComputerSystem computer) {
        this.entity = entity;
        this.computer = computer;
    }

    private int getRemainingCooldownTime(int computerId) {
        int lastCalled = lastCalledMap.getOrDefault(computerId, 0);
        int currentTime = (int)(System.currentTimeMillis() % Integer.MAX_VALUE);
        int elapsed = currentTime - lastCalled;
        if (elapsed < 0) {
            elapsed += Integer.MAX_VALUE;
        }
        return Math.max(0, 2000 - elapsed);
    }

    private boolean canCallFunction(int computerId) {
        int remainingTime = this.getRemainingCooldownTime(computerId);
        return remainingTime <= 0;
    }

    public Map<String, Object> getFunctions() {
        this.functions.put("sense", this.sense);
        this.functions.put("getOperationCooldown", this.getOperationCooldown);
        return this.functions;
    }
}

