/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.CameraMod;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class ClientEvents {
    private static final ResourceLocation VIEWFINDER = ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"textures/gui/viewfinder_overlay.png");
    private static final ResourceLocation ZOOM = ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"textures/gui/zoom.png");
    public static final float MAX_FOV = 90.0f;
    public static final float MIN_FOV = 5.0f;
    private Minecraft mc = Minecraft.getInstance();
    private boolean inCameraMode = false;
    private float fov = 0.0f;
    private ResourceLocation currentShader;

    @SubscribeEvent
    public void renderOverlay(RenderGuiLayerEvent.Pre event) {
        this.inCameraMode = this.isInCameraMode();
        if (!this.inCameraMode) {
            this.setShader(null);
            return;
        }
        event.setCanceled(true);
        this.mc.options.setCameraType(CameraType.FIRST_PERSON);
        this.setShader(this.getShader((Player)this.mc.player));
        this.drawViewFinder(event.getGuiGraphics());
        this.drawZoom(event.getGuiGraphics(), this.getFOVPercentage());
    }

    private void drawViewFinder(GuiGraphics guiGraphics) {
        float hnew;
        float wnew;
        float ri;
        float hs;
        int imageWidth = 192;
        int imageHeight = 100;
        float ws = this.mc.getWindow().getGuiScaledWidth();
        float rs = ws / (hs = (float)this.mc.getWindow().getGuiScaledHeight());
        if (rs > (ri = (float)imageWidth / (float)imageHeight)) {
            wnew = (float)imageWidth * hs / (float)imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = (float)imageHeight * ws / (float)imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, VIEWFINDER, (int)left, (int)top, 0.0f, 0.0f, (int)wnew, (int)hnew, 192, 100, 256, 256);
    }

    private void drawZoom(GuiGraphics guiGraphics, float percent) {
        int zoomWidth = 112;
        int zoomHeight = 10;
        int width = this.mc.getWindow().getGuiScaledWidth();
        int height = this.mc.getWindow().getGuiScaledHeight();
        int left = (width - zoomWidth) / 2;
        int top = height / 40;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ZOOM, left, top, 0.0f, 0.0f, zoomWidth, zoomHeight, zoomWidth, zoomHeight, 128, 128);
        int percWidth = (int)(Math.max(Math.min((double)percent, 1.0), 0.0) * (double)zoomWidth);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ZOOM, left, top, 0.0f, (float)zoomHeight, percWidth, zoomHeight, percWidth, zoomHeight, 128, 128);
    }

    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        if (this.inCameraMode) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(ScreenEvent.Opening event) {
        if (this.inCameraMode && event.getScreen() instanceof PauseScreen) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageDisableCameraMode(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
        }
    }

    private ResourceLocation getShader(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.getItem().equals(CameraMod.CAMERA.get())) continue;
            return Shaders.getShader((String)stack.get(CameraMod.SHADER_DATA_COMPONENT));
        }
        return null;
    }

    private void setShader(ResourceLocation shader) {
        if (shader == null) {
            if (this.currentShader != null) {
                this.mc.gameRenderer.clearPostEffect();
            }
        } else if (!shader.equals((Object)this.currentShader)) {
            try {
                this.mc.gameRenderer.setPostEffect(shader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentShader = shader;
    }

    @SubscribeEvent
    public void renderPlayer(ClientTickEvent.Pre event) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        List players = level.players();
        for (AbstractClientPlayer player : players) {
            if (player == this.mc.player) continue;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = player.getItemInHand(hand);
                if (!(stack.getItem() instanceof CameraItem)) continue;
                if (((CameraItem)((Object)CameraMod.CAMERA.get())).isActive(stack)) {
                    player.startUsingItem(hand);
                    continue;
                }
                player.stopUsingItem();
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollingEvent event) {
        if (event.getScrollDeltaY() == 0.0) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        this.fov = event.getScrollDeltaY() < 0.0 ? Math.min(this.fov + 5.0f, 90.0f) : Math.max(this.fov - 5.0f, 5.0f);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onFOVModifierEvent(ViewportEvent.ComputeFov event) {
        if (!this.inCameraMode) {
            this.fov = event.getFOV();
            return;
        }
        this.mc.player.setPos(this.mc.player.getX(), this.mc.player.getY() + 1.0E-9, this.mc.player.getZ());
        event.setFOV(this.fov);
    }

    public float getFOVPercentage() {
        return 1.0f - (this.fov - 5.0f) / 85.0f;
    }

    private ItemStack getActiveCamera() {
        if (this.mc.player == null) {
            return null;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = this.mc.player.getItemInHand(hand);
            if (!stack.getItem().equals(CameraMod.CAMERA.get()) || !((CameraItem)((Object)CameraMod.CAMERA.get())).isActive(stack)) continue;
            return stack;
        }
        return null;
    }

    private boolean isInCameraMode() {
        return this.getActiveCamera() != null;
    }
}

