/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.items;

import de.maxhenkel.camera.CameraClientMod;
import de.maxhenkel.camera.CameraMod;
import de.maxhenkel.camera.ModSounds;
import de.maxhenkel.camera.corelib.item.ItemUtils;
import de.maxhenkel.camera.net.MessageTakeImage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class CameraItem
extends Item {
    public CameraItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResult use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown() && !this.isActive(stack)) {
            if (worldIn.isClientSide()) {
                CameraClientMod.openCameraScreen((String)stack.get(CameraMod.SHADER_DATA_COMPONENT));
            }
            return InteractionResult.SUCCESS;
        }
        if (!(playerIn instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
        if (!this.isActive(stack)) {
            ((CameraItem)((Object)CameraMod.CAMERA.get())).setActive(stack, true);
        } else if (CameraMod.PACKET_MANAGER.canTakeImage(playerIn.getUUID())) {
            if (CameraItem.consumePaper(playerIn)) {
                worldIn.playSound(null, playerIn.blockPosition(), (SoundEvent)ModSounds.TAKE_IMAGE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                UUID uuid = UUID.randomUUID();
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MessageTakeImage(uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((CameraItem)((Object)CameraMod.CAMERA.get())).setActive(stack, false);
            } else {
                playerIn.displayClientMessage((Component)Component.translatable((String)"message.no_consumable"), true);
            }
        } else {
            playerIn.displayClientMessage((Component)Component.translatable((String)"message.image_cooldown"), true);
        }
        return InteractionResult.SUCCESS;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 50000;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        if (this.isActive(stack)) {
            return ItemUseAnimation.BOW;
        }
        return ItemUseAnimation.NONE;
    }

    public static boolean consumePaper(Player player) {
        if (player.getAbilities().instabuild) {
            return true;
        }
        int amountNeeded = (Integer)CameraMod.SERVER_CONFIG.cameraConsumeItemAmount.get();
        List<ItemStack> consumeStacks = CameraItem.findPaper(player);
        int count = 0;
        for (ItemStack stack : consumeStacks) {
            count += stack.getCount();
        }
        if (count >= amountNeeded) {
            for (ItemStack stack : consumeStacks) {
                amountNeeded -= stack.getCount() - ItemUtils.itemStackAmount(-amountNeeded, stack, null).getCount();
            }
            return true;
        }
        return false;
    }

    private static List<ItemStack> findPaper(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (CameraItem.isPaper(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            items.add(player.getItemInHand(InteractionHand.MAIN_HAND));
        }
        if (CameraItem.isPaper(player.getItemInHand(InteractionHand.OFF_HAND))) {
            items.add(player.getItemInHand(InteractionHand.OFF_HAND));
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack = player.getInventory().getItem(i);
            if (!CameraItem.isPaper(itemstack)) continue;
            items.add(itemstack);
        }
        return items;
    }

    protected static boolean isPaper(ItemStack stack) {
        return stack.is(CameraMod.IMAGE_PAPER);
    }

    public boolean isActive(ItemStack stack) {
        return stack.has(CameraMod.ACTIVE_DATA_COMPONENT);
    }

    public void setActive(ItemStack stack, boolean active) {
        if (active) {
            stack.set(CameraMod.ACTIVE_DATA_COMPONENT, (Object)Unit.INSTANCE);
        } else {
            stack.remove(CameraMod.ACTIVE_DATA_COMPONENT);
        }
    }
}

