/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.CameraMod;
import de.maxhenkel.camera.corelib.net.Message;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.net.MessageUploadCustomImage;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageRequestUploadCustomImage
implements Message<MessageRequestUploadCustomImage> {
    public static final CustomPacketPayload.Type<MessageRequestUploadCustomImage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"request_upload"));
    private UUID uuid;

    public MessageRequestUploadCustomImage() {
    }

    public MessageRequestUploadCustomImage(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        if (CameraMod.PACKET_MANAGER.canTakeImage(sender.getUUID())) {
            if (CameraItem.consumePaper((Player)sender)) {
                context.reply((CustomPacketPayload)new MessageUploadCustomImage(this.uuid));
            } else {
                sender.displayClientMessage((Component)Component.translatable((String)"message.no_consumable"), true);
            }
        } else {
            sender.displayClientMessage((Component)Component.translatable((String)"message.image_cooldown"), true);
        }
    }

    @Override
    public MessageRequestUploadCustomImage fromBytes(RegistryFriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
    }

    @Override
    public CustomPacketPayload.Type<MessageRequestUploadCustomImage> type() {
        return TYPE;
    }
}

