/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import com.google.common.collect.ImmutableList;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7172;

public class PGCycleButton<T>
extends class_4264 {
    private static final List<Boolean> BOOLEAN_OPTIONS;
    public static class_2960 ARROW_TEXTURES;
    private int index;
    private T value;
    private final ValueListSupplier<T> values;
    private final Function<T, class_2561> valueStringifier;
    private final Function<PGCycleButton<T>, class_5250> narrationProvider;
    private final OnValueChange<T> onValueChange;
    private final class_7172.class_7277<T> tooltipSupplier;
    private boolean renderBG = true;
    private boolean renderArrows = false;
    private int color = this.field_22763 ? 0xFFFFFF : 0xA0A0A0 | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24;

    PGCycleButton(int x, int y, int width, int height, class_2561 message, int index, T value, ValueListSupplier<T> values, Function<T, class_2561> valueStringifier, Function<PGCycleButton<T>, class_5250> narrationProvider, OnValueChange<T> onValueChange, class_7172.class_7277<T> tooltipSupplier) {
        super(x, y, width, height, message);
        this.index = index;
        this.value = value;
        this.values = values;
        this.valueStringifier = valueStringifier;
        this.narrationProvider = narrationProvider;
        this.onValueChange = onValueChange;
        this.tooltipSupplier = tooltipSupplier;
        this.updateTooltip();
    }

    public void setRenderBackground(boolean renderBG) {
        this.renderBG = renderBG;
    }

    public void setRenderArrows(boolean renderArrows) {
        this.renderArrows = renderArrows;
    }

    public void setTextColor(int color) {
        this.color = color;
    }

    public int getTextColor() {
        return this.color;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.renderBG) {
            super.method_48579(graphics, mouseX, mouseY, delta);
        }
        if (this.renderArrows) {
            float r = (float)class_5253.class_5254.method_27765((int)this.color) / 255.0f;
            float g = (float)class_5253.class_5254.method_27766((int)this.color) / 255.0f;
            float b = (float)class_5253.class_5254.method_27767((int)this.color) / 255.0f;
            float a = (float)class_5253.class_5254.method_27762((int)this.color) / 255.0f;
            graphics.method_51422(r, g, b, a);
            graphics.method_25293(ARROW_TEXTURES, this.method_46426() + 1, this.method_46427() + this.field_22759 - 18, 16, 16, 0.0f, 0.0f, 16, 16, 32, 16);
            graphics.method_25293(ARROW_TEXTURES, this.method_46426() + this.field_22758 - 17, this.method_46427() + this.field_22759 - 18, 16, 16, 16.0f, 0.0f, 16, 16, 32, 16);
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
        class_2561 component = this.method_49606() ? class_2564.method_10889((class_5250)this.method_25369().method_27661(), (class_2583)class_2583.field_24360.method_30938(Boolean.valueOf(true))) : this.method_25369();
        PGCycleButton.method_49605((class_332)graphics, (class_327)class_310.method_1551().field_1772, (class_2561)component, (int)this.method_46426(), (int)this.method_46427(), (int)(this.method_46426() + this.method_25368()), (int)(this.method_46427() + this.method_25364()), (int)this.color);
    }

    private void updateTooltip() {
        this.method_47400(this.tooltipSupplier.apply(this.value));
    }

    public void method_25306() {
        if (class_437.method_25442()) {
            this.cycleValue(-1);
        } else {
            this.cycleValue(1);
        }
    }

    private void cycleValue(int delta) {
        List<T> list = this.values.getSelectedList();
        this.index = class_3532.method_15387((int)(this.index + delta), (int)list.size());
        T t = list.get(this.index);
        this.updateValue(t);
        this.onValueChange.onValueChange(this, t);
    }

    private T getCycledValue(int delta) {
        List<T> list = this.values.getSelectedList();
        return list.get(class_3532.method_15387((int)(this.index + delta), (int)list.size()));
    }

    public boolean mouseScrolled(double p_168885_, double p_168886_, double p_168887_, double p_294881_) {
        if (p_294881_ > 0.0) {
            this.cycleValue(-1);
        } else if (p_294881_ < 0.0) {
            this.cycleValue(1);
        }
        return true;
    }

    private void updateValue(T value) {
        class_2561 component = this.createLabelForValue(value);
        this.method_25355(component);
        this.value = value;
        this.updateTooltip();
    }

    private class_2561 createLabelForValue(T value) {
        return this.valueStringifier.apply(value);
    }

    public T getValue() {
        return this.value;
    }

    protected class_5250 method_25360() {
        return this.narrationProvider.apply(this);
    }

    public void method_47399(class_6382 p_168889_) {
        p_168889_.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.field_22763) {
            T t = this.getCycledValue(1);
            class_2561 component = this.createLabelForValue(t);
            if (this.method_25370()) {
                p_168889_.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43469((String)"narration.cycle_button.usage.focused", (Object[])new Object[]{component}));
            } else {
                p_168889_.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43469((String)"narration.cycle_button.usage.hovered", (Object[])new Object[]{component}));
            }
        }
    }

    public class_5250 createDefaultNarrationMessage() {
        return PGCycleButton.method_32602((class_2561)this.method_25369());
    }

    public static <T> Builder<T> builder(Function<T, class_2561> valueStringifier) {
        return new Builder<T>(valueStringifier);
    }

    public static Builder<Boolean> booleanBuilder(class_2561 componentOn, class_2561 componentOff) {
        return new Builder<Boolean>(b -> b != false ? componentOn : componentOff).withValues((Collection<Boolean>)BOOLEAN_OPTIONS);
    }

    static {
        ARROW_TEXTURES = PGHelper.id("textures/gui/sprites/icon/arrow.png");
        BOOLEAN_OPTIONS = ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
    }

    public static interface ValueListSupplier<T> {
        public List<T> getSelectedList();

        public List<T> getDefaultList();

        public static <T> ValueListSupplier<T> create(Collection<T> values) {
            ImmutableList list = ImmutableList.copyOf(values);
            return new ValueListSupplier<T>((List)list){
                final /* synthetic */ List val$list;
                {
                    this.val$list = list;
                }

                @Override
                public List<T> getSelectedList() {
                    return this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }

        public static <T> ValueListSupplier<T> create(final BooleanSupplier altListSelector, List<T> defaultList, List<T> selectedList) {
            ImmutableList list = ImmutableList.copyOf(defaultList);
            ImmutableList list1 = ImmutableList.copyOf(selectedList);
            return new ValueListSupplier<T>(){
                final /* synthetic */ List val$list1;
                final /* synthetic */ List val$list;
                {
                    this.val$list1 = list;
                    this.val$list = list2;
                }

                @Override
                public List<T> getSelectedList() {
                    return altListSelector.getAsBoolean() ? this.val$list1 : this.val$list;
                }

                @Override
                public List<T> getDefaultList() {
                    return this.val$list;
                }
            };
        }
    }

    public static interface OnValueChange<T> {
        public void onValueChange(PGCycleButton<T> var1, T var2);
    }

    public static class Builder<T> {
        private int initialIndex;
        private T initialValue;
        private final Function<T, class_2561> valueStringifier;
        private class_7172.class_7277<T> tooltipSupplier = p_168964_ -> null;
        private Function<PGCycleButton<T>, class_5250> narrationProvider = PGCycleButton::createDefaultNarrationMessage;
        private ValueListSupplier<T> values = ValueListSupplier.create(ImmutableList.of());

        public Builder(Function<T, class_2561> valueStringifier) {
            this.valueStringifier = valueStringifier;
        }

        public Builder<T> withValues(Collection<T> values) {
            return this.withValues(ValueListSupplier.create(values));
        }

        @SafeVarargs
        public final Builder<T> withValues(T ... values) {
            return this.withValues((Collection<T>)ImmutableList.copyOf((Object[])values));
        }

        public Builder<T> withValues(ValueListSupplier<T> values) {
            this.values = values;
            return this;
        }

        public Builder<T> withInitialValue(T initialValue) {
            this.initialValue = initialValue;
            int i = this.values.getDefaultList().indexOf(initialValue);
            if (i != -1) {
                this.initialIndex = i;
            }
            return this;
        }

        public PGCycleButton<T> create(class_2561 message, OnValueChange<T> onValueChange) {
            return this.create(0, 0, 150, 20, message, onValueChange);
        }

        public PGCycleButton<T> create(int x, int y, int width, int height, class_2561 name) {
            return this.create(x, y, width, height, name, (p_168946_, p_168947_) -> {});
        }

        public PGCycleButton<T> create(int x, int y, int width, int height, class_2561 name, OnValueChange<T> onValueChange) {
            List<T> list = this.values.getDefaultList();
            if (list.isEmpty()) {
                throw new IllegalStateException("No values for cycle button");
            }
            T t = this.initialValue != null ? this.initialValue : list.get(this.initialIndex);
            class_2561 component = this.valueStringifier.apply(t);
            return new PGCycleButton<T>(x, y, width, height, component, this.initialIndex, t, this.values, this.valueStringifier, this.narrationProvider, onValueChange, this.tooltipSupplier);
        }
    }
}

