/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.item;

import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.item.IWaypointStorage;
import com.jdolphin.ricksportalgun.common.item.upgrade.AbstractUpgradeItem;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_326;
import net.minecraft.class_3468;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5321;

public class PortalGunItem
extends class_1792
implements IWaypointStorage,
class_326 {
    private final int tints;

    public PortalGunItem(class_1792.class_1793 properties, int tints) {
        super(properties);
        this.tints = tints;
    }

    public int getTints() {
        return this.tints;
    }

    public static int getMaxFuel(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return tag.method_10545("MaxFuel") ? tag.method_10550("MaxFuel") : 64;
    }

    public static int getFuel(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return tag.method_10545("Fuel") ? tag.method_10550("Fuel") : PortalGunItem.getMaxFuel(stack);
    }

    public static void lowerFuel(class_1799 stack, int amount) {
        int i = PortalGunItem.getFuel(stack);
        class_2487 tag = stack.method_7948();
        tag.method_10569("Fuel", Math.max(0, i - amount));
    }

    public static void setPrimaryDye(class_1799 stack, int color) {
        class_2487 tag = stack.method_7948();
        tag.method_10569("PrimaryColor", color);
    }

    public static void setSecondaryDye(class_1799 stack, int color) {
        class_2487 tag = stack.method_7948();
        tag.method_10569("SecondaryColor", color);
    }

    public static int getPrimaryDye(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return tag.method_10545("PrimaryColor") ? tag.method_10550("PrimaryColor") : 0xF3FBFB;
    }

    public static int getSecondaryDye(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return tag.method_10545("SecondaryColor") ? tag.method_10550("SecondaryColor") : 0xF3FBFB;
    }

    public static void setCode(class_1799 stack, String code) {
        class_2487 tag = stack.method_7948();
        tag.method_10582("Code", code);
    }

    public static String getCode(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return tag.method_10545("Code") ? tag.method_10558("Code") : "";
    }

    public static void refillFuel(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        tag.method_10569("Fuel", PortalGunItem.getMaxFuel(stack));
    }

    public static void migrateDamage(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        int fuel = PortalGunItem.getMaxFuel(stack) - stack.method_7919();
        tag.method_10569("Fuel", fuel);
        tag.method_10551("Damage");
    }

    public static boolean refuel(class_1799 stack, class_1657 player) {
        class_2487 tag = stack.method_7948();
        class_1268 pgHand = PGHelper.getPortalGunHand(player);
        class_1268 fluidHand = PGHelper.getOppositeHand(pgHand);
        class_1799 gunStack = player.method_5998(pgHand);
        class_1799 fluidStack = player.method_5998(fluidHand);
        if (PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack) && gunStack.method_31573(PGTags.Items.PORTAL_GUNS)) {
            if (fluidStack.method_31574(PGItems.PORTAL_FLUID)) {
                PortalGunItem.refillFuel(stack);
                fluidStack.method_7934(1);
                tag.method_10556("Bootleg", false);
                return true;
            }
            if (fluidStack.method_31574(PGItems.BOOTLEG_PORTAL_FLUID)) {
                PortalGunItem.refillFuel(stack);
                tag.method_10556("Bootleg", false);
                fluidStack.method_7934(1);
                return true;
            }
        }
        return false;
    }

    private class_243 getLocation(class_1937 level, class_2338 bPos, class_2350 dir, class_243 loc) {
        if (this.isAir(level, bPos.method_10074()) && dir == class_2350.field_11033) {
            return loc.method_1031(0.0, -0.2, 0.0);
        }
        if (dir.equals((Object)class_2350.field_11036)) {
            return loc;
        }
        if (!this.isAir(level, bPos.method_10093(dir))) {
            switch (dir) {
                case field_11043: {
                    class_243 vec = bPos.method_10095().method_46558();
                    loc = vec.method_1031(0.0, 0.0, 0.4);
                    break;
                }
                case field_11035: {
                    class_243 vec = bPos.method_10072().method_46558();
                    loc = vec.method_1031(0.0, 0.0, -0.4);
                    break;
                }
                case field_11039: {
                    class_243 vec = bPos.method_10067().method_46558();
                    loc = vec.method_1031(0.4, 0.0, 0.0);
                    break;
                }
                case field_11034: {
                    class_243 vec = bPos.method_10078().method_46558();
                    loc = vec.method_1031(-0.4, 0.0, 0.0);
                }
            }
        } else {
            float x;
            float f = dir.method_10166().equals((Object)class_2350.class_2351.field_11048) ? (dir.method_10171().equals((Object)class_2350.class_2352.field_11056) ? 0.1f : -0.1f) : (x = 0.0f);
            float z = dir.method_10166().equals((Object)class_2350.class_2351.field_11051) ? (dir.method_10171().equals((Object)class_2350.class_2352.field_11056) ? 0.1f : -0.1f) : 0.0f;
            loc = new class_243(loc.method_10216() + (double)x, (double)bPos.method_10264(), loc.method_10215() + (double)z);
        }
        return loc;
    }

    /*
     * Enabled aggressive block sorting
     */
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        int age;
        class_1799 stack = player.method_5998(hand);
        if (level.method_8608()) return class_1271.method_22430((Object)stack);
        if (!(player instanceof class_3222)) return class_1271.method_22430((Object)stack);
        PortalGunItem.migrateDamage(stack);
        if (!PGHelper.canPlayerAccessGun(player, stack)) {
            PGHelper.sendFailMsg(player, "error.ricksportalgun.security");
            return class_1271.method_22431((Object)stack);
        }
        class_1799 oppositeStack = player.method_5998(PGHelper.getOppositeHand(hand));
        class_3965 hitResult = PortalGunItem.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1347);
        class_2487 tag = stack.method_7948();
        if (PortalGunItem.refuel(stack, player)) return class_1271.method_22430((Object)stack);
        if (PortalGunItem.getFuel(stack) <= 0) return class_1271.method_22430((Object)stack);
        class_1792 class_17922 = oppositeStack.method_7909();
        if (class_17922 instanceof AbstractUpgradeItem) {
            AbstractUpgradeItem upgrade = (AbstractUpgradeItem)class_17922;
            class_1269 result = upgrade.applyUpgrade(player, stack, this);
            if (player.method_7337()) return class_1271.method_22427((Object)stack);
            oppositeStack.method_7934(1);
            return class_1271.method_22427((Object)stack);
        }
        class_2960 dim = tag.method_10545("PortalDimension") ? new class_2960(tag.method_10558("PortalDimension")) : class_1937.field_25179.method_29177();
        class_5321<class_1937> key = LevelHelper.getWorldKey(dim);
        class_3218 serverlevel = LevelHelper.getServerWorld(level, key);
        class_2338 destination = PortalGunItem.getHopCoords(stack);
        class_243 loc = hitResult.method_17784();
        if (hitResult.method_17783().equals((Object)class_239.class_240.field_1332)) {
            class_2350 dir = hitResult.method_17780();
            class_2338 bPos = hitResult.method_17777();
            loc = this.getLocation(level, bPos, dir, loc);
        }
        class_2350 hitDir = hitResult.method_17780();
        class_2350 playerDir = player.method_5735();
        float size = tag.method_10545("PortalSize") ? tag.method_10583("PortalSize") : 1.0f;
        int n = age = tag.method_10545("PortalAge") ? tag.method_10550("PortalAge") : 10;
        if (serverlevel != null) {
            if (LevelHelper.canPortalTo(serverlevel, destination, stack) && LevelHelper.canPortalTo((class_3218)level, hitResult.method_17777(), stack)) {
                if (PortalGunItem.canBypassDragon(stack) || !LevelHelper.endHasDragons((class_3218)level) && !LevelHelper.endHasDragons(serverlevel)) {
                    PortalEntity portal = new PortalEntity(level, loc, hitDir, playerDir, size);
                    serverlevel.method_14178().method_12124(new class_1923(destination), true);
                    PortalEntity exPortal = new PortalEntity((class_1937)serverlevel, destination.method_10084().method_46558(), hitDir, playerDir, size);
                    boolean bootleg = tag.method_10545("Bootleg") && tag.method_10577("Bootleg");
                    this.doForBoth(entity -> {
                        entity.setLifetime(PGHelper.seconds(age));
                        entity.setColor(PortalGunItem.getColor(stack));
                        entity.setBootleg(bootleg);
                    }, portal, exPortal);
                    if (stack.method_7938()) {
                        class_2561 component = stack.method_7964();
                        String s = component.getString();
                        this.doForBoth(entity -> entity.method_5665((class_2561)class_2561.method_43470((String)s)), portal, exPortal);
                    }
                    portal.setHopLocation(dim, destination);
                    exPortal.setHopLocation(level.method_27983().method_29177(), portal.method_24515());
                    if (!portal.isFlat()) {
                        this.doForBoth(entity -> entity.method_36456(player.method_36454()), portal, exPortal);
                    }
                    serverlevel.method_8503().method_40000(() -> serverlevel.method_8649((class_1297)exPortal));
                    level.method_8649((class_1297)portal);
                    player.method_7259(class_3468.field_15372.method_14956((Object)this));
                    player.method_7357().method_7906((class_1792)this, 60);
                    if (player.method_7337()) return class_1271.method_22430((Object)stack);
                    PortalGunItem.lowerFuel(stack, 1);
                    return class_1271.method_22430((Object)stack);
                }
                PGHelper.sendFailMsg(player, "error.ricksportalgun.destination.dragon");
                return class_1271.method_22431((Object)stack);
            }
            PGHelper.sendFailMsg(player, "error.ricksportalgun.destination.unreachable");
            return class_1271.method_22431((Object)stack);
        }
        if (!LevelHelper.isBlenderDestination(dim.toString())) return class_1271.method_22430((Object)stack);
        PortalEntity portal = new PortalEntity(level, loc, hitDir, playerDir, size);
        portal.setLifetime(age);
        if (stack.method_7938()) {
            class_2561 component = stack.method_7964();
            String s = component.getString();
            portal.method_5665((class_2561)class_2561.method_43470((String)s));
        }
        portal.setHopLocation(dim, destination);
        portal.setColor(PortalGunItem.getColor(stack));
        boolean bootleg = tag.method_10545("Bootleg") && tag.method_10577("Bootleg");
        portal.setBootleg(bootleg);
        if (!portal.isFlat()) {
            portal.method_36456(player.method_36454());
        }
        if (!player.method_7337()) {
            PortalGunItem.lowerFuel(stack, 1);
        }
        level.method_8649((class_1297)portal);
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        player.method_7357().method_7906((class_1792)this, 60);
        return class_1271.method_22427((Object)stack);
    }

    private void doForBoth(Consumer<PortalEntity> consumer, PortalEntity a, PortalEntity b) {
        consumer.accept(a);
        consumer.accept(b);
    }

    public static boolean canBypassDragon(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return tag.method_10545("ExtraDimMk2") && tag.method_10577("ExtraDimMk2");
    }

    private boolean isAir(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26215();
    }

    public void method_7851(class_1799 stack, class_1937 pLevel, List<class_2561> tooltips, class_1836 pIsAdvanced) {
        class_2487 tag = stack.method_7948();
        List<String> list = IWaypointStorage.getWaypoints(stack);
        if (!class_437.method_25442()) {
            tooltips.add((class_2561)class_2561.method_43469((String)"ricksportalgun.destination", (Object[])new Object[]{PortalGunItem.getHopCoords(stack).method_10263(), PortalGunItem.getHopCoords(stack).method_10264(), PortalGunItem.getHopCoords(stack).method_10260()}).method_27692(class_124.field_1080));
            tooltips.add((class_2561)class_2561.method_43469((String)"ricksportalgun.dimension", (Object[])new Object[]{PortalGunItem.getHopDimension(stack).toString()}).method_27692(class_124.field_1080));
            tooltips.add((class_2561)class_2561.method_43469((String)"tooltip.ricksportalgun.fuel", (Object[])new Object[]{PortalGunItem.getFuel(stack), PortalGunItem.getMaxFuel(stack)}).method_27692(class_124.field_1080));
        } else {
            tooltips.add((class_2561)class_2561.method_43469((String)"tooltip.ricksportalgun.waypoints", (Object[])new Object[]{list.size()}).method_27692(class_124.field_1080));
            if (tag.method_10545("PrimaryColor") || tag.method_10545("SecondaryColor")) {
                tooltips.add((class_2561)class_2561.method_43469((String)"item.dyed", (Object[])new Object[]{list.size()}).method_27695(new class_124[]{class_124.field_1064, class_124.field_1056}));
            }
        }
    }

    public int method_31571(class_1799 stack) {
        return PortalGunItem.getColor(stack);
    }

    public boolean method_31567(class_1799 stack) {
        return PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack);
    }

    public int method_31569(class_1799 stack) {
        return Math.round((float)PortalGunItem.getFuel(stack) * 13.0f / (float)PortalGunItem.getMaxFuel(stack));
    }

    public static int getColor(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return tag.method_10545("Color") ? tag.method_10550("Color") : PortalGunItem.getDefaultColor(stack);
    }

    public static void setDefaultColor(class_1799 stack, int color) {
        class_2487 tag = stack.method_7948();
        tag.method_10569("DefaultColor", color);
    }

    public static int getDefaultColor(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return tag.method_10545("DefaultColor") ? tag.method_10550("DefaultColor") : Color.GREEN.getRGB();
    }

    public static void setStyle(class_1799 stack, PortalGunStyle style) {
        class_2487 tag = stack.method_7948();
        tag.method_10566("PortalGunStyle", (class_2520)style.toNBT());
    }

    public static void setColor(class_1799 stack, int color) {
        class_2487 tag = stack.method_7948();
        tag.method_10569("Color", color);
    }

    public static void setHopLocation(class_1799 stack, class_2960 dimension, class_2338 pos) {
        class_2487 tag = stack.method_7948();
        tag.method_10582("PortalDimension", dimension.toString());
        tag.method_10566("PortalPos", (class_2520)class_2512.method_10692((class_2338)pos));
    }

    public static class_2960 getHopDimension(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return tag.method_10545("PortalDimension") ? new class_2960(tag.method_10558("PortalDimension")) : class_1937.field_25179.method_29177();
    }

    public static class_2338 getHopCoords(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10545("PortalPos")) {
            class_2487 bpTag = tag.method_10562("PortalPos");
            return class_2512.method_10691((class_2487)bpTag);
        }
        return class_2338.field_10980;
    }

    public int getColor(class_1799 itemStack, int i) {
        return PortalGunItem.getColor(itemStack);
    }
}

