/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.entity;

import com.jdolphin.ricksportalgun.common.init.PGDamageTypes;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.init.PGSounds;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGConfigHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2709;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5321;

public class PortalEntity
extends class_1297 {
    private static final class_2940<Integer> DATA_COLOR_ID = class_2945.method_12791(PortalEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2350> DATA_DIR = class_2945.method_12791(PortalEntity.class, (class_2941)class_2943.field_13321);
    private static final class_2940<class_2350> DATA_FACING = class_2945.method_12791(PortalEntity.class, (class_2941)class_2943.field_13321);
    private static final class_2940<Float> DATA_SIZE = class_2945.method_12791(PortalEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> LIFETIME = class_2945.method_12791(PortalEntity.class, (class_2941)class_2943.field_13327);
    public static final String TAG_DIMENSION = "PortalDimension";
    public static final String TAG_BPOS = "PortalPos";
    public static final String TAG_OPEN = "Open";
    public static final String TAG_NEW = "isSpawned";
    public static final String TAG_COOLDOWN = "Cooldown";
    public static final String TAG_DIR = "Direction";
    public static final String TAG_FACING = "Facing";
    public static final String TAG_SIZE = "Size";
    public static final String TAG_ACIDIC = "Bootleg";
    public static final String TAG_COLOR = "Color";
    private class_2338 targetPos;
    private boolean bootleg;
    private boolean exists;
    private class_243 pos;
    private class_243 targetVec;
    private String targetDim;
    private class_3218 destinationLevel;
    private int delay = 0;

    public boolean exists() {
        return this.exists;
    }

    public boolean method_5727(double x, double y, double z) {
        return true;
    }

    public PortalEntity(class_1299<PortalEntity> type, class_1937 level) {
        super(type, level);
    }

    public PortalEntity(class_1937 pLevel, class_243 pos, class_2350 direction, class_2350 facing, float size) {
        super(PGEntities.PORTAL, pLevel);
        this.method_33574(pos);
        this.setPortalDirection(direction);
        this.setPortalFacing(facing);
        this.setSize(size);
        this.pos = pos;
    }

    public void setLifetime(int lifetime) {
        this.field_6011.method_12778(LIFETIME, (Object)lifetime);
    }

    public int getLifetime() {
        return (Integer)this.field_6011.method_12789(LIFETIME);
    }

    public void setColor(int color) {
        this.field_6011.method_12778(DATA_COLOR_ID, (Object)color);
    }

    public void setPortalDirection(class_2350 direction) {
        this.field_6011.method_12778(DATA_DIR, (Object)direction);
    }

    public void setPortalFacing(class_2350 direction) {
        this.field_6011.method_12778(DATA_FACING, (Object)direction);
    }

    public class_2350 getPortalFacing() {
        return (class_2350)this.field_6011.method_12789(DATA_FACING);
    }

    public class_2350 getPortalDirection() {
        return (class_2350)this.field_6011.method_12789(DATA_DIR);
    }

    public int getColor() {
        return (Integer)this.field_6011.method_12789(DATA_COLOR_ID);
    }

    public float getSize() {
        return ((Float)this.field_6011.method_12789(DATA_SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.field_6011.method_12778(DATA_SIZE, (Object)Float.valueOf(size));
    }

    public boolean isBootleg() {
        return this.bootleg;
    }

    public void setBootleg(boolean bootleg) {
        this.bootleg = bootleg;
    }

    public static boolean colliding(class_1297 entity1, class_1297 entity2) {
        return entity1.method_5829().method_994(entity2.method_5829());
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26999);
    }

    public boolean method_5740() {
        return true;
    }

    public boolean method_5753() {
        return true;
    }

    public boolean method_5643(class_1282 damageSource, float v) {
        return false;
    }

    public boolean isFlat() {
        class_2350 direction = (class_2350)this.field_6011.method_12789(DATA_DIR);
        return direction.equals((Object)class_2350.field_11036) || direction.equals((Object)class_2350.field_11033);
    }

    public void setHopLocation(class_2960 dimension, class_2338 pos) {
        this.targetDim = dimension.toString();
        this.targetPos = pos;
    }

    public class_2338 getHopLoc() {
        return this.targetPos == null ? class_2338.field_10980 : this.targetPos;
    }

    public String getHopDim() {
        return this.targetDim == null ? "minecraft:overworld" : this.targetDim;
    }

    protected void method_5749(class_2487 tag) {
        this.bootleg = tag.method_10577(TAG_ACIDIC);
        this.targetDim = tag.method_10558(TAG_DIMENSION);
        class_2487 bpTag = tag.method_10562(TAG_BPOS);
        this.targetPos = class_2512.method_10691((class_2487)bpTag);
        this.setColor(tag.method_10550(TAG_COLOR));
        this.setLifetime(tag.method_10550(TAG_OPEN));
        this.delay = tag.method_10550(TAG_COOLDOWN);
        this.exists = tag.method_10577(TAG_NEW);
        this.setPortalDirection(class_2350.method_10168((String)tag.method_10558(TAG_DIR)));
        this.setPortalFacing(class_2350.method_10168((String)tag.method_10558(TAG_FACING)));
        this.setSize(tag.method_10583(TAG_SIZE));
    }

    protected void method_5652(class_2487 tag) {
        tag.method_10556(TAG_ACIDIC, this.bootleg);
        tag.method_10556(TAG_NEW, this.exists);
        tag.method_10582(TAG_DIMENSION, this.getHopDim());
        tag.method_10566(TAG_BPOS, (class_2520)class_2512.method_10692((class_2338)this.getHopLoc()));
        tag.method_10569(TAG_COLOR, this.getColor());
        tag.method_10569(TAG_OPEN, this.getLifetime());
        tag.method_10569(TAG_COOLDOWN, this.delay);
        tag.method_10582(TAG_DIR, this.getPortalDirection().method_10151());
        tag.method_10582(TAG_FACING, this.getPortalFacing().method_10151());
        tag.method_10548(TAG_SIZE, this.getSize());
    }

    public void method_5814(double x, double y, double z) {
        this.pos = new class_243(x, y, z);
        this.method_23327(x, y, z);
        this.recalculateBoundingBox();
    }

    protected final void recalculateBoundingBox() {
        class_2350 direction = (class_2350)this.field_6011.method_12789(DATA_DIR);
        class_2350 facing = (class_2350)this.field_6011.method_12789(DATA_FACING);
        class_238 aabb = this.calculateBoundingBox(this.pos, direction, facing);
        class_243 vec3 = aabb.method_1005();
        this.method_23327(vec3.field_1352, vec3.field_1351, vec3.field_1350);
        this.method_5857(aabb);
    }

    protected class_238 calculateBoundingBox(class_243 vec3, class_2350 dir, class_2350 facing) {
        double d2;
        class_2350.class_2351 axis = dir.method_10166();
        boolean flat = axis.equals((Object)class_2350.class_2351.field_11052);
        double height = this.getSize() > 2.0f ? (double)this.getSize() : 2.0;
        double d0 = axis.equals((Object)class_2350.class_2351.field_11048) ? 0.1 : (double)this.getSize();
        double d1 = flat ? 0.1 : height;
        double d = d2 = axis.equals((Object)class_2350.class_2351.field_11051) ? 0.1 : (double)this.getSize();
        if (flat) {
            class_2350.class_2351 axis2d = facing.method_10166();
            d0 = axis2d.equals((Object)class_2350.class_2351.field_11048) ? height : (double)this.getSize();
            d2 = axis2d.equals((Object)class_2350.class_2351.field_11051) ? height : (double)this.getSize();
        }
        return class_238.method_30048((class_243)vec3, (double)d0, (double)d1, (double)d2);
    }

    public static List<class_1297> getEntitiesNearby(class_1297 entity, double range) {
        if (!entity.method_37908().method_8608()) {
            class_238 boundingBox = entity.method_5829().method_1014(range);
            List entities = entity.method_37908().method_18467(class_1297.class, boundingBox);
            entities.remove(entity);
            entities.removeIf(e -> {
                String entityAsString = PGHelper.getEntityAsString(e.method_5864());
                return PGConfigHelper.getDisabledEntities().contains(entityAsString);
            });
            entities.removeIf(e -> {
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    return player.method_30230() || player.method_14208();
                }
                return false;
            });
            return entities;
        }
        return null;
    }

    protected void method_5693() {
        this.field_6011.method_12784(DATA_COLOR_ID, (Object)Color.GREEN.getRGB());
        this.field_6011.method_12784(DATA_DIR, (Object)class_2350.field_11035);
        this.field_6011.method_12784(DATA_FACING, (Object)class_2350.field_11035);
        this.field_6011.method_12784(DATA_SIZE, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(LIFETIME, (Object)PGHelper.seconds(10));
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            List<class_1297> entityList;
            boolean shouldHurt;
            class_3218 serverLevel = (class_3218)this.method_37908();
            if (!this.exists) {
                LevelHelper.playSound(this.method_37908(), this.method_24515(), PGSounds.PORTAL_SHOOT, class_3419.field_15248);
                this.exists = true;
            }
            if (this.getLifetime() > 0) {
                int l = this.getLifetime();
                this.setLifetime(l - 1);
            }
            if (this.delay > 0) {
                --this.delay;
            }
            if (!this.field_5953 && this.getLifetime() == 0) {
                this.method_37908().method_8398().method_12124(new class_1923(this.method_24515()), false);
                this.method_5768();
                return;
            }
            if (this.destinationLevel == null) {
                if (!this.isBootleg() && !LevelHelper.isBlenderDestination(this.getHopDim())) {
                    class_5321<class_1937> key = LevelHelper.getWorldKey(new class_2960(this.getHopDim()));
                    this.destinationLevel = LevelHelper.getServerWorld(this.method_37908(), key);
                } else {
                    this.destinationLevel = (class_3218)this.method_37908();
                }
                if (this.targetPos == null) {
                    this.targetPos = this.getHopLoc();
                }
            }
            if (this.targetVec == null) {
                this.targetVec = class_243.method_1034((class_241)new class_241(45.0f, this.method_36454() + 180.0f));
            }
            boolean bl = shouldHurt = this.isBootleg() || LevelHelper.isBlenderDestination(this.getHopDim());
            if ((shouldHurt || this.destinationLevel != null && this.targetPos != null) && (entityList = PortalEntity.getEntitiesNearby(this, 0.3)) != null && !entityList.isEmpty()) {
                for (class_1297 nearby : entityList) {
                    if (!PortalEntity.colliding(this, nearby) || nearby.method_30230() || nearby.method_5765() || this.delay != 0) continue;
                    if (!shouldHurt) {
                        HashSet<class_2709> relativeSet = new HashSet<class_2709>();
                        relativeSet.add(class_2709.field_12401);
                        nearby.method_48105(this.destinationLevel, (double)this.targetPos.method_10263() + this.targetVec.field_1352 * 2.0, (double)this.targetPos.method_10264(), (double)this.targetPos.method_10260() + this.targetVec.field_1350 * 2.0, relativeSet, nearby.method_36454(), nearby.method_36455());
                        nearby.method_38785();
                        nearby.method_30229();
                        continue;
                    }
                    if (nearby instanceof class_3222) {
                        class_3222 player = (class_3222)nearby;
                        player.method_5643(LevelHelper.isBlenderDestination(this.getHopDim()) ? PGDamageTypes.blender() : PGDamageTypes.bootleg(), Float.MAX_VALUE);
                        continue;
                    }
                    nearby.method_5768();
                }
            }
        }
    }
}

