/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.apache.logging.log4j.LogManager;

public class Waypoint
implements Comparable<Waypoint> {
    public static final Codec<Waypoint> CODEC;
    public static final Waypoint ZERO;
    private int x;
    private int y;
    private int z;
    private String dim;
    private String name;
    private final String waypointString;

    public Waypoint(int x, int y, int z, String dimension, String name) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dimension;
        this.name = name;
        this.waypointString = this.x + "|" + this.y + "|" + this.z + "|" + this.dim + "|" + this.name;
    }

    public Waypoint(class_2338 pos, String dimension, String name) {
        this(pos.method_10263(), pos.method_10264(), pos.method_10260(), dimension, name);
    }

    public class_2338 getBlockPos() {
        return new class_2338(this.x, this.y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getWaypointString() {
        return this.waypointString;
    }

    public static Waypoint getWaypoint(String waypointString) {
        String[] dataParts = waypointString.split("\\|");
        if (dataParts.length == 5) {
            try {
                int x = Integer.parseInt(dataParts[0]);
                int y = Integer.parseInt(dataParts[1]);
                int z = Integer.parseInt(dataParts[2]);
                String dimension = dataParts[3];
                String name = dataParts[4];
                return new Waypoint(x, y, z, dimension, name);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else {
            LogManager.getLogger().warn("Invalid data format");
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getDimension() {
        return this.dim;
    }

    public void setX(int X) {
        this.x = X;
    }

    public void setY(int Y) {
        this.y = Y;
    }

    public void setZ(int Z) {
        this.z = Z;
    }

    public void setX(class_2338 pos) {
        this.z = pos.method_10263();
    }

    public void setY(class_2338 pos) {
        this.z = pos.method_10260();
    }

    public void setZ(class_2338 pos) {
        this.z = pos.method_10260();
    }

    public void setDimension(String dimension) {
        this.dim = dimension;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(Waypoint wp) {
        return this.getBlockPos().method_10265((class_2382)wp.getBlockPos()) + this.getDimension().compareTo(wp.getDimension()) + this.getName().compareTo(wp.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Waypoint)) {
            return false;
        }
        Waypoint waypoint = (Waypoint)o;
        if (this.getX() != waypoint.getX()) {
            return false;
        }
        if (this.getY() != waypoint.getY()) {
            return false;
        }
        if (this.getZ() != waypoint.getZ()) {
            return false;
        }
        if (!this.getDimension().equals(waypoint.getDimension())) {
            return false;
        }
        return this.getName().equals(waypoint.getName());
    }

    static {
        ZERO = new Waypoint(class_2338.field_10980, "minecraft:overworld", "");
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(Waypoint::getBlockPos), (App)Codec.STRING.fieldOf("dimension").forGetter(Waypoint::getDimension), (App)Codec.STRING.fieldOf("name").forGetter(Waypoint::getName)).apply((Applicative)instance, Waypoint::new));
    }
}

