/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun.settings;

import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.SettingsScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.WaypointScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGItemButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.client.screen.widget.ScrollableList;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGUpgradeTypes;
import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.item.UpgradeItem;
import com.jdolphin.ricksportalgun.common.item.types.PreConditionUpgrade;
import com.jdolphin.ricksportalgun.common.item.types.UpgradeType;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBAddUpgradePacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;

public class UpgradesInfoScreen
extends AbstractBaseScreen {
    private PGImageButton backButton;
    private PGImageButton addUpgrade;
    private UpgradeListWidget upgradeListWidget;
    private final List<PGItemButton> itemButtons = new ArrayList<PGItemButton>();
    private boolean showUpgradeButtons = false;

    public UpgradesInfoScreen() {
        super((class_2561)class_2561.method_43471((String)"menu.ricksportalgun.settings.upgrades"));
    }

    protected void method_25426() {
        super.method_25426();
        assert (this.field_22787 != null);
        PortalGunStyle style = this.getStyle();
        this.upgradeListWidget = (UpgradeListWidget)this.method_25429((class_364)new UpgradeListWidget(class_310.method_1551(), 170, 152, this.field_22789 / 2 - 75, this.field_22790 / 2 - 70, 24, style));
        this.addUpgrade = (PGImageButton)this.method_37063((class_364)new PGImageButton(this.field_22789 / 2 + 118, this.field_22790 / 2 - 94, 20, 20, (class_2561)class_2561.method_43471((String)"ricksportalgun.button.waypoint.new"), button -> {
            this.showUpgradeButtons = !this.showUpgradeButtons;
        }, 20, 20, WaypointScreen.NEW_WAYPOINT_TEXTURES));
        this.backButton = (PGImageButton)this.method_37063((class_364)new PGImageButton(this.field_22789 / 2 - 140, this.field_22790 / 2 - 96, 20, 20, (class_2561)class_2561.method_43471((String)"ricksportalgun.button.back"), button -> this.field_22787.method_1507((class_437)new SettingsScreen()), 20, 20, BACK_BUTTON_TEXTURE));
        this.initUpgrade(this.field_22789 / 2 + 98, this.field_22790 / 2 - 64);
        this.addUpgrade.setColor(style.highlightColor());
        this.addUpgrade.setRenderBackground(false);
        this.backButton.setColor(style.highlightColor());
        this.backButton.setRenderBackground(false);
        GuiHelper.setTooltip((class_339)this.backButton, (class_2561)class_2561.method_43471((String)"ricksportalgun.button.back"));
        GuiHelper.setTooltip((class_339)this.addUpgrade, (class_2561)class_2561.method_43471((String)"ricksportalgun.button.upgrade_new"));
    }

    private void initUpgrade(int x, int y) {
        this.itemButtons.clear();
        int i = 0;
        List<String> types = PortalGunItem.getUpgrades(this.getItemStack());
        for (UpgradeItem upgrade : PGItems.UPGRADES) {
            PreConditionUpgrade pre;
            int offsetX = x + i % 3 * 20;
            int offsetY = y + i / 3 * 20;
            class_746 player = this.field_22787.field_1724;
            boolean hasItem = player.method_31548().method_43256(stack -> stack.method_7909().equals((Object)upgrade));
            UpgradeType upgradeType = upgrade.getUpgradeType();
            boolean hasPrevious = upgradeType instanceof PreConditionUpgrade && types.contains((pre = (PreConditionUpgrade)upgradeType).getConditionTag()) || !(upgrade.getUpgradeType() instanceof PreConditionUpgrade);
            boolean hasUpgradePreviously = types.contains(upgrade.getUpgradeType().getId());
            boolean canApply = player.method_7337() || hasItem && !hasUpgradePreviously && hasPrevious;
            PGItemButton button = (PGItemButton)this.method_37063((class_364)new PGItemButton(offsetX, offsetY, 20, 20, upgrade.getUpgradeType().getName(), btn -> {
                if (canApply) {
                    SBAddUpgradePacket packet = new SBAddUpgradePacket(upgrade.getUpgradeType().getId());
                    PGHelper.sendPacketToServer(packet);
                }
            }, upgrade.method_7854()));
            button.field_22764 = this.showUpgradeButtons;
            button.field_22763 = canApply;
            button.setRenderBackground(false);
            this.itemButtons.add(button);
            class_5250 desc = upgrade.getUpgradeType().getName().method_27661();
            if (!player.method_7337()) {
                if (!hasItem && !hasUpgradePreviously) {
                    desc.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"notice.ricksportalgun.upgrade.not_in_inventory"));
                }
                if (!hasPrevious) {
                    desc.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"notice.ricksportalgun.upgrade.needs_other"));
                }
                if (hasUpgradePreviously) {
                    desc.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"notice.ricksportalgun.upgrade.already_applied"));
                }
            }
            GuiHelper.setTooltip((class_339)button, (class_2561)desc);
            ++i;
        }
    }

    public void method_25393() {
        super.method_25393();
        class_1799 stack = this.getItemStack();
        if (this.upgradeListWidget.method_25396().size() != PortalGunItem.getUpgrades(stack).size()) {
            this.method_41843();
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        PortalGunStyle style = this.getStyle();
        graphics.method_25294(this.field_22789 / 2 - 154, this.field_22790 / 2 - 110, this.field_22789 / 2 + 165, this.field_22790 / 2 + 100, style.bgColor());
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"menu.ricksportalgun.settings.upgrades"), this.field_22789 / 2, this.field_22790 / 2 - 92, style.textColor());
        if (this.upgradeListWidget != null) {
            this.upgradeListWidget.method_25394(graphics, mouseX, mouseY, partialTick);
            graphics.method_49601(this.upgradeListWidget.getLeft(), this.upgradeListWidget.getTop(), this.upgradeListWidget.getWidth(), this.upgradeListWidget.getHeight(), style.highlightColor());
        }
        for (PGItemButton button : this.itemButtons) {
            button.field_22764 = this.showUpgradeButtons;
            if (!button.field_22764) continue;
            GuiHelper.renderOutline(graphics, (class_339)button, style.highlightColor());
        }
        GuiHelper.renderOutline(graphics, (class_339)this.backButton, style.highlightColor());
        GuiHelper.renderOutline(graphics, (class_339)this.addUpgrade, style.highlightColor());
        RenderSystem.enableBlend();
        graphics.method_25290(BG_LOCATION, this.field_22789 / 2 - 158, this.field_22790 / 2 - 115, 0.0f, 0.0f, 330, 224, 330, 224);
        RenderSystem.disableBlend();
        class_2583 guiStyle = GuiHelper.getStyle(mouseX, mouseY);
        if (guiStyle != null && guiStyle.method_10969() != null) {
            this.method_47413(graphics, mouseX, mouseY, partialTick);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public static class UpgradeListWidget
    extends ScrollableList<UpgradeEntry> {
        private final PortalGunStyle style;

        public UpgradeListWidget(class_310 minecraft, int width, int height, int x0, int pY0, int pItemHeight, PortalGunStyle style) {
            super(minecraft, width, height, x0, pY0, pItemHeight);
            assert (minecraft.field_1724 != null);
            this.style = style;
            this.refreshEntries(minecraft.field_1724.method_5998(PGHelper.getPortalGunHand((class_1657)minecraft.field_1724)));
        }

        public void refreshEntries(class_1799 stack) {
            this.method_25396().clear();
            List<String> upgrades = PortalGunItem.getUpgrades(stack);
            for (String upgrade : upgrades) {
                if (upgrade != null) {
                    this.addEntry(new UpgradeEntry(PGUpgradeTypes.getFromTag(upgrade), this, this.style.highlightColor()));
                    continue;
                }
                LogManager.getLogger().warn("Failed to get upgrade");
            }
        }

        @Override
        public void method_25394(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
            if (this.method_25396().isEmpty()) {
                graphics.method_27534(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"notice.ricksportalgun.no_upgrades"), this.x0 + this.width / 2, this.y0 + this.height / 2, this.style.textColor());
            }
        }

        public void method_37020(class_6382 narrationElementOutput) {
        }

        public static class UpgradeEntry
        extends ScrollableList.Entry<UpgradeEntry> {
            UpgradeType type;
            protected UpgradeListWidget list;
            private final PGTextButton button;
            private final int color;

            public UpgradeEntry(UpgradeType type, UpgradeListWidget widget, int color) {
                this.type = type;
                this.list = widget;
                this.color = color;
                this.button = new PGTextButton(16, 0, 152, 20, type.getName(), button1 -> {}, class_310.method_1551().field_1772);
                GuiHelper.setTooltip((class_339)this.button, type.getDescription());
            }

            @Override
            public void render(class_332 graphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                if (pTop > this.list.headerHeight) {
                    this.button.method_46421(pLeft - 24);
                    this.button.method_46419(pTop);
                    this.button.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
                    GuiHelper.renderOutline(graphics, (class_339)this.button, this.color);
                }
            }

            public List<? extends class_364> method_25396() {
                return List.of();
            }
        }
    }
}

