/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8028;
import net.minecraft.class_8132;
import net.minecraft.class_9017;
import org.jetbrains.annotations.Nullable;

public abstract class PGScrollableWidget<E extends Entry<E>>
extends class_9017 {
    private static final class_2960 MENU_LIST_BACKGROUND = class_2960.method_60656((String)"textures/gui/menu_list_background.png");
    private static final class_2960 INWORLD_MENU_LIST_BACKGROUND = class_2960.method_60656((String)"textures/gui/inworld_menu_list_background.png");
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60656((String)"widget/scroller");
    private static final class_2960 SCROLLER_BACKGROUND_SPRITE = class_2960.method_60656((String)"widget/scroller_background");
    protected final class_310 minecraft;
    protected final int itemHeight;
    private final TrackedList children = new TrackedList();
    protected boolean centerListVertically = true;
    protected int headerHeight;
    @Nullable
    private E selected;
    @Nullable
    private E hovered;
    private double scrollAmount;
    private boolean renderScrollbar = true;
    private boolean scrolling;
    private boolean renderHeader;

    public PGScrollableWidget(class_310 minecraft, int width, int height, int x, int y, int itemHeight) {
        super(x, y, width, height, class_5244.field_39003);
        this.minecraft = minecraft;
        this.itemHeight = itemHeight;
    }

    public void setRenderScrollbar(boolean renderScrollbar) {
        this.renderScrollbar = renderScrollbar;
    }

    protected void setRenderHeader(boolean renderHeader, int headerHeight) {
        this.renderHeader = renderHeader;
        this.headerHeight = headerHeight;
        if (!renderHeader) {
            this.headerHeight = 0;
        }
    }

    public int getRowWidth() {
        return 220;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E selected) {
        this.selected = selected;
    }

    public E getFirstElement() {
        return (E)((Entry)this.children.getFirst());
    }

    @Nullable
    public E getFocused() {
        return (E)((Entry)super.method_25399());
    }

    public final List<E> method_25396() {
        return this.children;
    }

    protected void clearEntries() {
        this.children.clear();
        this.selected = null;
    }

    protected void replaceEntries(Collection<E> entries) {
        this.clearEntries();
        this.children.addAll(entries);
    }

    protected E getEntry(int index) {
        return (E)((Entry)this.method_25396().get(index));
    }

    protected int addEntry(E entry) {
        this.children.add(entry);
        return this.children.size() - 1;
    }

    protected void addEntryToTop(E entry) {
        double d0 = (double)this.getMaxScroll() - this.getScrollAmount();
        this.children.add(0, entry);
        this.setScrollAmount((double)this.getMaxScroll() - d0);
    }

    protected boolean removeEntryFromTop(E entry) {
        double d0 = (double)this.getMaxScroll() - this.getScrollAmount();
        boolean flag = this.removeEntry(entry);
        this.setScrollAmount((double)this.getMaxScroll() - d0);
        return flag;
    }

    protected int getItemCount() {
        return this.method_25396().size();
    }

    protected boolean isSelectedItem(int index) {
        return Objects.equals(this.getSelected(), this.method_25396().get(index));
    }

    @Nullable
    public final E getEntryAtPosition(double mouseX, double mouseY) {
        int i = this.getRowWidth() / 2;
        int j = this.method_46426() + this.field_22758 / 2;
        int k = j - i;
        int l = j + i;
        int i1 = class_3532.method_15357((double)(mouseY - (double)this.method_46427())) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int j1 = i1 / this.itemHeight;
        return (E)(mouseX >= (double)k && mouseX <= (double)l && j1 >= 0 && i1 >= 0 && j1 < this.getItemCount() ? (Entry)this.method_25396().get(j1) : null);
    }

    public void updateSize(int width, class_8132 layout) {
        this.updateSizeAndPosition(width, layout.method_57727(), layout.method_48998());
    }

    public void updateSizeAndPosition(int width, int height, int y) {
        this.method_55445(width, height);
        this.method_48229(0, y);
        this.clampScrollAmount();
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected boolean clickedHeader(int x, int y) {
        return false;
    }

    protected void renderHeader(class_332 guiGraphics, int x, int y) {
    }

    protected void renderDecorations(class_332 guiGraphics, int mouseX, int mouseY) {
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.hovered = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        this.renderListBackground(guiGraphics);
        this.enableScissor(guiGraphics);
        if (this.renderHeader) {
            int i = this.getRowLeft();
            int j = this.method_46427() + 4 - (int)this.getScrollAmount();
            this.renderHeader(guiGraphics, i, j);
        }
        this.renderListItems(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_44380();
        this.renderListSeparators(guiGraphics);
        if (this.renderScrollbar && this.scrollbarVisible()) {
            int l = this.getScrollbarPosition();
            int i1 = (int)((float)(this.field_22759 * this.field_22759) / (float)this.getMaxPosition());
            i1 = class_3532.method_15340((int)i1, (int)32, (int)(this.field_22759 - 8));
            int k = (int)this.getScrollAmount() * (this.field_22759 - i1) / this.getMaxScroll() + this.method_46427();
            if (k < this.method_46427()) {
                k = this.method_46427();
            }
            RenderSystem.enableBlend();
            guiGraphics.method_52706(SCROLLER_BACKGROUND_SPRITE, l, this.method_46427(), 6, this.method_25364());
            guiGraphics.method_52706(SCROLLER_SPRITE, l, k, 6, i1);
            RenderSystem.disableBlend();
        }
        this.renderDecorations(guiGraphics, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    protected boolean scrollbarVisible() {
        return this.getMaxScroll() > 0;
    }

    protected void renderListSeparators(class_332 guiGraphics) {
        RenderSystem.enableBlend();
        class_2960 resourcelocation = this.minecraft.field_1687 == null ? class_437.field_49895 : class_437.field_49897;
        class_2960 resourcelocation1 = this.minecraft.field_1687 == null ? class_437.field_49896 : class_437.field_49898;
        guiGraphics.method_25290(resourcelocation, this.method_46426(), this.method_46427() - 2, 0.0f, 0.0f, this.method_25368(), 2, 32, 2);
        guiGraphics.method_25290(resourcelocation1, this.method_46426(), this.method_55443(), 0.0f, 0.0f, this.method_25368(), 2, 32, 2);
        RenderSystem.disableBlend();
    }

    protected void renderListBackground(class_332 guiGraphics) {
        RenderSystem.enableBlend();
        class_2960 resourcelocation = this.minecraft.field_1687 == null ? MENU_LIST_BACKGROUND : INWORLD_MENU_LIST_BACKGROUND;
        guiGraphics.method_25290(resourcelocation, this.method_46426(), this.method_46427(), (float)this.method_55442(), (float)(this.method_55443() + (int)this.getScrollAmount()), this.method_25368(), this.method_25364(), 32, 32);
        RenderSystem.disableBlend();
    }

    protected void enableScissor(class_332 guiGraphics) {
        guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());
    }

    protected void centerScrollOn(E entry) {
        this.setScrollAmount((double)(this.method_25396().indexOf(entry) * this.itemHeight) + (double)this.itemHeight / 2.0 - (double)this.field_22759 / 2.0);
    }

    protected void ensureVisible(E entry) {
        int k;
        int i = this.getRowTop(this.method_25396().indexOf(entry));
        int j = i - this.method_46427() - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = this.method_55443() - i - this.itemHeight - this.itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int scroll) {
        this.setScrollAmount(this.getScrollAmount() + (double)scroll);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setClampedScrollAmount(double scroll) {
        this.scrollAmount = class_3532.method_15350((double)scroll, (double)0.0, (double)this.getMaxScroll());
    }

    public void setScrollAmount(double scroll) {
        this.setClampedScrollAmount(scroll);
    }

    public void clampScrollAmount() {
        this.setClampedScrollAmount(this.getScrollAmount());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.field_22759 - 4));
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.getDefaultScrollbarPosition();
    }

    protected int getDefaultScrollbarPosition() {
        return this.getRealRowRight() + this.getListOutlinePadding();
    }

    private int getListOutlinePadding() {
        return 10;
    }

    protected boolean isValidMouseClick(int button) {
        return button == 0;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isValidMouseClick(button)) {
            return false;
        }
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        E e = this.getEntryAtPosition(mouseX, mouseY);
        if (e != null) {
            if (e.method_25402(mouseX, mouseY, button)) {
                E e1 = this.getFocused();
                if (e1 != e && e1 instanceof class_4069) {
                    class_4069 containereventhandler = (class_4069)e1;
                    containereventhandler.method_25395(null);
                }
                this.method_25395((class_364)e);
                this.method_25398(true);
                return true;
            }
        } else if (this.clickedHeader((int)(mouseX - (double)(this.method_46426() + this.field_22758 / 2 - this.getRowWidth() / 2)), (int)(mouseY - (double)this.method_46427()) + (int)this.getScrollAmount() - 4)) {
            return true;
        }
        return this.scrolling;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.getFocused() != null ? this.getFocused().method_25406(mouseX, mouseY, button) : false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.method_25403(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.method_46427()) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)this.method_55443()) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d0 = Math.max(1, this.getMaxScroll());
                int i = this.field_22759;
                int j = class_3532.method_15340((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.setScrollAmount(this.getScrollAmount() + dragY * d1);
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.setScrollAmount(this.getScrollAmount() - scrollY * (double)this.itemHeight / 2.0);
        return true;
    }

    public void method_25395(@Nullable class_364 focused) {
        super.method_25395(focused);
        int i = this.children.indexOf(focused);
        if (i >= 0) {
            Object e = this.children.get(i);
            this.setSelected(e);
            if (this.minecraft.method_48186().method_48183()) {
                this.ensureVisible(e);
            }
        }
    }

    @Nullable
    protected E nextEntry(class_8028 direction) {
        return (E)this.nextEntry(direction, e -> true);
    }

    @Nullable
    protected E nextEntry(class_8028 direction, Predicate<E> predicate) {
        return this.nextEntry(direction, predicate, this.getSelected());
    }

    @Nullable
    protected E nextEntry(class_8028 direction, Predicate<E> predicate, @Nullable E selected) {
        int i;
        switch (direction) {
            default: {
                throw new MatchException(null, null);
            }
            case field_41829: 
            case field_41828: {
                int n = 0;
                break;
            }
            case field_41826: {
                int n = -1;
                break;
            }
            case field_41827: {
                int n = i = 1;
            }
        }
        if (!this.method_25396().isEmpty() && i != 0) {
            int j = selected == null ? (i > 0 ? 0 : this.method_25396().size() - 1) : this.method_25396().indexOf(selected) + i;
            for (int k = j; k >= 0 && k < this.children.size(); k += i) {
                Entry e = (Entry)this.method_25396().get(k);
                if (!predicate.test(e)) continue;
                return (E)e;
            }
        }
        return null;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.method_46427() && mouseY <= (double)this.method_55443() && mouseX >= (double)this.method_46426() && mouseX <= (double)this.method_55442();
    }

    protected void renderListItems(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i = this.getRowLeft();
        int j = this.getRowWidth();
        int k = this.itemHeight - 4;
        int l = this.getItemCount();
        for (int i1 = 0; i1 < l; ++i1) {
            int j1 = this.getRowTop(i1);
            int k1 = this.getRowBottom(i1);
            if (k1 < this.method_46427() || j1 > this.method_55443()) continue;
            this.renderItem(guiGraphics, mouseX, mouseY, partialTick, i1, i, j1, j, k);
        }
    }

    protected void renderItem(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        E e = this.getEntry(index);
        ((Entry)e).renderBack(guiGraphics, index, top, left, width, height, mouseX, mouseY, Objects.equals(this.hovered, e), partialTick);
        if (this.isSelectedItem(index)) {
            int i = this.method_25370() ? -1 : -8355712;
            this.renderSelection(guiGraphics, top, width, height, i, -16777216);
        }
        ((Entry)e).render(guiGraphics, index, top, left, width, height, mouseX, mouseY, Objects.equals(this.hovered, e), partialTick);
    }

    protected void renderSelection(class_332 guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        int i = this.method_46426() + (this.field_22758 - width) / 2;
        int j = this.method_46426() + (this.field_22758 + width) / 2;
        guiGraphics.method_25294(i, top - 2, j, top + height + 2, outerColor);
        guiGraphics.method_25294(i + 1, top - 1, j - 1, top + height + 1, innerColor);
    }

    public int getRowLeft() {
        return this.method_46426() + this.field_22758 / 2 - this.getRowWidth() / 2 + 2;
    }

    private int getRealRowLeft() {
        return this.method_46426() + this.field_22758 / 2 - this.getRowWidth() / 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    private int getRealRowRight() {
        return this.getRealRowLeft() + this.getRowWidth();
    }

    protected int getRowTop(int index) {
        return this.method_46427() + 4 - (int)this.getScrollAmount() + index * this.itemHeight + this.headerHeight;
    }

    protected int getRowBottom(int index) {
        return this.getRowTop(index) + this.itemHeight;
    }

    public class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        return this.hovered != null ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    @Nullable
    protected E remove(int index) {
        Object e = this.children.get(index);
        return (E)(this.removeEntry(this.children.get(index)) ? e : null);
    }

    protected boolean removeEntry(E entry) {
        boolean flag = this.children.remove(entry);
        if (flag && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return flag;
    }

    @Nullable
    protected E getHovered() {
        return this.hovered;
    }

    void bindEntryToSelf(Entry<E> entry) {
        entry.list = this;
    }

    protected void narrateListElementPosition(class_6382 narrationElementOutput, E entry) {
        int i;
        List<E> list = this.method_25396();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            narrationElementOutput.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    class TrackedList
    extends AbstractList<E> {
        private final List<E> delegate = Lists.newArrayList();

        TrackedList() {
        }

        @Override
        public E get(int index) {
            return (Entry)this.delegate.get(index);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public E set(int index, E entry) {
            Entry e = (Entry)this.delegate.set(index, entry);
            PGScrollableWidget.this.bindEntryToSelf(entry);
            return e;
        }

        @Override
        public void add(int index, E entry) {
            this.delegate.add(index, entry);
            PGScrollableWidget.this.bindEntryToSelf(entry);
        }

        @Override
        public E remove(int index) {
            return (Entry)this.delegate.remove(index);
        }
    }

    protected static abstract class Entry<E extends Entry<E>>
    implements class_364 {
        @Deprecated
        PGScrollableWidget<E> list;

        protected Entry() {
        }

        public void method_25365(boolean focused) {
        }

        public boolean method_25370() {
            return this.list.getFocused() == this;
        }

        public abstract void render(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public void renderBack(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return Objects.equals(this.list.getEntryAtPosition(mouseX, mouseY), this);
        }
    }
}

