/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import java.text.DecimalFormat;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;

public class PGSlider
extends class_357 {
    protected class_2561 msg;
    protected double minValue;
    protected double maxValue;
    protected double stepSize;
    protected boolean drawString;
    private final DecimalFormat format;
    private boolean renderBG = true;
    private PortalGunStyle style;

    public PGSlider(int x, int y, int width, int height, class_2561 message, double currentValue, double minValue, double maxValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
        this.msg = message;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.field_22753 = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = class_3532.method_20390((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.method_25346();
    }

    public PGSlider(int x, int y, int width, int height, class_2561 message, double currentValue, double minValue, double maxValue, boolean drawString) {
        this(x, y, width, height, message, currentValue, minValue, maxValue, 0.1f, 0, drawString);
    }

    public void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    public void setRenderBG(boolean renderBG) {
        this.renderBG = renderBG;
    }

    public void setStyle(PortalGunStyle style) {
        this.style = style;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.renderBG) {
            super.method_48579(graphics, mouseX, mouseY, delta);
        } else if (this.style != null) {
            graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, this.style.bgColor());
            graphics.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.style.highlightColor());
            int i = this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8));
            graphics.method_49601(i, this.method_46427(), 8, this.method_25364(), this.style.highlightColor());
            graphics.method_25294(i, this.method_46427(), i + 8, this.method_46427() + this.method_25364(), this.style.highlightColor());
            int j = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
            this.method_49604(graphics, class_310.method_1551().field_1772, 2, j | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        }
    }

    public double getValue() {
        return this.field_22753 * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void setValue(double value) {
        this.field_22753 = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.method_25346();
    }

    public String getValueString() {
        this.format.applyPattern("#.#");
        return this.format.format(this.getValue());
    }

    public void method_25348(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        super.method_25349(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.field_22753 + (double)(f / (float)(this.field_22758 - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    private void setSliderValue(double value) {
        double oldValue = this.field_22753;
        this.field_22753 = this.snapToNearest(value);
        if (!class_3532.method_20390((double)oldValue, (double)this.field_22753)) {
            this.method_25344();
        }
        this.method_25346();
    }

    private double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        }
        value = class_3532.method_16436((double)class_3532.method_15350((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? class_3532.method_15350((double)value, (double)this.maxValue, (double)this.minValue) : class_3532.method_15350((double)value, (double)this.minValue, (double)this.maxValue);
        return class_3532.method_33722((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    protected void method_25346() {
        if (this.drawString) {
            this.method_25355((class_2561)class_2561.method_43473().method_10852(this.msg).method_27693(this.getValueString()));
        } else {
            this.method_25355((class_2561)class_2561.method_43473());
        }
    }

    protected void method_25344() {
    }
}

