/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.init;

import com.jdolphin.ricksportalgun.common.item.types.ComponentUpgrade;
import com.jdolphin.ricksportalgun.common.item.types.CreativeUpgrade;
import com.jdolphin.ricksportalgun.common.item.types.PreConditionUpgrade;
import com.jdolphin.ricksportalgun.common.item.types.UpgradeType;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class PGUpgradeTypes {
    public static final Map<class_2960, UpgradeType> UPGRADE_TYPES = new HashMap<class_2960, UpgradeType>();
    public static final UpgradeType SETTINGS = PGUpgradeTypes.registerSimple("settings", (class_2561)class_2561.method_43471((String)"tooltip.ricksportalgun.upgrade.settings"));
    public static final UpgradeType WAYPOINTS = PGUpgradeTypes.registerSimple("waypoints", (class_2561)class_2561.method_43471((String)"tooltip.ricksportalgun.upgrade.waypoints"));
    public static final UpgradeType MAX_FUEL = PGUpgradeTypes.registerSimple("max_fuel", (class_2561)class_2561.method_43471((String)"tooltip.ricksportalgun.upgrade.max_fuel"));
    public static final UpgradeType CREATIVE = PGUpgradeTypes.registerCreative("creative", (class_2561)class_2561.method_43471((String)"tooltip.ricksportalgun.upgrade.creative"));
    public static final UpgradeType DURABILITY = PGUpgradeTypes.registerComponent("durability", (class_2561)class_2561.method_43471((String)"tooltip.ricksportalgun.upgrade.durability"), class_9334.field_50076, class_3902.field_17274);
    public static final UpgradeType BIOME_LOC = PGUpgradeTypes.registerSimple("biome_loc", (class_2561)class_2561.method_43471((String)"tooltip.ricksportalgun.upgrade.biome_loc"));
    public static final UpgradeType PLAYER_LOC = PGUpgradeTypes.registerPreCondition("player_loc", (class_2561)class_2561.method_43471((String)"tooltip.ricksportalgun.upgrade.player_loc"), "biome_loc");
    public static final UpgradeType STRUCTURE_LOC = PGUpgradeTypes.registerPreCondition("structure_loc", (class_2561)class_2561.method_43471((String)"tooltip.ricksportalgun.upgrade.structure_loc"), "player_loc");
    public static final UpgradeType DIM_1 = PGUpgradeTypes.registerSimple("dim_1", (class_2561)class_2561.method_43471((String)"tooltip.ricksportalgun.upgrade.dim_1"));
    public static final UpgradeType DIM_2 = PGUpgradeTypes.registerPreCondition("dim_2", (class_2561)class_2561.method_43471((String)"tooltip.ricksportalgun.upgrade.dim_2"), "dim_1");

    private static UpgradeType registerCreative(String name, class_2561 desc) {
        CreativeUpgrade type = new CreativeUpgrade(name, desc);
        UPGRADE_TYPES.put(PGHelper.id(name), type);
        return type;
    }

    private static <T> UpgradeType registerComponent(String name, class_2561 desc, class_9331<T> componentType, T value) {
        ComponentUpgrade<T> type = new ComponentUpgrade<T>(name, desc, componentType, value);
        UPGRADE_TYPES.put(PGHelper.id(name), type);
        return type;
    }

    private static UpgradeType registerSimple(String name, class_2561 component) {
        UpgradeType type = new UpgradeType(name, component);
        UPGRADE_TYPES.put(PGHelper.id(name), type);
        return type;
    }

    private static UpgradeType registerPreCondition(String name, class_2561 component, String condition) {
        PreConditionUpgrade type = new PreConditionUpgrade(name, component, condition);
        UPGRADE_TYPES.put(PGHelper.id(name), type);
        return type;
    }

    public static UpgradeType getFromTag(String upgradeTag) {
        return UPGRADE_TYPES.values().stream().filter(type -> type.getId().equals(upgradeTag)).findFirst().orElseThrow();
    }

    public static UpgradeType getFromId(String id) {
        return UPGRADE_TYPES.values().stream().filter(type -> type.getId().equals(id)).findFirst().orElseThrow();
    }
}

