/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.item;

import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.init.PGUpgradeTypes;
import com.jdolphin.ricksportalgun.common.item.IWaypointItem;
import com.jdolphin.ricksportalgun.common.item.UpgradeItem;
import com.jdolphin.ricksportalgun.common.item.types.UpgradeType;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.Waypoint;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class PortalGunItem
extends class_1792
implements IWaypointItem {
    private final int tints;

    public PortalGunItem(class_1792.class_1793 properties, int tints) {
        super(properties);
        this.tints = tints;
    }

    public int getTints() {
        return this.tints;
    }

    public static int getMaxFuel(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.MAX_FUEL, (Object)64);
    }

    public static int getFuel(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.FUEL, (Object)PortalGunItem.getMaxFuel(stack));
    }

    public void lowerFuel(class_1799 stack, int amount) {
        int i = PortalGunItem.getFuel(stack);
        int fuel = Math.max(0, i - amount);
        stack.method_57379(PGDataComponents.FUEL, (Object)fuel);
    }

    public static void setPrimaryDye(class_1799 stack, int color) {
        stack.method_57379(PGDataComponents.PRIMARY_DYE, (Object)color);
    }

    public static void setSecondaryDye(class_1799 stack, int color) {
        stack.method_57379(PGDataComponents.SECONDARY_DYE, (Object)color);
    }

    public static int getPrimaryDye(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.PRIMARY_DYE, (Object)0xF3FBFB);
    }

    public static int getSecondaryDye(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.SECONDARY_DYE, (Object)0xF3FBFB);
    }

    public static void setCode(class_1799 stack, String code) {
        stack.method_57379(PGDataComponents.CODE, (Object)code);
    }

    public static String getCode(class_1799 stack) {
        return (String)stack.method_57825(PGDataComponents.CODE, (Object)"");
    }

    public static void refillFuel(class_1799 stack) {
        stack.method_57379(PGDataComponents.FUEL, (Object)PortalGunItem.getMaxFuel(stack));
    }

    public static boolean refuel(class_1799 stack, class_1657 player) {
        class_1268 pgHand = PGHelper.getPortalGunHand(player);
        class_1268 fluidHand = PGHelper.getOppositeHand(pgHand);
        class_1799 gunStack = player.method_5998(pgHand);
        class_1799 fluidStack = player.method_5998(fluidHand);
        if (PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack) && gunStack.method_31573(PGTags.Items.PORTAL_GUNS)) {
            if (fluidStack.method_31574(PGItems.PORTAL_FLUID)) {
                PortalGunItem.refillFuel(stack);
                fluidStack.method_7934(1);
                stack.method_57379(PGDataComponents.BOOTLEG, (Object)false);
                return true;
            }
            if (fluidStack.method_31574(PGItems.BOOTLEG_PORTAL_FLUID)) {
                PortalGunItem.refillFuel(stack);
                stack.method_57379(PGDataComponents.BOOTLEG, (Object)true);
                fluidStack.method_7934(1);
                return true;
            }
        }
        return false;
    }

    private class_243 getLocation(class_1937 level, class_2338 bPos, class_2350 dir, class_243 loc) {
        if (this.isAir(level, bPos.method_10074()) && dir == class_2350.field_11033) {
            return loc.method_1031(0.0, -0.2, 0.0);
        }
        if (dir.equals((Object)class_2350.field_11036)) {
            return loc;
        }
        if (!this.isAir(level, bPos.method_10093(dir))) {
            switch (dir) {
                case field_11043: {
                    class_243 vec = bPos.method_10095().method_61082();
                    loc = vec.method_1031(0.0, 0.0, 0.4);
                    break;
                }
                case field_11035: {
                    class_243 vec = bPos.method_10072().method_61082();
                    loc = vec.method_1031(0.0, 0.0, -0.4);
                    break;
                }
                case field_11039: {
                    class_243 vec = bPos.method_10067().method_61082();
                    loc = vec.method_1031(0.4, 0.0, 0.0);
                    break;
                }
                case field_11034: {
                    class_243 vec = bPos.method_10078().method_61082();
                    loc = vec.method_1031(-0.4, 0.0, 0.0);
                }
            }
        } else {
            float x;
            float f = dir.method_10166().equals((Object)class_2350.class_2351.field_11048) ? (dir.method_10171().equals((Object)class_2350.class_2352.field_11056) ? 0.1f : -0.1f) : (x = 0.0f);
            float z = dir.method_10166().equals((Object)class_2350.class_2351.field_11051) ? (dir.method_10171().equals((Object)class_2350.class_2352.field_11056) ? 0.1f : -0.1f) : 0.0f;
            loc = new class_243(loc.method_10216() + (double)x, (double)bPos.method_10264(), loc.method_10215() + (double)z);
        }
        return loc;
    }

    /*
     * Enabled aggressive block sorting
     */
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (level.method_8608()) return class_1271.method_22430((Object)stack);
        if (!(player instanceof class_3222)) return class_1271.method_22430((Object)stack);
        PortalGunItem.migrateOldData(stack);
        if (((String)stack.method_57825(PGDataComponents.OWNER, (Object)"")).isEmpty()) {
            stack.method_57379(PGDataComponents.OWNER, (Object)player.method_5667().toString());
        }
        if (!PGHelper.canPlayerAccessGun(player, stack)) {
            PGHelper.sendFailMsg(player, "error.ricksportalgun.security");
            return class_1271.method_22431((Object)stack);
        }
        class_1799 oppositeStack = player.method_5998(PGHelper.getOppositeHand(hand));
        class_3965 hitResult = PortalGunItem.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1347);
        if (PortalGunItem.refuel(stack, player)) return class_1271.method_22430((Object)stack);
        if (PortalGunItem.getFuel(stack) <= 0) return class_1271.method_22430((Object)stack);
        class_1792 class_17922 = oppositeStack.method_7909();
        if (class_17922 instanceof UpgradeItem) {
            UpgradeItem upgrade = (UpgradeItem)class_17922;
            class_1269 result = upgrade.onApply(player, stack);
            if (result.equals((Object)class_1269.field_5814)) return new class_1271(result, (Object)stack);
            if (player.method_7337()) return new class_1271(result, (Object)stack);
            oppositeStack.method_7934(1);
            return new class_1271(result, (Object)stack);
        }
        class_2960 dim = (class_2960)stack.method_57825(PGDataComponents.PORTAL_DIM, (Object)class_1937.field_25179.method_29177());
        class_5321<class_1937> key = LevelHelper.getWorldKey(dim);
        class_3218 serverlevel = LevelHelper.getServerWorld(level, key);
        class_2338 destination = PortalGunItem.getHopCoords(stack);
        class_243 loc = hitResult.method_17784();
        if (hitResult.method_17783().equals((Object)class_239.class_240.field_1332)) {
            class_2350 dir = hitResult.method_17780();
            class_2338 bPos = hitResult.method_17777();
            loc = this.getLocation(level, bPos, dir, loc);
        }
        class_2350 hitDir = hitResult.method_17780();
        class_2350 playerDir = player.method_5735();
        float size = ((Float)stack.method_57825(PGDataComponents.PORTAL_SIZE, (Object)Float.valueOf(1.0f))).floatValue();
        int age = (Integer)stack.method_57825(PGDataComponents.PORTAL_LIFETIME, (Object)10);
        if (serverlevel != null) {
            if (LevelHelper.canPortalTo(serverlevel, destination, stack) && LevelHelper.canPortalTo((class_3218)level, hitResult.method_17777(), stack)) {
                if (PortalGunItem.canBypassDragon(stack) || !LevelHelper.endHasDragons((class_3218)level) && !LevelHelper.endHasDragons(serverlevel)) {
                    PortalEntity portal = new PortalEntity(level, loc, hitDir, playerDir, size);
                    serverlevel.method_14178().method_12124(new class_1923(destination), true);
                    PortalEntity exPortal = new PortalEntity((class_1937)serverlevel, destination.method_10084().method_46558(), hitDir, playerDir, size);
                    boolean bootleg = (Boolean)stack.method_57825(PGDataComponents.BOOTLEG, (Object)false);
                    this.doForBoth(entity -> {
                        entity.setLifetime(PGHelper.seconds(Math.max(age, 5)));
                        entity.setColor(PortalGunItem.getColor(stack));
                        entity.setBootleg(bootleg);
                    }, portal, exPortal);
                    if (stack.method_57826(class_9334.field_49631)) {
                        class_2561 component = stack.method_7964();
                        String s = component.getString();
                        this.doForBoth(entity -> entity.method_5665((class_2561)class_2561.method_43470((String)s)), portal, exPortal);
                    }
                    portal.setHopLocation(dim, destination);
                    exPortal.setHopLocation(level.method_27983().method_29177(), portal.method_24515());
                    if (!portal.isFlat()) {
                        this.doForBoth(entity -> entity.method_36456(player.method_36454()), portal, exPortal);
                    }
                    serverlevel.method_8503().method_40000(() -> serverlevel.method_8649((class_1297)exPortal));
                    level.method_8649((class_1297)portal);
                    player.method_7259(class_3468.field_15372.method_14956((Object)this));
                    player.method_7357().method_7906((class_1792)this, PGHelper.seconds(3));
                    if (player.method_7337()) return class_1271.method_22430((Object)stack);
                    this.lowerFuel(stack, 1);
                    return class_1271.method_22430((Object)stack);
                }
                PGHelper.sendFailMsg(player, "error.ricksportalgun.destination.dragon");
                return class_1271.method_22431((Object)stack);
            }
            PGHelper.sendFailMsg(player, "error.ricksportalgun.destination.unreachable");
            return class_1271.method_22431((Object)stack);
        }
        if (!LevelHelper.isBlenderDestination(dim.toString())) return class_1271.method_22430((Object)stack);
        PortalEntity portal = new PortalEntity(level, loc, hitDir, playerDir, size);
        portal.setLifetime(PGHelper.seconds(age));
        if (stack.method_57826(class_9334.field_49631)) {
            class_2561 component = stack.method_7964();
            String s = component.getString();
            portal.method_5665((class_2561)class_2561.method_43470((String)s));
        }
        portal.setHopLocation(dim, destination);
        portal.setColor(PortalGunItem.getColor(stack));
        boolean bootleg = (Boolean)stack.method_57825(PGDataComponents.BOOTLEG, (Object)false);
        portal.setBootleg(bootleg);
        if (!portal.isFlat()) {
            portal.method_36456(player.method_36454());
        }
        if (!player.method_7337()) {
            this.lowerFuel(stack, 1);
        }
        level.method_8649((class_1297)portal);
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        player.method_7357().method_7906((class_1792)this, PGHelper.seconds(3));
        return class_1271.method_22427((Object)stack);
    }

    private void doForBoth(Consumer<PortalEntity> consumer, PortalEntity a, PortalEntity b) {
        consumer.accept(a);
        consumer.accept(b);
    }

    public static boolean canBypassDragon(class_1799 stack) {
        return PortalGunItem.getUpgrades(stack).contains(PGUpgradeTypes.DIM_2.getId());
    }

    private boolean isAir(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26215();
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 pContext, List<class_2561> toolTips, class_1836 pTooltipFlag) {
        List list = (List)stack.method_57825(PGDataComponents.WAYPOINTS, List.of());
        if (!class_437.method_25442()) {
            toolTips.add((class_2561)class_2561.method_43469((String)"ricksportalgun.destination", (Object[])new Object[]{PortalGunItem.getHopCoords(stack).method_10263(), PortalGunItem.getHopCoords(stack).method_10264(), PortalGunItem.getHopCoords(stack).method_10260()}).method_27692(class_124.field_1080));
            toolTips.add((class_2561)class_2561.method_43469((String)"ricksportalgun.dimension", (Object[])new Object[]{PortalGunItem.getHopDimension(stack).toString()}).method_27692(class_124.field_1080));
            toolTips.add((class_2561)class_2561.method_43469((String)"tooltip.ricksportalgun.fuel", (Object[])new Object[]{PortalGunItem.getFuel(stack), PortalGunItem.getMaxFuel(stack)}).method_27692(class_124.field_1080));
        } else {
            toolTips.add((class_2561)class_2561.method_43469((String)"tooltip.ricksportalgun.waypoints", (Object[])new Object[]{list.size()}).method_27692(class_124.field_1080));
            if (stack.method_57826(PGDataComponents.PRIMARY_DYE) || stack.method_57826(PGDataComponents.SECONDARY_DYE)) {
                toolTips.add((class_2561)class_2561.method_43469((String)"item.dyed", (Object[])new Object[]{list.size()}).method_27695(new class_124[]{class_124.field_1064, class_124.field_1056}));
            }
        }
    }

    public int method_31571(@NotNull class_1799 stack) {
        return PortalGunItem.getColor(stack);
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        return PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack);
    }

    public int method_31569(@NotNull class_1799 stack) {
        return Math.round((float)PortalGunItem.getFuel(stack) * 13.0f / (float)PortalGunItem.getMaxFuel(stack));
    }

    public static int getColor(class_1799 stack) {
        return (Integer)stack.method_57825(PGDataComponents.PORTAL_COLOUR, (Object)Color.GREEN.getRGB());
    }

    public static void setDefaultColor(class_1799 stack, int color) {
        stack.method_57379(PGDataComponents.DEFAULT_PORTAL_COLOUR, (Object)color);
    }

    public static void setStyle(class_1799 stack, PortalGunStyle style) {
        stack.method_57379(PGDataComponents.PORTAL_GUN_STYLE, (Object)style);
    }

    public static void setColor(class_1799 stack, int color) {
        stack.method_57379(PGDataComponents.PORTAL_COLOUR, (Object)color);
    }

    public static void setHopLocation(class_1799 stack, class_2960 dimension, class_2338 pos) {
        stack.method_57379(PGDataComponents.PORTAL_DIM, (Object)dimension);
        stack.method_57379(PGDataComponents.PORTAL_POS, (Object)pos);
    }

    public static class_2960 getHopDimension(class_1799 stack) {
        return (class_2960)stack.method_57825(PGDataComponents.PORTAL_DIM, (Object)class_1937.field_25179.method_29177());
    }

    public static class_2338 getHopCoords(class_1799 stack) {
        return (class_2338)stack.method_57825(PGDataComponents.PORTAL_POS, (Object)class_2338.field_10980);
    }

    public static List<String> getUpgrades(class_1799 stack) {
        return (List)stack.method_57825(PGDataComponents.UPGRADE_LIST, List.of());
    }

    public static void addUpgrade(class_1799 stack, UpgradeType type) {
        ArrayList<String> waypoints = new ArrayList<String>((Collection)stack.method_57825(PGDataComponents.UPGRADE_LIST, List.of()));
        waypoints.add(type.getId());
        stack.method_57379(PGDataComponents.UPGRADE_LIST, waypoints);
    }

    public static void deleteUpgrade(class_1799 stack, UpgradeType type) {
        ArrayList waypoints = new ArrayList((Collection)stack.method_57825(PGDataComponents.UPGRADE_LIST, List.of()));
        waypoints.remove(type.getId());
        stack.method_57379(PGDataComponents.UPGRADE_LIST, waypoints);
    }

    public static void migrateOldData(class_1799 stack) {
        PortalGunItem.migrateNBT(stack);
        PortalGunItem.migrateDamage(stack);
        PortalGunItem.migrateUpgrades(stack);
    }

    private static void migrateUpgrades(class_1799 stack) {
        ArrayList<String> upgrades = new ArrayList<String>((Collection)stack.method_57825(PGDataComponents.UPGRADE_LIST, List.of()));
        if (stack.method_57826(PGDataComponents.HAS_WAYPOINTS)) {
            if (((Boolean)stack.method_57824(PGDataComponents.HAS_WAYPOINTS)).booleanValue()) {
                upgrades.add(PGUpgradeTypes.WAYPOINTS.getId());
            }
            stack.method_57381(PGDataComponents.HAS_WAYPOINTS);
        }
        if (stack.method_57826(PGDataComponents.EXTRA_DIMENSIONS)) {
            if (((Boolean)stack.method_57824(PGDataComponents.EXTRA_DIMENSIONS)).booleanValue()) {
                upgrades.add(PGUpgradeTypes.DIM_1.getId());
            }
            stack.method_57381(PGDataComponents.EXTRA_DIMENSIONS);
        }
        if (stack.method_57826(PGDataComponents.EXTRA_DIMENSIONS_2)) {
            if (((Boolean)stack.method_57824(PGDataComponents.EXTRA_DIMENSIONS_2)).booleanValue()) {
                upgrades.add(PGUpgradeTypes.DIM_2.getId());
            }
            stack.method_57381(PGDataComponents.EXTRA_DIMENSIONS_2);
        }
        if (stack.method_57826(PGDataComponents.SETTINGS)) {
            if (((Boolean)stack.method_57824(PGDataComponents.SETTINGS)).booleanValue()) {
                upgrades.add(PGUpgradeTypes.SETTINGS.getId());
            }
            stack.method_57381(PGDataComponents.SETTINGS);
        }
        if (stack.method_57826(PGDataComponents.BIOME_LOC)) {
            if (((Boolean)stack.method_57824(PGDataComponents.BIOME_LOC)).booleanValue()) {
                upgrades.add(PGUpgradeTypes.BIOME_LOC.getId());
            }
            stack.method_57381(PGDataComponents.BIOME_LOC);
        }
        if (stack.method_57826(PGDataComponents.PLAYER_LOC)) {
            if (((Boolean)stack.method_57824(PGDataComponents.PLAYER_LOC)).booleanValue()) {
                upgrades.add(PGUpgradeTypes.PLAYER_LOC.getId());
            }
            stack.method_57381(PGDataComponents.PLAYER_LOC);
        }
        if (stack.method_57826(PGDataComponents.STRUCTURE_LOC)) {
            if (((Boolean)stack.method_57824(PGDataComponents.STRUCTURE_LOC)).booleanValue()) {
                upgrades.add(PGUpgradeTypes.STRUCTURE_LOC.getId());
            }
            stack.method_57381(PGDataComponents.STRUCTURE_LOC);
        }
        if (stack.method_57826(class_9334.field_50076) && !upgrades.contains(PGUpgradeTypes.DURABILITY.getId())) {
            upgrades.add(PGUpgradeTypes.DURABILITY.getId());
        }
        stack.method_57379(PGDataComponents.UPGRADE_LIST, upgrades);
    }

    private static void migrateDamage(class_1799 stack) {
        if (stack.method_57826(class_9334.field_49629)) {
            int fuel = PortalGunItem.getMaxFuel(stack) - (Integer)stack.method_57825(class_9334.field_49629, (Object)0);
            stack.method_57379(PGDataComponents.FUEL, (Object)fuel);
            stack.method_57381(class_9334.field_49629);
        }
    }

    private static void migrateNBT(class_1799 stack) {
        class_9279 data = (class_9279)stack.method_57824(class_9334.field_49628);
        if (data != null) {
            String dim = "PortalDimension";
            String fuel = "Fuel";
            String pos = "PortalPos";
            String bootleg = "Bootleg";
            String color = "Color";
            String waypoints = "Waypoints";
            String lock = "Lock";
            String owner = "Owner";
            String defaultColor = "DefaultColor";
            class_2487 tag = data.method_57461();
            if (tag.method_10545(dim)) {
                String dimension = tag.method_10558(dim);
                class_2960 rl = class_2960.method_60654((String)dimension);
                stack.method_57379(PGDataComponents.PORTAL_DIM, (Object)rl);
                tag.method_10551(dim);
            }
            if (tag.method_10545(fuel)) {
                int f = tag.method_10550(fuel);
                stack.method_57379(PGDataComponents.FUEL, (Object)f);
                tag.method_10551(fuel);
            }
            if (tag.method_10545(pos)) {
                class_2338 blockPos = (class_2338)class_2512.method_10691((class_2487)tag, (String)pos).get();
                stack.method_57379(PGDataComponents.PORTAL_POS, (Object)blockPos);
                tag.method_10551(pos);
            }
            if (tag.method_10545(bootleg)) {
                boolean acid = tag.method_10577(bootleg);
                stack.method_57379(PGDataComponents.BOOTLEG, (Object)acid);
                tag.method_10551(bootleg);
            }
            if (tag.method_10545(color)) {
                int colour = tag.method_10550(color);
                stack.method_57379(PGDataComponents.PORTAL_COLOUR, (Object)colour);
                tag.method_10551(color);
            }
            if (tag.method_10545(waypoints)) {
                class_2499 listTag = tag.method_10554(waypoints, 8);
                List<Waypoint> waypointList = listTag.stream().map(class_2520::method_10714).map(Waypoint::getWaypoint).toList();
                stack.method_57379(PGDataComponents.WAYPOINTS, waypointList);
                tag.method_10551(waypoints);
            }
            if (tag.method_10545(lock)) {
                boolean locked = tag.method_10577(lock);
                stack.method_57379(PGDataComponents.LOCK, (Object)locked);
                tag.method_10551(lock);
            }
            if (tag.method_10545(owner)) {
                String own = tag.method_10558(owner);
                stack.method_57379(PGDataComponents.OWNER, (Object)own);
                tag.method_10551(owner);
            }
            if (tag.method_10545(defaultColor)) {
                int defColour = tag.method_10550(defaultColor);
                stack.method_57379(PGDataComponents.DEFAULT_PORTAL_COLOUR, (Object)defColour);
                tag.method_10551(defaultColor);
            }
        }
    }
}

