/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.blockentity;

import com.jdolphin.ricksportalgun.common.block.PortalDispenserBlock;
import com.jdolphin.ricksportalgun.common.entity.PortalEntity;
import com.jdolphin.ricksportalgun.common.init.PGBlockEntities;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.menu.PortalDispenserMenu;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_7225;

public class PortalDispenserBlockEntity
extends class_2624 {
    public static final String TAG_FUEL = "Fuel";
    public static final String TAG_MAX_FUEL = "MaxFuel";
    public static final String TAG_COLOR = "Color";
    public static final String TAG_DEST_DIM = "DestinationDim";
    public static final String TAG_DEST_BPOS = "DestinationPos";
    public static final String TAG_DIRECTION = "Direction";
    private class_2350 dir;
    private int fuel = 16;
    private int maxFuel = 16;
    private String desDim = "minecraft:overworld";
    private class_2338 desPos = class_2338.field_10980;
    protected final class_3913 dataAccess;
    private class_2371<class_1799> items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);

    public PortalDispenserBlockEntity(class_2338 pos, class_2680 blockState) {
        super(PGBlockEntities.PORTAL_DISPENSER, pos, blockState);
        this.dataAccess = new class_3913(){

            public int method_17390(int i) {
                switch (i) {
                    case 0: {
                        return PortalDispenserBlockEntity.this.fuel;
                    }
                    case 1: {
                        return PortalDispenserBlockEntity.this.maxFuel;
                    }
                }
                return 0;
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        PortalDispenserBlockEntity.this.fuel = value;
                        break;
                    }
                    case 1: {
                        PortalDispenserBlockEntity.this.maxFuel = value;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    public void setDestination(String dimension, class_2338 pos) {
        this.desDim = dimension;
        this.desPos = pos;
    }

    public class_2338 getDestinationPos() {
        return this.desPos;
    }

    public String getDestinationDim() {
        return this.desDim;
    }

    public void method_5431() {
        class_1799 stack;
        if (!this.hasFuel() && (stack = (class_1799)this.items.getFirst()).method_31574(PGItems.PORTAL_FLUID)) {
            stack.method_7934(1);
            this.fuel = this.maxFuel;
        }
        super.method_5431();
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"menu.ricksportalgun.portal_dispenser");
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> list) {
        this.items = list;
    }

    protected class_1703 method_5465(int i, class_1661 inventory) {
        return new PortalDispenserMenu(i, inventory, (class_1263)this, this.dataAccess, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.field_11867));
    }

    public int getFuel() {
        return this.fuel;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public void setFuel(int fuel) {
        this.fuel = Math.min(this.getMaxFuel(), fuel);
    }

    public void decreaseFuel(int amount) {
        this.fuel = Math.max(0, this.fuel - amount);
    }

    public void onActivation(class_1937 level, class_2338 pos) {
        if (!level.field_9236) {
            class_2680 state = level.method_8320(pos);
            class_2350 direction = (class_2350)state.method_11654((class_2769)PortalDispenserBlock.field_10927);
            class_2338 portalPos = pos;
            if (this.hasFuel()) {
                class_2960 dim;
                class_3218 destLevel;
                for (int j = 0; j < 4 && level.method_8320((portalPos = pos.method_10079(direction, j)).method_10079(direction, 1)).method_26215(); ++j) {
                }
                if (!this.getDestinationDim().isEmpty() && this.getDestinationPos() != null && LevelHelper.canPortalTo(destLevel = LevelHelper.getServerWorld(level, LevelHelper.getWorldKey(dim = class_2960.method_60654((String)this.getDestinationDim()))), this.getDestinationPos(), null)) {
                    class_243 vec = class_243.method_24953((class_2382)portalPos).method_1031((double)direction.method_10148() * 0.4, (double)direction.method_10164() * 0.4, (double)direction.method_10165() * 0.4);
                    PortalEntity portal = new PortalEntity(level, vec, direction, this.dir, 3.0f);
                    PortalEntity exitPortal = new PortalEntity((class_1937)destLevel, class_243.method_24953((class_2382)this.getDestinationPos()), direction, this.dir, 3.0f);
                    if (!portal.isFlat()) {
                        portal.method_36456(this.dir.method_10144());
                        exitPortal.method_36456(this.dir.method_10144());
                    }
                    portal.setHopLocation(dim, this.getDestinationPos());
                    exitPortal.setHopLocation(dim, portal.method_24515());
                    if (destLevel.method_8649((class_1297)exitPortal)) {
                        level.method_8649((class_1297)portal);
                        this.decreaseFuel(1);
                    }
                }
            }
        }
    }

    public void setDirection(class_2350 direction) {
        this.dir = direction;
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.fuel = tag.method_10550(TAG_FUEL);
        this.maxFuel = tag.method_10550(TAG_MAX_FUEL);
        this.desPos = class_2512.method_10691((class_2487)tag, (String)TAG_DEST_BPOS).orElse(class_2338.field_10980);
        this.desDim = tag.method_10558(TAG_DEST_DIM);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        this.dir = class_2350.method_10150((double)tag.method_10574(TAG_DIRECTION));
        class_1262.method_5429((class_2487)tag, this.items, (class_7225.class_7874)registries);
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)registries);
        tag.method_10569(TAG_FUEL, this.fuel);
        tag.method_10569(TAG_MAX_FUEL, this.maxFuel);
        tag.method_10582(TAG_DEST_DIM, this.desDim);
        tag.method_10566(TAG_DEST_BPOS, class_2512.method_10692((class_2338)this.desPos));
        tag.method_10549(TAG_DIRECTION, (double)this.dir.method_10144());
    }

    public int method_5439() {
        return 1;
    }
}

