/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.packet.serverbound;

import com.jdolphin.ricksportalgun.common.item.PortalGunItem;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGConfigHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.jdolphin.ricksportalgun.common.util.network.PGServerPayload;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public record SBLocatePacket(String name, int value) implements PGServerPayload
{
    @Override
    public void handle(class_3222 player) {
        MinecraftServer server = player.field_13995;
        server.method_40000(() -> {
            class_2960 location;
            class_3218 level = player.method_51469();
            class_1799 stack = player.method_5998(PGHelper.getPortalGunHand((class_1657)player));
            if (this.value == 0) {
                if (PGConfigHelper.disableBiomeLocating()) {
                    PGHelper.sendFailMsg((class_1657)player, class_2561.method_43471((String)"error.ricksportalgun.locating.biome.disabled"));
                    return;
                }
                Optional optionalRegistry = server.method_30611().method_46759(class_7924.field_41236);
                if (optionalRegistry.isPresent()) {
                    location = new class_2960(this.name);
                    Pair pair = level.method_42108(biomeHolder -> biomeHolder.method_40226(location), player.method_24515(), 6400, 32, 64);
                    if (pair != null) {
                        class_2338 pos = (class_2338)pair.getFirst();
                        class_2338 safePos = LevelHelper.getSafePos(pos, level);
                        PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((class_1657)player), safePos);
                        PGHelper.sendSuccessMsg((class_1657)player, PGHelper.COORDS_SET);
                    } else {
                        PGHelper.sendFailMsg((class_1657)player, class_2561.method_43469((String)"error.ricksportalgun.locating.biome.not_in_area", (Object[])new Object[]{this.name}));
                    }
                }
            }
            if (this.value == 1) {
                if (PGConfigHelper.disablePlayerLocating()) {
                    PGHelper.sendFailMsg((class_1657)player, class_2561.method_43471((String)"error.ricksportalgun.locating.player.disabled"));
                    return;
                }
                class_3222 targetPlayer = server.method_3760().method_14566(this.name);
                if (targetPlayer != null) {
                    PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((class_1657)targetPlayer), targetPlayer.method_24515().method_10084());
                    PGHelper.sendSuccessMsg((class_1657)player, PGHelper.COORDS_SET);
                } else {
                    PGHelper.sendFailMsg((class_1657)player, class_2561.method_43469((String)"error.ricksportalgun.locating.player.not_found", (Object[])new Object[]{this.name}));
                }
            }
            if (this.value == 2) {
                if (PGConfigHelper.disableStructureLocating()) {
                    PGHelper.sendFailMsg((class_1657)player, class_2561.method_43471((String)"error.ricksportalgun.locating.structure.disabled"));
                    return;
                }
                class_2378 registry = server.method_30611().method_30530(class_7924.field_41246);
                class_3195 structure = (class_3195)registry.method_29107(class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)(location = new class_2960(this.name))));
                if (structure != null) {
                    class_6885.class_6886 set = class_6885.method_40246((class_6880[])new class_6880[]{class_6880.method_40223((Object)structure)});
                    Pair pair = level.method_14178().method_12129().method_12103(level, (class_6885)set, player.method_24515(), 256, false);
                    if (pair != null) {
                        class_2338 pos = (class_2338)pair.getFirst();
                        class_2338 safePos = LevelHelper.getSafePos(pos, level);
                        PortalGunItem.setHopLocation(stack, LevelHelper.getPlayerDimensionLocation((class_1657)player), safePos);
                        PGHelper.sendSuccessMsg((class_1657)player, PGHelper.COORDS_SET);
                    } else {
                        PGHelper.sendFailMsg((class_1657)player, class_2561.method_43469((String)"error.ricksportalgun.locating.structure.not_in_area", (Object[])new Object[]{this.name}));
                    }
                } else {
                    PGHelper.sendFailMsg((class_1657)player, class_2561.method_43469((String)"error.ricksportalgun.locating.structure.unknown", (Object[])new Object[]{this.name}));
                }
            }
        });
    }

    @Override
    public class_2960 getId() {
        return SBLocatePacket.getID();
    }

    public static SBLocatePacket decode(class_2540 buf) {
        String name = buf.method_19772();
        int value = buf.readInt();
        return new SBLocatePacket(name, value);
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10814(this.name);
        buf.writeInt(this.value);
    }

    public static class_2960 getID() {
        return PGHelper.id("locate");
    }
}

