/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.platform;

import com.jdolphin.ricksportalgun.common.config.PGClientConfig;
import com.jdolphin.ricksportalgun.common.config.PGCommonConfig;
import com.jdolphin.ricksportalgun.common.util.network.PGPayload;
import com.jdolphin.ricksportalgun.common.util.network.PGServerPayload;
import com.jdolphin.ricksportalgun.common.util.platform.services.IPlatformHelper;
import java.util.List;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7701;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public <P extends PGServerPayload> void sendPacketToServer(P packet) {
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ClientPlayNetworking.send((class_2960)packet.getId(), (class_2540)buf);
    }

    @Override
    public <P extends PGPayload> void sendPacketToClient(class_3222 player, P ... packets) {
        for (P packet : packets) {
            class_2540 buf = PacketByteBufs.create();
            packet.encode(buf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getId(), (class_2540)buf);
        }
    }

    @Override
    public String getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().toString();
    }

    @Override
    public <T extends class_2586> class_2591<T> createBlockEntityType(BiFunction<class_2338, class_2680, T> func, class_2248 ... blocks) {
        return FabricBlockEntityTypeBuilder.create(func::apply, (class_2248[])blocks).build();
    }

    @Override
    public <M extends class_1703> class_3917<M> createMenuType(BiFunction<Integer, class_1661, M> constructor) {
        return new class_3917(constructor::apply, class_7701.field_40183);
    }

    @Override
    public List<? extends String> getDisabledDimensions() {
        return PGCommonConfig.COMMON_CONFIG.getBlacklistedDims();
    }

    @Override
    public boolean disableStructureLocating() {
        return PGCommonConfig.COMMON_CONFIG.disableStructureLocating();
    }

    @Override
    public boolean disableBiomeLocating() {
        return PGCommonConfig.COMMON_CONFIG.disableBiomeLocating();
    }

    @Override
    public boolean disablePlayerLocating() {
        return PGCommonConfig.COMMON_CONFIG.disablePlayerLocating();
    }

    @Override
    public int getRandomizerMax() {
        return PGCommonConfig.COMMON_CONFIG.getMaxRandomizerDistance();
    }

    @Override
    public boolean disablePortalGunColorTint() {
        return PGClientConfig.CLIENT_CONFIG.disablePortalGunColorTint();
    }

    @Override
    public List<? extends String> getDisabledEntities() {
        return PGCommonConfig.COMMON_CONFIG.getBlacklistedEntities();
    }
}

