/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client;

import com.jdolphin.ricksportalgun.client.entity.model.PortalEntityModel;
import com.jdolphin.ricksportalgun.client.entity.render.PortalEntityRenderer;
import com.jdolphin.ricksportalgun.client.handler.ClientPacketHandler;
import com.jdolphin.ricksportalgun.client.init.PGMenuScreens;
import com.jdolphin.ricksportalgun.client.init.PGTintHandler;
import com.jdolphin.ricksportalgun.common.config.PGCommonConfig;
import com.jdolphin.ricksportalgun.common.init.PGBlocks;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.init.PGKeyBinds;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.packet.clientbound.CBOpenBarrierGuiPacket;
import com.jdolphin.ricksportalgun.common.packet.clientbound.CBOpenCoordGuiPacket;
import com.jdolphin.ricksportalgun.common.packet.clientbound.CBOpenLocatorScreenPacket;
import com.jdolphin.ricksportalgun.common.packet.clientbound.CBOpenSecurityGuiPacket;
import com.jdolphin.ricksportalgun.common.packet.clientbound.CBSyncDimensionListPacket;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBOpenCoordGuiPacket;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.jdolphin.ricksportalgun.common.util.network.PGPayload;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_5601;
import net.minecraft.class_746;
import net.minecraft.class_916;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.function.TriFunction;

public class RicksPortalGunFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ForgeConfigRegistry.INSTANCE.register("ricksportalgun", ModConfig.Type.CLIENT, (IConfigSpec)PGCommonConfig.SPEC, "ricksportalgun-client.toml");
        EntityRendererRegistry.register(PGEntities.PORTAL, PortalEntityRenderer::new);
        EntityRendererRegistry.register(PGEntities.EXPLOSIVE_ITEM, class_916::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)PortalEntityModel.LAYER_LOCATION, PortalEntityModel::createBodyLayer);
        PGMenuScreens.ALL.forEach((type, func) -> {
            class_3929.class_3930 constructor = (arg_0, arg_1, arg_2) -> ((TriFunction)func).apply(arg_0, arg_1, arg_2);
            class_3929.method_17542((class_3917)type, (class_3929.class_3930)constructor);
        });
        ColorProviderRegistry.ITEM.register(PGTintHandler::tint, (Object[])PGTintHandler.TINTABLES);
        BlockRenderLayerMap.INSTANCE.putBlock(PGBlocks.GUN_WORKBENCH, class_1921.method_23581());
        KeyBindingHelper.registerKeyBinding((class_304)PGKeyBinds.KEY_PORTAL_MENU);
        this.initClientPackets();
        this.initEvents();
    }

    private void initClientPackets() {
        RicksPortalGunFabricClient.registerGlobalReceiver(CBOpenCoordGuiPacket.getID(), CBOpenCoordGuiPacket::decode, pgPayload -> ClientPacketHandler.openCoordTravelScreen(pgPayload.strings()));
        RicksPortalGunFabricClient.registerGlobalReceiver(CBSyncDimensionListPacket.getID(), CBSyncDimensionListPacket::decode, packet -> ClientPacketHandler.syncClientDimensions(packet.dimensions()));
        RicksPortalGunFabricClient.registerGlobalReceiver(CBOpenBarrierGuiPacket.getID(), CBOpenBarrierGuiPacket::decode, packet -> ClientPacketHandler.openBarrierGui(packet.pos()));
        RicksPortalGunFabricClient.registerGlobalReceiver(CBOpenLocatorScreenPacket.getID(), CBOpenLocatorScreenPacket::decode, packet -> ClientPacketHandler.openLocatorScreen(packet.playerList(), packet.biomeList(), packet.structureList()));
        RicksPortalGunFabricClient.registerGlobalReceiver(CBOpenSecurityGuiPacket.getID(), CBOpenSecurityGuiPacket::decode, packet -> ClientPacketHandler.openSecurityScreen(packet.strings()));
    }

    private void initEvents() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_746 player = client.field_1724;
            if (player != null) {
                class_1799 stack = player.method_5998(PGHelper.getPortalGunHand((class_1657)player));
                if (PGKeyBinds.KEY_PORTAL_MENU.method_1434() && client.field_1724 != null && stack.method_31573(PGTags.Items.PORTAL_GUNS)) {
                    SBOpenCoordGuiPacket packet = new SBOpenCoordGuiPacket();
                    PGHelper.sendPacketToServer(packet);
                }
            }
        });
        ClientTickEvents.START_CLIENT_TICK.register(minecraft -> PortalEntityRenderer.tickTexture());
    }

    private static <P extends PGPayload> void registerGlobalReceiver(class_2960 rl, Function<class_2540, P> func, Consumer<P> consumer) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)rl, (client, handler, buf, responseSender) -> {
            PGPayload p = (PGPayload)func.apply(buf);
            client.execute(() -> consumer.accept(p));
        });
    }
}

