/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.blockentity;

import com.jdolphin.ricksportalgun.common.init.PGBlockEntities;
import com.jdolphin.ricksportalgun.common.init.PGRecipeTypes;
import com.jdolphin.ricksportalgun.common.menu.workbench.SkinSelectorMenu;
import com.jdolphin.ricksportalgun.common.menu.workbench.WaypointTransferMenu;
import com.jdolphin.ricksportalgun.common.menu.workbench.WorkbenchCraftingMenu;
import com.jdolphin.ricksportalgun.common.recipe.PortalGunWorkbenchRecipe;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3914;

public class GunWorkbenchBlockEntity
extends class_2621
implements class_3908 {
    public static final String TAG_MODE = "WorkbenchMode";
    public static final String TAG_PROGRESS = "CraftProgress";
    private MenuType menuType = MenuType.CRAFTING;
    public static final int OUTPUT_SLOT = 4;
    protected final class_3913 data;
    private int progress = 0;
    private int maxProgress = PGHelper.seconds(3);
    private class_2371<class_1799> items = class_2371.method_10213((int)10, (Object)class_1799.field_8037);

    public GunWorkbenchBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(PGBlockEntities.GUN_WORKBENCH, pPos, pBlockState);
        this.data = new class_3913(){

            public int method_17390(int pIndex) {
                return switch (pIndex) {
                    case 0 -> GunWorkbenchBlockEntity.this.progress;
                    case 1 -> GunWorkbenchBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void method_17391(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        GunWorkbenchBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        GunWorkbenchBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    public List<class_1799> ingredients() {
        return this.items.subList(0, 4);
    }

    public class_1703 method_5465(int pContainerId, class_1661 inventory) {
        return this.menuType.fac.create(pContainerId, inventory, this, this.data, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.field_11867));
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.menuType = MenuType.values()[tag.method_10550(TAG_MODE)];
        class_1262.method_5429((class_2487)tag, this.items);
        this.progress = tag.method_10550(TAG_PROGRESS);
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569(TAG_MODE, this.menuType.ordinal());
        class_1262.method_5426((class_2487)tag, this.items);
        tag.method_10569(TAG_PROGRESS, this.progress);
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 pos, class_2680 state, T t) {
        ((GunWorkbenchBlockEntity)t).baseTick(level, pos, state);
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void baseTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.hasRecipe()) {
            if (!this.hasCraftingFinished()) {
                this.increaseCraftingProgress();
            }
            this.method_5431();
            if (this.hasCraftingFinished() && this.craftItem()) {
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private boolean craftItem() {
        Optional<PortalGunWorkbenchRecipe> holder = this.getCurrentRecipe();
        if (holder.isPresent()) {
            PortalGunWorkbenchRecipe recipe = holder.get();
            class_1799 output = recipe.getResult();
            class_1799 result = output.method_7972();
            class_1799 inOutputSlot = this.method_5438(4);
            if (inOutputSlot.method_7960()) {
                this.lowerInputs(recipe);
                this.method_5447(4, result);
                return true;
            }
            if (class_1799.method_31577((class_1799)inOutputSlot, (class_1799)result)) {
                int i = inOutputSlot.method_7947();
                int j = result.method_7947();
                result.method_7939(i + j);
                this.lowerInputs(recipe);
                this.method_5447(4, result);
                return true;
            }
            return false;
        }
        return false;
    }

    public void setMenuType(int i) {
        this.menuType = MenuType.values()[i];
    }

    private void lowerInputs(PortalGunWorkbenchRecipe recipe) {
        List<class_1799> stacks = recipe.getInputs();
        for (class_1799 stack : stacks) {
            for (class_1799 invStack : this.ingredients()) {
                if (!class_1799.method_31577((class_1799)stack, (class_1799)invStack)) continue;
                int i = stack.method_7947();
                int j = invStack.method_7947();
                int result = Math.max(j - i, 0);
                invStack.method_7939(result);
            }
        }
    }

    private void clearInputs() {
        for (int i = 0; i < 4; ++i) {
            this.method_5447(i, class_1799.field_8037);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasRecipe() {
        Optional<PortalGunWorkbenchRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            class_1799 output = recipe.get().getResult();
            return this.method_5437(4, output);
        }
        return false;
    }

    private Optional<PortalGunWorkbenchRecipe> getCurrentRecipe() {
        return this.field_11863.method_8433().method_8132(PGRecipeTypes.WORKBENCH_TYPE, (class_1263)this, this.field_11863);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"menu.ricksportalgun.workbench");
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"menu.ricksportalgun.workbench");
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> nonNullList) {
        this.items = nonNullList;
    }

    public int method_5439() {
        return 10;
    }

    public static enum MenuType {
        WAYPOINT_TRANSFER(WaypointTransferMenu::new),
        SKIN_SELECTOR(SkinSelectorMenu::new),
        CRAFTING(WorkbenchCraftingMenu::new);

        final IMenuFactory<class_1703> fac;

        private MenuType(IMenuFactory<class_1703> factory) {
            this.fac = factory;
        }
    }

    public static interface IMenuFactory<T extends class_1703> {
        public T create(int var1, class_1661 var2, GunWorkbenchBlockEntity var3, class_3913 var4, class_3914 var5);
    }
}

