/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.config;

import com.google.common.collect.Lists;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class PGCommonConfig {
    public static final CommonConfig COMMON_CONFIG;
    public static final ForgeConfigSpec SPEC;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        SPEC = (ForgeConfigSpec)pair.getRight();
        COMMON_CONFIG = (CommonConfig)pair.getLeft();
    }

    public static class CommonConfig {
        private final ForgeConfigSpec.ConfigValue<Integer> randomizer_max;
        private final ForgeConfigSpec.ConfigValue<Boolean> disable_player_locating;
        private final ForgeConfigSpec.ConfigValue<Boolean> disable_biome_locating;
        private final ForgeConfigSpec.ConfigValue<Boolean> disable_structure_locating;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> disabled_dimensions;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> disabled_entities;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Rick's Portal Gun mod config");
            this.randomizer_max = builder.comment("Maximum distance for randomizer. Default = 10000").define("randomizer_max", (Object)10000);
            this.disable_player_locating = builder.comment("Disable locating players").define("disable_player_locating", false);
            this.disable_biome_locating = builder.comment("Disable locating biomes").define("disable_biome_locating", false);
            this.disable_structure_locating = builder.comment("Disable locating structures").define("disable_structure_locating", false);
            this.disabled_dimensions = builder.comment(new String[]{"List of Dimension IDs the portal gun can't travel to, everything else is allowed", "Separate every entry except the last one with commas"}).defineList("blacklisted_dimensions", Lists::newArrayList, String.class::isInstance);
            this.disabled_entities = builder.comment(new String[]{"List of Entity IDs that cannot travel through portals, everything else is allowed", "Separate every entry except the last one with commas"}).worldRestart().defineList("blacklisted_entities", PGHelper.defaultDisabledEntities(), String.class::isInstance);
            builder.pop();
        }

        public List<? extends String> getBlacklistedDims() {
            return (List)this.disabled_dimensions.get();
        }

        public List<? extends String> getBlacklistedEntities() {
            return (List)this.disabled_entities.get();
        }

        public boolean disableBiomeLocating() {
            return (Boolean)this.disable_biome_locating.get();
        }

        public boolean disableStructureLocating() {
            return (Boolean)this.disable_structure_locating.get();
        }

        public boolean disablePlayerLocating() {
            return (Boolean)this.disable_player_locating.get();
        }

        public int getMaxRandomizerDistance() {
            return (Integer)this.randomizer_max.get();
        }
    }
}

