/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.common.util.helper;

import com.jdolphin.ricksportalgun.PGConstants;
import com.jdolphin.ricksportalgun.common.blockentity.SubetherBarrierBlockEntity;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2881;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class LevelHelper {
    public static List<String> DIMENSIONS = new ArrayList<String>();
    public static List<String> CLIENT_DIMENSIONS = new ArrayList<String>();

    public static void addDimension(String dim) {
        if (!DIMENSIONS.contains(dim)) {
            DIMENSIONS.add(dim);
        }
    }

    public static void addDimensions(List<String> dims) {
        for (String s : dims) {
            LevelHelper.addDimension(s);
        }
    }

    public static boolean isBlenderDestination(String s) {
        return PGHelper.id("blender").toString().equals(s);
    }

    public static List<String> getDimensionsAsString(Iterable<class_3218> levels, List<String> list) {
        levels.forEach(world -> {
            class_2960 worldKey = world.method_27983().method_29177();
            String s = worldKey.toString();
            if (!s.isEmpty() && !list.contains(s)) {
                list.add(s);
            }
        });
        return list;
    }

    public static List<String> getDimensionsAsString(Iterable<class_3218> levels) {
        return LevelHelper.getDimensionsAsString(levels, new ArrayList<String>());
    }

    public static List<class_2586> getBlockEntitiesInChunks(class_3218 level, class_1923 pos, int radius) {
        if (level != null) {
            ArrayList<class_2586> list = new ArrayList<class_2586>();
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    list.addAll(level.method_8497(pos.field_9181 + x, pos.field_9180 + z).method_12214().values());
                }
            }
            return list;
        }
        return List.of();
    }

    public static boolean canPortalTo(class_3218 level, class_2338 pos, class_1799 stack) {
        if (level != null) {
            String code = "";
            if (stack != null) {
                class_2487 tag = stack.method_7948();
                code = tag.method_10545("Code") ? tag.method_10558("Code") : "";
            }
            List<class_2586> blockEntities = LevelHelper.getBlockEntitiesInChunks(level, new class_1923(pos), 3);
            for (class_2586 be : blockEntities) {
                if (!(be instanceof SubetherBarrierBlockEntity)) continue;
                SubetherBarrierBlockEntity barrier = (SubetherBarrierBlockEntity)be;
                return !barrier.canBlockPortal((class_1937)level, barrier.method_11016(), code);
            }
            return true;
        }
        return false;
    }

    public static class_5321<class_1937> getWorldKey(class_2960 dimension) {
        return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimension);
    }

    public static class_3218 getServerWorld(class_1937 level, class_5321<class_1937> dimension) {
        return level.method_8503().method_3847(dimension);
    }

    public static class_2960 getPlayerDimensionLocation(class_1657 player) {
        return LevelHelper.getLevelDimensionLocation(player.method_37908());
    }

    public static class_2338 getRandomCoord(class_2338 pos, class_3218 level, int radius) {
        class_2784 border = level.method_8621();
        class_5819 rand = level.method_8409();
        int xCoord = class_3532.method_15395((class_5819)rand, (int)(pos.method_10263() - radius), (int)(pos.method_10263() + radius));
        int yCoord = class_3532.method_15395((class_5819)rand, (int)(level.method_31607() + 1), (int)level.method_31600());
        int zCoord = class_3532.method_15395((class_5819)rand, (int)(pos.method_10260() - radius), (int)(pos.method_10260() + radius));
        return border.method_39538((double)xCoord, (double)yCoord, (double)zCoord);
    }

    public static class_3218 getRandomServerLevel(MinecraftServer server) {
        Iterable worlds = server.method_3738();
        ArrayList worldList = new ArrayList();
        worlds.forEach(world -> {
            if (world != null) {
                worldList.add(world);
            }
        });
        return (class_3218)worldList.get(PGConstants.RANDOM.nextInt(worldList.size()));
    }

    public static void randomTP(class_3222 player, int radius, boolean interdimensional) {
        class_3218 level = player.method_51469();
        class_3218 dest = LevelHelper.getRandomServerLevel(player.field_13995);
        LevelHelper.teleportEntity((class_1297)player, interdimensional ? dest : level, LevelHelper.getSafePos(LevelHelper.getRandomCoord(player.method_24515(), dest, radius), level));
    }

    public static class_2338 getSafePos(class_2338 bPos, class_3218 level) {
        return LevelHelper.getSafePos(bPos, level, 0);
    }

    private static class_2338 getSafePos(class_2338 bPos, class_3218 level, int iteration) {
        class_2338 pos1;
        int y;
        int direction;
        ++iteration;
        class_2791 chunk = level.method_22350(bPos);
        level.method_14178().method_12124(chunk.method_12004(), true);
        int height = level.method_8624(class_2902.class_2903.field_13202, bPos.method_10263(), bPos.method_10260());
        int worldCenter = (level.method_31607() + 2 + height) / 2;
        int n = direction = y > worldCenter ? -1 : 1;
        for (y = bPos.method_10264(); y >= level.method_31607() + 2 && y <= level.method_31600() && !LevelHelper.isRandomizerSafe((class_1937)level, pos1 = new class_2338(bPos.method_10263(), y, bPos.method_10260())); y += direction) {
        }
        if (!LevelHelper.isRandomizerSafe((class_1937)level, bPos = new class_2338(bPos.method_10263(), y, bPos.method_10260())) || y <= level.method_31607() + 2 || y >= level.method_31600()) {
            return iteration <= 100 ? LevelHelper.getSafePos(LevelHelper.getRandomCoord(bPos, level, 25), level, iteration) : bPos;
        }
        level.method_17988(chunk.method_12004().field_9181, chunk.method_12004().field_9180, false);
        return bPos;
    }

    public static boolean endHasDragons(class_3218 level) {
        class_2881 fight;
        if (level != null && class_1937.field_25181.method_29177().equals((Object)LevelHelper.getLevelDimensionLocation((class_1937)level)) && (fight = level.method_29198()) != null) {
            class_2881.class_8576 data = fight.method_12530();
            return !data.comp_1541() || data.comp_1543();
        }
        return false;
    }

    public static boolean isRandomizerSafe(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        class_2680 aboveState = level.method_8320(pos.method_10084());
        class_2680 belowState = level.method_8320(pos.method_10074());
        if (!(belowState.method_26228((class_1922)level, pos) || belowState.method_27852(class_2246.field_10164) || belowState.method_26215() || belowState.method_27852(class_2246.field_10463) || state.method_26228((class_1922)level, pos) || state.method_27852(class_2246.field_10382) || state.method_27852(class_2246.field_10164) || state.method_27852(class_2246.field_10463))) {
            return !aboveState.method_26228((class_1922)level, pos) && !aboveState.method_27852(class_2246.field_10382) && !aboveState.method_27852(class_2246.field_10164) && !aboveState.method_27852(class_2246.field_10463);
        }
        return false;
    }

    public static void teleportEntity(class_1297 entity, class_3218 level, class_2338 pos) {
        HashSet<class_2709> relativeSet = new HashSet<class_2709>();
        relativeSet.add(class_2709.field_12401);
        entity.method_48105(level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), relativeSet, entity.method_36454(), entity.method_36455());
    }

    public static class_2960 getLevelDimensionLocation(class_1937 world) {
        return world.method_27983().method_29177();
    }

    public static void playSound(class_1937 world, class_2338 pos, class_3414 sound, class_3419 category) {
        world.method_8396(null, pos, sound, category, 100.0f, 1.0f);
    }
}

