/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8028;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

public abstract class ScrollableList<E extends Entry<E>>
extends class_362
implements class_4068,
class_6379 {
    protected final class_310 minecraft;
    protected final int itemHeight;
    private final List<E> children = new TrackedList();
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    public boolean visible = true;
    private double scrollAmount;
    protected int headerHeight;
    private boolean scrolling;
    @Nullable
    private E selected;
    @Nullable
    private E hovered;

    public ScrollableList(class_310 pMinecraft, int pWidth, int pHeight, int x0, int pY0, int pItemHeight) {
        this.minecraft = pMinecraft;
        this.width = pWidth;
        this.height = pHeight;
        this.y0 = pY0;
        this.y1 = pY0 + pHeight;
        this.itemHeight = pItemHeight;
        this.x0 = x0;
        this.x1 = x0 + pWidth;
    }

    public int getRowWidth() {
        return 110;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E pSelected) {
        this.selected = pSelected;
    }

    public E getFirstElement() {
        return (E)((Entry)this.children.get(0));
    }

    @Nullable
    public E getFocused() {
        return (E)((Entry)super.method_25399());
    }

    public final List<E> method_25396() {
        return this.children;
    }

    protected void clearEntries() {
        this.children.clear();
        this.selected = null;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.setScrollAmount(this.getScrollAmount() - scrollY * (double)this.itemHeight / 2.0);
        return true;
    }

    protected void replaceEntries(Collection<E> pEntries) {
        this.clearEntries();
        this.children.addAll(pEntries);
    }

    protected E getEntry(int pIndex) {
        return (E)((Entry)this.method_25396().get(pIndex));
    }

    protected int addEntry(E pEntry) {
        this.children.add(pEntry);
        return this.children.size() - 1;
    }

    protected void addEntryToTop(E pEntry) {
        double d0 = (double)this.getMaxScroll() - this.getScrollAmount();
        this.children.add(0, pEntry);
        this.setScrollAmount((double)this.getMaxScroll() - d0);
    }

    protected boolean removeEntryFromTop(E pEntry) {
        double d0 = (double)this.getMaxScroll() - this.getScrollAmount();
        boolean flag = this.removeEntry(pEntry);
        this.setScrollAmount((double)this.getMaxScroll() - d0);
        return flag;
    }

    protected int getItemCount() {
        return this.method_25396().size();
    }

    protected boolean isSelectedItem(int pIndex) {
        return Objects.equals(this.getSelected(), this.method_25396().get(pIndex));
    }

    public double scrollAmount() {
        return this.scrollAmount;
    }

    @Nullable
    protected final E getEntryAtPosition(double mouseX, double mouseY) {
        int i = this.getRowWidth() / 2;
        int j = this.getLeft() + this.width / 2;
        int k = j - i;
        int l = j + i;
        int i1 = class_3532.method_15357((double)(mouseY - (double)this.getTop())) - this.headerHeight + (int)this.scrollAmount() - 4;
        int j1 = i1 / this.itemHeight;
        return (E)(mouseX >= (double)k && mouseX <= (double)l && j1 >= 0 && i1 >= 0 && j1 < this.getItemCount() ? (Entry)this.method_25396().get(j1) : null);
    }

    public void updateSize(int pWidth, int pHeight, int pY0, int pY1) {
        this.width = pWidth;
        this.height = pHeight;
        this.y0 = pY0;
        this.y1 = pY1;
        this.x0 = 0;
        this.x1 = pWidth;
    }

    public void setLeftPos(int pX0) {
        this.x0 = pX0;
        this.x1 = pX0 + this.width;
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected void clickedHeader(int pMouseX, int pMouseY) {
    }

    protected void renderBackground(class_332 pGuiGraphics) {
    }

    protected void renderDecorations(class_332 pGuiGraphics, int pMouseX, int pMouseY) {
    }

    public void method_25394(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.visible) {
            this.renderBackground(pGuiGraphics);
            int i = this.getScrollbarPosition();
            int j = i + 6;
            this.hovered = this.method_25405(pMouseX, pMouseY) ? this.getEntryAtPosition(pMouseX, pMouseY) : null;
            this.enableScissor(pGuiGraphics);
            this.renderList(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            pGuiGraphics.method_44380();
            int i2 = this.getMaxScroll();
            if (i2 > 0) {
                int j2 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
                j2 = class_3532.method_15340((int)j2, (int)32, (int)(this.y1 - this.y0 - 8));
                int k1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - j2) / i2 + this.y0;
                if (k1 < this.y0) {
                    k1 = this.y0;
                }
            }
            this.renderDecorations(pGuiGraphics, pMouseX, pMouseY);
            RenderSystem.disableBlend();
        }
    }

    protected void enableScissor(class_332 pGuiGraphics) {
        pGuiGraphics.method_44379(this.x0, this.y0, this.x1, this.y1);
    }

    protected void centerScrollOn(E pEntry) {
        this.setScrollAmount((double)(this.method_25396().indexOf(pEntry) * this.itemHeight) + (double)this.itemHeight / 2.0 - (double)(this.y1 - this.y0) / 2.0);
    }

    protected void ensureVisible(E pEntry) {
        int k;
        int i = this.getRowTop(this.method_25396().indexOf(pEntry));
        int j = i - this.y0 - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = this.y1 - i - this.itemHeight - this.itemHeight) < 0) {
            this.scroll(-k);
        }
    }

    private void scroll(int pScroll) {
        this.setScrollAmount(this.getScrollAmount() + (double)pScroll);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double pScroll) {
        this.scrollAmount = class_3532.method_15350((double)pScroll, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScrollAmount() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = pButton == 0 && pMouseX >= (double)this.getScrollbarPosition() && pMouseX < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.visible) {
            this.updateScrollingState(pMouseX, pMouseY, pButton);
            if (!this.method_25405(pMouseX, pMouseY)) {
                return false;
            }
            E e = this.getEntryAtPosition(pMouseX, pMouseY);
            if (e != null) {
                if (e.method_25402(pMouseX, pMouseY, pButton)) {
                    this.method_25395((class_364)e);
                    this.method_25398(true);
                    return true;
                }
            } else if (pButton == 0) {
                this.clickedHeader((int)(pMouseX - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(pMouseY - (double)this.y0) + (int)this.getScrollAmount() - 4);
                return true;
            }
            return this.scrolling;
        }
        return false;
    }

    public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
        if (this.getFocused() != null) {
            this.getFocused().method_25406(pMouseX, pMouseY, pButton);
        }
        return false;
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            return true;
        }
        if (pButton == 0 && this.scrolling) {
            if (pMouseY < (double)this.y0) {
                this.setScrollAmount(0.0);
            } else if (pMouseY > (double)this.y1) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d0 = Math.max(1, this.getMaxScroll());
                int i = this.y1 - this.y0;
                int j = class_3532.method_15340((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.setScrollAmount(this.getScrollAmount() + pDragY * d1);
            }
            return true;
        }
        return false;
    }

    public void method_25395(@Nullable class_364 pListener) {
        super.method_25395(pListener);
        int i = this.children.indexOf(pListener);
        if (i >= 0) {
            Entry e = (Entry)this.children.get(i);
            this.setSelected(e);
            if (this.minecraft.method_48186().method_48183()) {
                this.ensureVisible(e);
            }
        }
    }

    @Nullable
    protected E nextEntry(class_8028 pDirection) {
        return (E)this.nextEntry(pDirection, e -> true);
    }

    @Nullable
    protected E nextEntry(class_8028 pDirection, Predicate<E> pPredicate) {
        return this.nextEntry(pDirection, pPredicate, this.getSelected());
    }

    @Nullable
    protected E nextEntry(class_8028 pDirection, Predicate<E> pPredicate, @Nullable E pSelected) {
        int b0;
        switch (pDirection) {
            default: {
                throw new MatchException(null, null);
            }
            case field_41829: 
            case field_41828: {
                int n = 0;
                break;
            }
            case field_41826: {
                int n = -1;
                break;
            }
            case field_41827: {
                int n = b0 = 1;
            }
        }
        if (!this.method_25396().isEmpty() && b0 != 0) {
            int j = pSelected == null ? (b0 > 0 ? 0 : this.method_25396().size() - 1) : this.method_25396().indexOf(pSelected) + b0;
            for (int k = j; k >= 0 && k < this.children.size(); k += b0) {
                Entry e = (Entry)this.method_25396().get(k);
                if (!pPredicate.test(e)) continue;
                return (E)e;
            }
        }
        return null;
    }

    public boolean method_25405(double pMouseX, double pMouseY) {
        return pMouseY >= (double)this.y0 && pMouseY <= (double)this.y1 && pMouseX >= (double)this.x0 && pMouseX <= (double)this.x1;
    }

    protected void renderList(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int i = this.getRowLeft();
        int j = this.getRowWidth();
        int k = this.itemHeight - 4;
        int l = this.getItemCount();
        for (int i1 = 0; i1 < l; ++i1) {
            int j1 = this.getRowTop(i1);
            int k1 = this.getRowBottom(i1);
            if (k1 < this.y0 || j1 > this.y1) continue;
            this.renderItem(pGuiGraphics, pMouseX, pMouseY, pPartialTick, i1, i, j1, j, k);
        }
    }

    protected void renderItem(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, int pIndex, int pLeft, int pTop, int pWidth, int pHeight) {
        E e = this.getEntry(pIndex);
        ((Entry)e).renderBack(pGuiGraphics, pIndex, pTop, pLeft, pWidth, pHeight, pMouseX, pMouseY, Objects.equals(this.hovered, e), pPartialTick);
        if (this.isSelectedItem(pIndex)) {
            int i = this.method_25370() ? -1 : -8355712;
            this.renderSelection(pGuiGraphics, pTop, pWidth, pHeight, i, -16777216);
        }
        ((Entry)e).render(pGuiGraphics, pIndex, pTop, pLeft, pWidth, pHeight, pMouseX, pMouseY, Objects.equals(this.hovered, e), pPartialTick);
    }

    protected void renderSelection(class_332 pGuiGraphics, int pTop, int pWidth, int pHeight, int pOuterColor, int pInnerColor) {
        int i = this.x0 + (this.width - pWidth) / 2;
        int j = this.x0 + (this.width + pWidth) / 2;
        pGuiGraphics.method_25294(i, pTop - 2, j, pTop + pHeight + 2, pOuterColor);
        pGuiGraphics.method_25294(i + 1, pTop - 1, j - 1, pTop + pHeight + 1, pInnerColor);
    }

    public int getRowLeft() {
        return this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    protected int getRowTop(int pIndex) {
        return this.y0 + 4 - (int)this.getScrollAmount() + pIndex * this.itemHeight + this.headerHeight;
    }

    protected int getRowBottom(int pIndex) {
        return this.getRowTop(pIndex) + this.itemHeight;
    }

    public class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        return this.hovered != null ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    @Nullable
    protected E remove(int pIndex) {
        Entry e = (Entry)this.children.get(pIndex);
        return (E)(this.removeEntry((Entry)this.children.get(pIndex)) ? e : null);
    }

    protected boolean removeEntry(E pEntry) {
        boolean flag = this.children.remove(pEntry);
        if (flag && pEntry == this.getSelected()) {
            this.setSelected(null);
        }
        return flag;
    }

    @Nullable
    protected E getHovered() {
        return this.hovered;
    }

    void bindEntryToSelf(Entry<E> pEntry) {
        pEntry.list = this;
    }

    protected void narrateListElementPosition(class_6382 pNarrationElementOutput, E pEntry) {
        int i;
        List<E> list = this.method_25396();
        if (list.size() > 1 && (i = list.indexOf(pEntry)) != -1) {
            pNarrationElementOutput.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    public class_8030 method_48202() {
        return new class_8030(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTop() {
        return this.y0;
    }

    public int getBottom() {
        return this.y1;
    }

    public int getLeft() {
        return this.x0;
    }

    public int getRight() {
        return this.x1;
    }

    class TrackedList
    extends AbstractList<E> {
        private final List<E> delegate = Lists.newArrayList();

        TrackedList() {
        }

        @Override
        public E get(int pIndex) {
            return (Entry)this.delegate.get(pIndex);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public E set(int pIndex, E pEntry) {
            Entry e = (Entry)this.delegate.set(pIndex, pEntry);
            ScrollableList.this.bindEntryToSelf(pEntry);
            return e;
        }

        @Override
        public void add(int pIndex, E pEntry) {
            this.delegate.add(pIndex, pEntry);
            ScrollableList.this.bindEntryToSelf(pEntry);
        }

        @Override
        public E remove(int pIndex) {
            return (Entry)this.delegate.remove(pIndex);
        }
    }

    protected static abstract class Entry<E extends Entry<E>>
    implements class_364,
    class_4069 {
        @Nullable
        private class_364 focused;
        private boolean dragging;
        @Deprecated
        protected ScrollableList<E> list;

        protected Entry() {
        }

        public boolean method_25397() {
            return this.dragging;
        }

        public void method_25398(boolean pDragging) {
            this.dragging = pDragging;
        }

        public void method_25395(@Nullable class_364 pListener) {
            if (this.focused != null) {
                this.focused.method_25365(false);
            }
            if (pListener != null) {
                pListener.method_25365(true);
            }
            this.focused = pListener;
        }

        @Nullable
        public class_364 method_25399() {
            return this.focused;
        }

        public boolean method_25370() {
            return this.list.getFocused() == this;
        }

        public abstract void render(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public void renderBack(class_332 pGuiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
        }

        public boolean method_25405(double pMouseX, double pMouseY) {
            return Objects.equals(this.list.getEntryAtPosition(pMouseX, pMouseY), this);
        }
    }
}

