/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.agree.block;

import com.skniro.agree.block.init.LeafCropBlock;
import com.skniro.agree.item.AgreeItems;
import com.skniro.agree.item.Apples.AppleFoodComponents;
import com.skniro.agree.world.Tree.FireResistanceAppleSaplingGenerator;
import com.skniro.agree.world.Tree.HasteAppleSaplingGenerator;
import com.skniro.agree.world.Tree.HealthBoostAppleSaplingGenerator;
import com.skniro.agree.world.Tree.JumpBoostAppleSaplingGenerator;
import com.skniro.agree.world.Tree.NightVisionAppleSaplingGenerator;
import com.skniro.agree.world.Tree.SpeedAppleSaplingGenerator;
import com.skniro.agree.world.Tree.StrengthAppleSaplingGenerator;
import com.skniro.agree.world.Tree.VillageHeroAppleSaplingGenerator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TintedParticleLeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class AgreeBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"agree");
    public static final RegistryObject<Block> RUBY_BLOCK = AgreeBlocks.registerBlock("ruby_block", Block::new, BlockBehaviour.Properties.of().mapColor(MapColor.NETHER).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL));
    public static final RegistryObject<Block> RUBY_ORE = AgreeBlocks.registerBlock("ruby_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), properties), BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(3.0f, 3.0f));
    public static final RegistryObject<Block> DEEPSLATE_RUBY_ORE = AgreeBlocks.registerBlock("deepslate_ruby_ore", properties -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), properties), BlockBehaviour.Properties.of().requiresCorrectToolForDrops().mapColor(MapColor.DEEPSLATE).strength(4.5f, 3.0f).sound(SoundType.DEEPSLATE));
    public static final RegistryObject<Block> HASTE_APPLE_SAPLING = AgreeBlocks.registerBlock("haste_apple_sapling", properties -> new SaplingBlock(HasteAppleSaplingGenerator.HasteAppleSapling, properties), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final RegistryObject<Block> SPEED_APPLE_SAPLING = AgreeBlocks.registerBlock("speed_apple_sapling", properties -> new SaplingBlock(SpeedAppleSaplingGenerator.SpeedAppleSapling, properties), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final RegistryObject<Block> HEALTH_BOOST_SAPLING = AgreeBlocks.registerBlock("health_boost_apple_sapling", properties -> new SaplingBlock(HealthBoostAppleSaplingGenerator.HealthBoostAppleSapling, properties), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final RegistryObject<Block> FIRE_RESISTANCE_SAPLING = AgreeBlocks.registerBlock("fire_resistance_apple_sapling", properties -> new SaplingBlock(FireResistanceAppleSaplingGenerator.FireResistanceApple, properties), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final RegistryObject<Block> HERO_VILLAGE_SAPLING = AgreeBlocks.registerBlock("village_hero_apple_sapling", properties -> new SaplingBlock(VillageHeroAppleSaplingGenerator.VillageHeroSapling, properties), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final RegistryObject<Block> STRENGTH_SAPLING = AgreeBlocks.registerBlock("strength_apple_sapling", properties -> new SaplingBlock(StrengthAppleSaplingGenerator.StrengthAppleSapling, properties), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final RegistryObject<Block> NIGHT_VISION_SAPLING = AgreeBlocks.registerBlock("night_vision_sapling", properties -> new SaplingBlock(NightVisionAppleSaplingGenerator.NightVisionAppleSapling, properties), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final RegistryObject<Block> JUMP_BOOST_SAPLING = AgreeBlocks.registerBlock("jump_boost_sapling", properties -> new SaplingBlock(JumpBoostAppleSaplingGenerator.JumpBoostAppleSapling, properties), BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final RegistryObject<Block> HASTE_APPLE_LEAVES = AgreeBlocks.registerBlock("haste_apple_leave", properties -> new LeafCropBlock((BlockBehaviour.Properties)properties, AppleFoodComponents.HASTE_APPLE), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final RegistryObject<Block> SPEED_APPLE_LEAVES = AgreeBlocks.registerBlock("speed_apple_leave", properties -> new LeafCropBlock((BlockBehaviour.Properties)properties, AppleFoodComponents.SPEED_APPLE), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final RegistryObject<Block> HEALTH_BOOST_LEAVES = AgreeBlocks.registerBlock("health_boost_leave", properties -> new LeafCropBlock((BlockBehaviour.Properties)properties, AppleFoodComponents.HEALTH_BOOST_APPLE), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final RegistryObject<Block> FIRE_RESISTANCE_LEAVES = AgreeBlocks.registerBlock("fire_resistance_leave", properties -> new LeafCropBlock((BlockBehaviour.Properties)properties, AppleFoodComponents.FIRE_RESISTANCE_APPLE), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final RegistryObject<Block> HERO_VILLAGE_LEAVES = AgreeBlocks.registerBlock("village_hero_leave", properties -> new LeafCropBlock((BlockBehaviour.Properties)properties, AppleFoodComponents.HERO_VILLAGE_APPLE), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final RegistryObject<Block> STRENGTH_LEAVES = AgreeBlocks.registerBlock("strength_apple_leave", properties -> new LeafCropBlock((BlockBehaviour.Properties)properties, AppleFoodComponents.STRENGTH_APPLE), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final RegistryObject<Block> NIGHT_VISION_LEAVES = AgreeBlocks.registerBlock("night_vision_leave", properties -> new LeafCropBlock((BlockBehaviour.Properties)properties, AppleFoodComponents.NIGHT_VISION_APPLE), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final RegistryObject<Block> JUMP_BOOST_LEAVES = AgreeBlocks.registerBlock("jump_boost_leave", properties -> new LeafCropBlock((BlockBehaviour.Properties)properties, AppleFoodComponents.JUMP_BOOST_APPLE), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final RegistryObject<Block> Apple_Tree_LEAVES = AgreeBlocks.registerBlock("apple_tree_leave", properties -> new TintedParticleLeavesBlock(0.01f, properties), BlockBehaviour.Properties.of().noOcclusion().mapColor(MapColor.NETHER));
    public static final RegistryObject<Block> POTTED_HASTE_APPLE_SAPLING = AgreeBlocks.registerBlockWithoutItem("potted_haste_apple_sapling", properties -> new FlowerPotBlock((Block)HASTE_APPLE_SAPLING.get(), properties), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final RegistryObject<Block> POTTED_SPEED_APPLE_SAPLING = AgreeBlocks.registerBlockWithoutItem("potted_speed_apple_sapling", properties -> new FlowerPotBlock((Block)SPEED_APPLE_SAPLING.get(), properties), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final RegistryObject<Block> POTTED_HEALTH_BOOST_SAPLING = AgreeBlocks.registerBlockWithoutItem("potted_health_boost_apple_sapling", properties -> new FlowerPotBlock((Block)HEALTH_BOOST_SAPLING.get(), properties), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final RegistryObject<Block> POTTED_FIRE_RESISTANCE_SAPLING = AgreeBlocks.registerBlockWithoutItem("potted_fire_resistance_apple_sapling", properties -> new FlowerPotBlock((Block)FIRE_RESISTANCE_SAPLING.get(), properties), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final RegistryObject<Block> POTTED_HERO_VILLAGE_SAPLING = AgreeBlocks.registerBlockWithoutItem("potted_village_hero_apple_sapling", properties -> new FlowerPotBlock((Block)HERO_VILLAGE_SAPLING.get(), properties), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final RegistryObject<Block> POTTED_STRENGTH_SAPLING = AgreeBlocks.registerBlockWithoutItem("potted_strength_apple_sapling", properties -> new FlowerPotBlock((Block)STRENGTH_SAPLING.get(), properties), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final RegistryObject<Block> POTTED_NIGHT_VISION_SAPLING = AgreeBlocks.registerBlockWithoutItem("potted_night_vision_sapling", properties -> new FlowerPotBlock((Block)NIGHT_VISION_SAPLING.get(), properties), BlockBehaviour.Properties.of().instabreak().noOcclusion());
    public static final RegistryObject<Block> POTTED_JUMP_BOOST_SAPLING = AgreeBlocks.registerBlockWithoutItem("potted_jump_boost_sapling", properties -> new FlowerPotBlock((Block)JUMP_BOOST_SAPLING.get(), properties), BlockBehaviour.Properties.of().instabreak().noOcclusion());

    public static <B extends Block> RegistryObject<Block> register(String name, Function<BlockBehaviour.Properties, ? extends B> func, BlockBehaviour.Properties props) {
        return BLOCKS.register(name, () -> (Block)func.apply(props.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"agree", (String)name)))));
    }

    private static <B extends Block> RegistryObject<Block> registerBlockWithoutItem(String name, Function<BlockBehaviour.Properties, ? extends B> block, BlockBehaviour.Properties properties) {
        RegistryObject<Block> register = AgreeBlocks.register(name, block, properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"agree", (String)name))));
        return register;
    }

    private static <B extends Block> RegistryObject<Block> registerBlock(String name, Function<BlockBehaviour.Properties, ? extends B> block, BlockBehaviour.Properties properties) {
        RegistryObject<Block> bRegistryObject = AgreeBlocks.registerBlockWithoutItem(name, block, properties);
        AgreeBlocks.registerBlockItem(name, bRegistryObject);
        return bRegistryObject;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, Supplier<T> block) {
        return AgreeItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"agree", (String)name)))));
    }

    public static void registerAgreeBlocks(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

