/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.agree.Enchantment;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class AdvancedDamageEnchantment
extends Enchantment {
    public static final int ALL_INDEX = 0;
    public static final int UNDEAD_INDEX = 1;
    public static final int ARTHROPODS_INDEX = 2;
    private static final String[] TYPE_NAMES = new String[]{"all", "undead", "arthropods"};
    private static final int[] BASE_POWERS = new int[]{5, 5, 5};
    private static final int[] POWERS_PER_LEVEL = new int[]{13, 8, 8};
    private static final int[] MIN_MAX_POWER_DIFFERENCES = new int[]{20, 20, 20};
    public final int typeIndex;

    public AdvancedDamageEnchantment(Enchantment.Rarity weight, int typeIndex, EquipmentSlot ... slots) {
        super(weight, EnchantmentCategory.WEAPON, slots);
        this.typeIndex = typeIndex;
    }

    public int m_6183_(int level) {
        return BASE_POWERS[this.typeIndex] + (level - 1) * POWERS_PER_LEVEL[this.typeIndex];
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + MIN_MAX_POWER_DIFFERENCES[this.typeIndex];
    }

    public int m_6586_() {
        return 5;
    }

    public float m_7335_(int level, MobType group) {
        if (this.typeIndex == 0) {
            return 1.5f + (float)Math.max(0, level - 1) * 2.0f;
        }
        if (this.typeIndex == 1 && group == MobType.f_21641_) {
            return (float)level * 2.5f;
        }
        if (this.typeIndex == 2 && group == MobType.f_21642_) {
            return (float)level * 2.5f;
        }
        return 0.0f;
    }

    public boolean m_5975_(Enchantment other) {
        return !(other instanceof DamageEnchantment);
    }

    public boolean m_6081_(ItemStack stack) {
        if (stack.m_41720_() instanceof AxeItem) {
            return true;
        }
        return super.m_6081_(stack);
    }

    public void m_7677_(LivingEntity user, Entity target, int level) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (this.typeIndex == 2 && level > 0 && livingEntity.m_6336_() == MobType.f_21642_) {
                int i = 20 + user.m_217043_().m_188503_(10 * level);
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, i, 3));
            }
        }
    }
}

