/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.agree.block.init;

import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LeafCropBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    private static final VoxelShape SHAPE;
    public final Supplier<Item> fruitItem;
    public static final BooleanProperty PERSISTENT;
    public static final IntegerProperty DISTANCE;
    public static final BooleanProperty WATERLOGGED;

    public LeafCropBlock(BlockBehaviour.Properties settings, Supplier<Item> fruitItem) {
        super(settings.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(7))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.fruitItem = fruitItem;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 2;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 2 && random.m_188503_(40) == 0 && world.m_45524_(pos.m_7494_(), 0) >= 9) {
            BlockState blockState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            world.m_7731_(pos, blockState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockState));
        }
        if (this.shouldDecay(state)) {
            LeafCropBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
            world.m_7471_(pos, false);
        }
    }

    protected boolean shouldDecay(BlockState state) {
        return (Boolean)state.m_61143_((Property)PERSISTENT) == false && (Integer)state.m_61143_((Property)DISTANCE) == 7;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.m_7731_(pos, LeafCropBlock.updateDistanceFromLogs(state, (LevelAccessor)world, pos), 3);
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        int i;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if ((i = LeafCropBlock.getDistanceFromLog(neighborState) + 1) != 1 || (Integer)state.m_61143_((Property)DISTANCE) != i) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean bl;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean bl2 = bl = i == 2;
        if (i > 1) {
            int j = 1;
            LeafCropBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.fruitItem.get(), j));
            world.m_5594_((Player)null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
            BlockState blockState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
            world.m_7731_(pos, blockState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, DISTANCE, PERSISTENT, WATERLOGGED});
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean canGrow(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void grow(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(2, (Integer)state.m_61143_((Property)AGE) + 1);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    private static BlockState updateDistanceFromLogs(BlockState state, LevelAccessor world, BlockPos pos) {
        int i = 7;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutable.m_122159_((Vec3i)pos, direction);
            i = Math.min(i, LeafCropBlock.getDistanceFromLog(world.m_8055_((BlockPos)blockpos$mutable)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceFromLog(BlockState state) {
        return LeafCropBlock.getOptionalDistanceFromLog(state).orElse(7);
    }

    public static OptionalInt getOptionalDistanceFromLog(BlockState state) {
        if (state.m_204336_(BlockTags.f_13106_)) {
            return OptionalInt.of(0);
        }
        return state.m_61138_((Property)DISTANCE) ? OptionalInt.of((Integer)state.m_61143_((Property)DISTANCE)) : OptionalInt.empty();
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return LeafCropBlock.updateDistanceFromLogs(blockState, (LevelAccessor)ctx.m_43725_(), ctx.m_8083_());
    }

    static {
        DISTANCE = BlockStateProperties.f_61414_;
        PERSISTENT = BlockStateProperties.f_61447_;
        WATERLOGGED = BlockStateProperties.f_61362_;
        SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

