/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.agree.compat.jade;

import com.skniro.agree.block.init.LeafCropBlock;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;

public class LeafCropBlockProgressProvider
implements IBlockComponentProvider {
    public static final LeafCropBlockProgressProvider INSTANCE = new LeafCropBlockProgressProvider();

    @Nullable
    public Element getIcon(BlockAccessor accessor, IPluginConfig config, Element currentIcon) {
        BlockState state = accessor.getBlockState();
        Block block = state.getBlock();
        if (block instanceof LeafCropBlock) {
            LeafCropBlock leafCrop = (LeafCropBlock)block;
            return JadeUI.item((ItemStack)new ItemStack((ItemLike)leafCrop.fruitItem.get()));
        }
        return currentIcon;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        Block block = state.getBlock();
        if (block instanceof LeafCropBlock) {
            int age = (Integer)state.getValue((Property)LeafCropBlock.AGE);
            float progress = (float)age / 2.0f;
            LeafCropBlockProgressProvider.addMaturityTooltip(tooltip, progress);
        }
    }

    private static void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        MutableComponent component = growthValue < 1.0f ? IThemeHelper.get().info((Object)String.format("%.0f%%", Float.valueOf(growthValue * 100.0f))) : IThemeHelper.get().success((Object)Component.translatable((String)"tooltip.jade.crop_mature"));
        tooltip.add((Component)Component.translatable((String)"tooltip.jade.crop_growth", (Object[])new Object[]{component}));
    }

    public Identifier getUid() {
        return Identifier.tryBuild((String)"agree", (String)"apple_progress");
    }
}

