/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.agree.world;

import com.skniro.agree.block.AgreeBlocks;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class AgreeTreeConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> HASTE_APPLE_TREE = AgreeTreeConfiguredFeatures.registerKey("haste_apple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPEED_APPLE_TREE = AgreeTreeConfiguredFeatures.registerKey("speed_apple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HEALTH_BOOST_APPLE_TREE = AgreeTreeConfiguredFeatures.registerKey("health_boost_apple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FIRE_RESISTANCE_APPLE_TREE = AgreeTreeConfiguredFeatures.registerKey("fire_resistance_apple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HERO_VILLAGE_APPLE_TREE = AgreeTreeConfiguredFeatures.registerKey("village_hero_apple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STRENGTH_APPLE_TREE = AgreeTreeConfiguredFeatures.registerKey("strength_apple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NIGHT_VISION_APPLE_TREE = AgreeTreeConfiguredFeatures.registerKey("night_vision_apple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JUMP_BOOST_APPLE_TREE = AgreeTreeConfiguredFeatures.registerKey("jump_boost_apple_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_Ruby_ORE = AgreeTreeConfiguredFeatures.registerKey("overworld_ruby_ore");

    static SimpleWeightedRandomList.Builder<BlockState> pool() {
        return SimpleWeightedRandomList.builder();
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> featureRegisterable) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        BlockMatchTest netherrackReplaceables = new BlockMatchTest(Blocks.NETHERRACK);
        BlockMatchTest endstoneReplaceables = new BlockMatchTest(Blocks.END_STONE);
        List<OreConfiguration.TargetBlockState> overworldRubyOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)AgreeBlocks.RUBY_ORE.get().defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)AgreeBlocks.DEEPSLATE_RUBY_ORE.get().defaultBlockState()));
        AgreeTreeConfiguredFeatures.register(featureRegisterable, HASTE_APPLE_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)new WeightedStateProvider(AgreeTreeConfiguredFeatures.pool().add((Object)AgreeBlocks.Apple_Tree_LEAVES.get().defaultBlockState(), 3).add((Object)AgreeBlocks.HASTE_APPLE_LEAVES.get().defaultBlockState(), 1)), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).build());
        AgreeTreeConfiguredFeatures.register(featureRegisterable, SPEED_APPLE_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)new WeightedStateProvider(AgreeTreeConfiguredFeatures.pool().add((Object)AgreeBlocks.Apple_Tree_LEAVES.get().defaultBlockState(), 3).add((Object)AgreeBlocks.SPEED_APPLE_LEAVES.get().defaultBlockState(), 1)), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).build());
        AgreeTreeConfiguredFeatures.register(featureRegisterable, FIRE_RESISTANCE_APPLE_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)new WeightedStateProvider(AgreeTreeConfiguredFeatures.pool().add((Object)AgreeBlocks.Apple_Tree_LEAVES.get().defaultBlockState(), 3).add((Object)AgreeBlocks.FIRE_RESISTANCE_LEAVES.get().defaultBlockState(), 1)), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).build());
        AgreeTreeConfiguredFeatures.register(featureRegisterable, HERO_VILLAGE_APPLE_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)new WeightedStateProvider(AgreeTreeConfiguredFeatures.pool().add((Object)AgreeBlocks.Apple_Tree_LEAVES.get().defaultBlockState(), 3).add((Object)AgreeBlocks.HERO_VILLAGE_LEAVES.get().defaultBlockState(), 1)), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).build());
        AgreeTreeConfiguredFeatures.register(featureRegisterable, STRENGTH_APPLE_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)new WeightedStateProvider(AgreeTreeConfiguredFeatures.pool().add((Object)AgreeBlocks.Apple_Tree_LEAVES.get().defaultBlockState(), 3).add((Object)AgreeBlocks.STRENGTH_LEAVES.get().defaultBlockState(), 1)), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).build());
        AgreeTreeConfiguredFeatures.register(featureRegisterable, NIGHT_VISION_APPLE_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)new WeightedStateProvider(AgreeTreeConfiguredFeatures.pool().add((Object)AgreeBlocks.Apple_Tree_LEAVES.get().defaultBlockState(), 3).add((Object)AgreeBlocks.NIGHT_VISION_LEAVES.get().defaultBlockState(), 1)), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).build());
        AgreeTreeConfiguredFeatures.register(featureRegisterable, JUMP_BOOST_APPLE_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)new WeightedStateProvider(AgreeTreeConfiguredFeatures.pool().add((Object)AgreeBlocks.Apple_Tree_LEAVES.get().defaultBlockState(), 3).add((Object)AgreeBlocks.JUMP_BOOST_LEAVES.get().defaultBlockState(), 1)), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).build());
        AgreeTreeConfiguredFeatures.register(featureRegisterable, HEALTH_BOOST_APPLE_TREE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)new WeightedStateProvider(AgreeTreeConfiguredFeatures.pool().add((Object)AgreeBlocks.Apple_Tree_LEAVES.get().defaultBlockState(), 3).add((Object)AgreeBlocks.HEALTH_BOOST_LEAVES.get().defaultBlockState(), 1)), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).build());
        AgreeTreeConfiguredFeatures.register(featureRegisterable, OVERWORLD_Ruby_ORE, Feature.ORE, new OreConfiguration(overworldRubyOres, 12));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"agree", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

