/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bettertoolsandarmor.network;

import java.util.function.Supplier;
import net.mcreator.bettertoolsandarmor.BetterToolsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BetterToolsModVariables {
    public static boolean being_damaged_flag = false;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BetterToolsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.respawn_xp = message.data.respawn_xp;
                    variables.extra_jumps = message.data.extra_jumps;
                    variables.charms_equipped = message.data.charms_equipped;
                    variables.time_since_last_hurt = message.data.time_since_last_hurt;
                    variables.crystallite_emerald_heal_timer = message.data.crystallite_emerald_heal_timer;
                    variables.blocks_broken_with_sculk_crystallite_pickaxe = message.data.blocks_broken_with_sculk_crystallite_pickaxe;
                    variables.critical_hit = message.data.critical_hit;
                    variables.fall_time = message.data.fall_time;
                    variables.crystallite_amethyst_absorption_timer = message.data.crystallite_amethyst_absorption_timer;
                    variables.last_on_ground_x = message.data.last_on_ground_x;
                    variables.last_on_ground_y = message.data.last_on_ground_y;
                    variables.last_on_ground_z = message.data.last_on_ground_z;
                    variables.save_from_void_cooldown = message.data.save_from_void_cooldown;
                    variables.attack_damage = message.data.attack_damage;
                    variables.attack_damage_modifier = message.data.attack_damage_modifier;
                    variables.knockback_resistance = message.data.knockback_resistance;
                    variables.knockback_resistance_modifier = message.data.knockback_resistance_modifier;
                    variables.flaming_circlet_cooldown = message.data.flaming_circlet_cooldown;
                    variables.time_since_last_attacked = message.data.time_since_last_attacked;
                    variables.time_since_last_mined = message.data.time_since_last_mined;
                    variables.last_mined_block = message.data.last_mined_block;
                    variables.block_mining_combo = message.data.block_mining_combo;
                    variables.stick_to_ceiling = message.data.stick_to_ceiling;
                    variables.crystallite_honey_absorption_timer = message.data.crystallite_honey_absorption_timer;
                    variables.time_since_last_jumped = message.data.time_since_last_jumped;
                    variables.smelting_touch_item_to_smelt = message.data.smelting_touch_item_to_smelt;
                    variables.smelting_touch_item_to_drop = message.data.smelting_touch_item_to_drop;
                    variables.ender_titanium_boots_cooldown = message.data.ender_titanium_boots_cooldown;
                    variables.last_death_x = message.data.last_death_x;
                    variables.last_death_y = message.data.last_death_y;
                    variables.last_death_z = message.data.last_death_z;
                    variables.time_since_non_carbonated_food_eaten = message.data.time_since_non_carbonated_food_eaten;
                    variables.last_food_eaten = message.data.last_food_eaten;
                    variables.last_food_was_carbonated = message.data.last_food_was_carbonated;
                    variables.fall_start_y = message.data.fall_start_y;
                    variables.nature_ring_equipped = message.data.nature_ring_equipped;
                    variables.is_in_cold_biome = message.data.is_in_cold_biome;
                    variables.is_in_sunlight = message.data.is_in_sunlight;
                    variables.effect_energy_timer = message.data.effect_energy_timer;
                    variables.energy_vial_to_update = message.data.energy_vial_to_update;
                    variables.effect_energy_cost = message.data.effect_energy_cost;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double respawn_xp = 0.0;
        public double extra_jumps = 0.0;
        public double charms_equipped = 0.0;
        public double time_since_last_hurt = 0.0;
        public double crystallite_emerald_heal_timer = 0.0;
        public double blocks_broken_with_sculk_crystallite_pickaxe = 0.0;
        public boolean critical_hit = false;
        public double fall_time = 0.0;
        public double crystallite_amethyst_absorption_timer = 300.0;
        public double last_on_ground_x = 0.0;
        public double last_on_ground_y = 0.0;
        public double last_on_ground_z = 0.0;
        public double save_from_void_cooldown = 0.0;
        public String attack_damage = "\"\"";
        public String attack_damage_modifier = "\"\"";
        public String knockback_resistance = "\"\"";
        public String knockback_resistance_modifier = "\"\"";
        public double flaming_circlet_cooldown = 0.0;
        public double time_since_last_attacked = 0.0;
        public double time_since_last_mined = 0.0;
        public BlockState last_mined_block = Blocks.f_50016_.m_49966_();
        public double block_mining_combo = 0.0;
        public boolean stick_to_ceiling = false;
        public double crystallite_honey_absorption_timer = 0.0;
        public double time_since_last_jumped = 0.0;
        public ItemStack smelting_touch_item_to_smelt = ItemStack.f_41583_;
        public ItemStack smelting_touch_item_to_drop = ItemStack.f_41583_;
        public double ender_titanium_boots_cooldown = 0.0;
        public double last_death_x = 0.0;
        public double last_death_y = 0.0;
        public double last_death_z = 0.0;
        public double time_since_non_carbonated_food_eaten = 0.0;
        public ItemStack last_food_eaten = ItemStack.f_41583_;
        public boolean last_food_was_carbonated = false;
        public double fall_start_y = 0.0;
        public boolean nature_ring_equipped = false;
        public boolean is_in_cold_biome = false;
        public boolean is_in_sunlight = false;
        public double effect_energy_timer = 0.0;
        public ItemStack energy_vial_to_update = ItemStack.f_41583_;
        public double effect_energy_cost = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BetterToolsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("respawn_xp", this.respawn_xp);
            nbt.m_128347_("extra_jumps", this.extra_jumps);
            nbt.m_128347_("charms_equipped", this.charms_equipped);
            nbt.m_128347_("time_since_last_hurt", this.time_since_last_hurt);
            nbt.m_128347_("crystallite_emerald_heal_timer", this.crystallite_emerald_heal_timer);
            nbt.m_128347_("blocks_broken_with_sculk_crystallite_pickaxe", this.blocks_broken_with_sculk_crystallite_pickaxe);
            nbt.m_128379_("critical_hit", this.critical_hit);
            nbt.m_128347_("fall_time", this.fall_time);
            nbt.m_128347_("crystallite_amethyst_absorption_timer", this.crystallite_amethyst_absorption_timer);
            nbt.m_128347_("last_on_ground_x", this.last_on_ground_x);
            nbt.m_128347_("last_on_ground_y", this.last_on_ground_y);
            nbt.m_128347_("last_on_ground_z", this.last_on_ground_z);
            nbt.m_128347_("save_from_void_cooldown", this.save_from_void_cooldown);
            nbt.m_128359_("attack_damage", this.attack_damage);
            nbt.m_128359_("attack_damage_modifier", this.attack_damage_modifier);
            nbt.m_128359_("knockback_resistance", this.knockback_resistance);
            nbt.m_128359_("knockback_resistance_modifier", this.knockback_resistance_modifier);
            nbt.m_128347_("flaming_circlet_cooldown", this.flaming_circlet_cooldown);
            nbt.m_128347_("time_since_last_attacked", this.time_since_last_attacked);
            nbt.m_128347_("time_since_last_mined", this.time_since_last_mined);
            nbt.m_128365_("last_mined_block", (Tag)NbtUtils.m_129202_((BlockState)this.last_mined_block));
            nbt.m_128347_("block_mining_combo", this.block_mining_combo);
            nbt.m_128379_("stick_to_ceiling", this.stick_to_ceiling);
            nbt.m_128347_("crystallite_honey_absorption_timer", this.crystallite_honey_absorption_timer);
            nbt.m_128347_("time_since_last_jumped", this.time_since_last_jumped);
            nbt.m_128365_("smelting_touch_item_to_smelt", (Tag)this.smelting_touch_item_to_smelt.m_41739_(new CompoundTag()));
            nbt.m_128365_("smelting_touch_item_to_drop", (Tag)this.smelting_touch_item_to_drop.m_41739_(new CompoundTag()));
            nbt.m_128347_("ender_titanium_boots_cooldown", this.ender_titanium_boots_cooldown);
            nbt.m_128347_("last_death_x", this.last_death_x);
            nbt.m_128347_("last_death_y", this.last_death_y);
            nbt.m_128347_("last_death_z", this.last_death_z);
            nbt.m_128347_("time_since_non_carbonated_food_eaten", this.time_since_non_carbonated_food_eaten);
            nbt.m_128365_("last_food_eaten", (Tag)this.last_food_eaten.m_41739_(new CompoundTag()));
            nbt.m_128379_("last_food_was_carbonated", this.last_food_was_carbonated);
            nbt.m_128347_("fall_start_y", this.fall_start_y);
            nbt.m_128379_("nature_ring_equipped", this.nature_ring_equipped);
            nbt.m_128379_("is_in_cold_biome", this.is_in_cold_biome);
            nbt.m_128379_("is_in_sunlight", this.is_in_sunlight);
            nbt.m_128347_("effect_energy_timer", this.effect_energy_timer);
            nbt.m_128365_("energy_vial_to_update", (Tag)this.energy_vial_to_update.m_41739_(new CompoundTag()));
            nbt.m_128347_("effect_energy_cost", this.effect_energy_cost);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.respawn_xp = nbt.m_128459_("respawn_xp");
            this.extra_jumps = nbt.m_128459_("extra_jumps");
            this.charms_equipped = nbt.m_128459_("charms_equipped");
            this.time_since_last_hurt = nbt.m_128459_("time_since_last_hurt");
            this.crystallite_emerald_heal_timer = nbt.m_128459_("crystallite_emerald_heal_timer");
            this.blocks_broken_with_sculk_crystallite_pickaxe = nbt.m_128459_("blocks_broken_with_sculk_crystallite_pickaxe");
            this.critical_hit = nbt.m_128471_("critical_hit");
            this.fall_time = nbt.m_128459_("fall_time");
            this.crystallite_amethyst_absorption_timer = nbt.m_128459_("crystallite_amethyst_absorption_timer");
            this.last_on_ground_x = nbt.m_128459_("last_on_ground_x");
            this.last_on_ground_y = nbt.m_128459_("last_on_ground_y");
            this.last_on_ground_z = nbt.m_128459_("last_on_ground_z");
            this.save_from_void_cooldown = nbt.m_128459_("save_from_void_cooldown");
            this.attack_damage = nbt.m_128461_("attack_damage");
            this.attack_damage_modifier = nbt.m_128461_("attack_damage_modifier");
            this.knockback_resistance = nbt.m_128461_("knockback_resistance");
            this.knockback_resistance_modifier = nbt.m_128461_("knockback_resistance_modifier");
            this.flaming_circlet_cooldown = nbt.m_128459_("flaming_circlet_cooldown");
            this.time_since_last_attacked = nbt.m_128459_("time_since_last_attacked");
            this.time_since_last_mined = nbt.m_128459_("time_since_last_mined");
            this.last_mined_block = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)nbt.m_128469_("last_mined_block"));
            this.block_mining_combo = nbt.m_128459_("block_mining_combo");
            this.stick_to_ceiling = nbt.m_128471_("stick_to_ceiling");
            this.crystallite_honey_absorption_timer = nbt.m_128459_("crystallite_honey_absorption_timer");
            this.time_since_last_jumped = nbt.m_128459_("time_since_last_jumped");
            this.smelting_touch_item_to_smelt = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("smelting_touch_item_to_smelt"));
            this.smelting_touch_item_to_drop = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("smelting_touch_item_to_drop"));
            this.ender_titanium_boots_cooldown = nbt.m_128459_("ender_titanium_boots_cooldown");
            this.last_death_x = nbt.m_128459_("last_death_x");
            this.last_death_y = nbt.m_128459_("last_death_y");
            this.last_death_z = nbt.m_128459_("last_death_z");
            this.time_since_non_carbonated_food_eaten = nbt.m_128459_("time_since_non_carbonated_food_eaten");
            this.last_food_eaten = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("last_food_eaten"));
            this.last_food_was_carbonated = nbt.m_128471_("last_food_was_carbonated");
            this.fall_start_y = nbt.m_128459_("fall_start_y");
            this.nature_ring_equipped = nbt.m_128471_("nature_ring_equipped");
            this.is_in_cold_biome = nbt.m_128471_("is_in_cold_biome");
            this.is_in_sunlight = nbt.m_128471_("is_in_sunlight");
            this.effect_energy_timer = nbt.m_128459_("effect_energy_timer");
            this.energy_vial_to_update = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("energy_vial_to_update"));
            this.effect_energy_cost = nbt.m_128459_("effect_energy_cost");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("better_tools", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.respawn_xp = original.respawn_xp;
            clone.extra_jumps = original.extra_jumps;
            clone.charms_equipped = original.charms_equipped;
            clone.last_on_ground_x = original.last_on_ground_x;
            clone.last_on_ground_y = original.last_on_ground_y;
            clone.last_on_ground_z = original.last_on_ground_z;
            clone.save_from_void_cooldown = original.save_from_void_cooldown;
            clone.attack_damage = original.attack_damage;
            clone.attack_damage_modifier = original.attack_damage_modifier;
            clone.knockback_resistance = original.knockback_resistance;
            clone.knockback_resistance_modifier = original.knockback_resistance_modifier;
            clone.last_death_x = original.last_death_x;
            clone.last_death_y = original.last_death_y;
            clone.last_death_z = original.last_death_z;
            clone.last_food_eaten = original.last_food_eaten;
            clone.last_food_was_carbonated = original.last_food_was_carbonated;
            if (!event.isWasDeath()) {
                clone.time_since_last_hurt = original.time_since_last_hurt;
                clone.crystallite_emerald_heal_timer = original.crystallite_emerald_heal_timer;
                clone.blocks_broken_with_sculk_crystallite_pickaxe = original.blocks_broken_with_sculk_crystallite_pickaxe;
                clone.critical_hit = original.critical_hit;
                clone.fall_time = original.fall_time;
                clone.crystallite_amethyst_absorption_timer = original.crystallite_amethyst_absorption_timer;
                clone.flaming_circlet_cooldown = original.flaming_circlet_cooldown;
                clone.time_since_last_attacked = original.time_since_last_attacked;
                clone.time_since_last_mined = original.time_since_last_mined;
                clone.last_mined_block = original.last_mined_block;
                clone.block_mining_combo = original.block_mining_combo;
                clone.stick_to_ceiling = original.stick_to_ceiling;
                clone.crystallite_honey_absorption_timer = original.crystallite_honey_absorption_timer;
                clone.time_since_last_jumped = original.time_since_last_jumped;
                clone.smelting_touch_item_to_smelt = original.smelting_touch_item_to_smelt;
                clone.smelting_touch_item_to_drop = original.smelting_touch_item_to_drop;
                clone.ender_titanium_boots_cooldown = original.ender_titanium_boots_cooldown;
                clone.time_since_non_carbonated_food_eaten = original.time_since_non_carbonated_food_eaten;
                clone.fall_start_y = original.fall_start_y;
                clone.nature_ring_equipped = original.nature_ring_equipped;
                clone.is_in_cold_biome = original.is_in_cold_biome;
                clone.is_in_sunlight = original.is_in_sunlight;
                clone.effect_energy_timer = original.effect_energy_timer;
                clone.energy_vial_to_update = original.energy_vial_to_update;
                clone.effect_energy_cost = original.effect_energy_cost;
            }
        }
    }
}

