/*
 * Decompiled with CFR 0.152.
 */
package dev.noah.perplayerkit.commands;

import dev.noah.perplayerkit.util.importutil.KitsXImporter;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerPlayerKitCommand
implements CommandExecutor,
TabCompleter {
    private Plugin plugin;

    public PerPlayerKitCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Missing arguments!");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "about": {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "PerPlayerKit is a plugin that allows players to have their own kits.");
                return true;
            }
            case "import": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Missing import type!");
                    return true;
                }
                switch (args[1].toLowerCase()) {
                    case "kitsx": {
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Starting import...");
                        KitsXImporter importer = new KitsXImporter(this.plugin, sender);
                        if (!importer.checkForFiles()) {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "Missing files to import");
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "Copy data folder from KitsX into the PerPlayerKit folder");
                        }
                        importer.importFiles();
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Attempted import of KitsX data!");
                        break;
                    }
                    default: {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid import type!");
                    }
                }
                return true;
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid subcommand!");
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            return List.of("about", "import");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("import")) {
            return List.of("kitsx");
        }
        return null;
    }
}

