/*
 * Decompiled with CFR 0.152.
 */
package dev.noah.perplayerkit.commands;

import dev.noah.perplayerkit.KitManager;
import dev.noah.perplayerkit.gui.GUI;
import dev.noah.perplayerkit.util.DisabledCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicKitCommand
implements CommandExecutor,
TabCompleter {
    private Plugin plugin;

    public PublicKitCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command");
            return true;
        }
        Player player = (Player)sender;
        if (DisabledCommand.isBlockedInWorld(player)) {
            return true;
        }
        if (args.length < 1) {
            GUI kitMenu = new GUI(this.plugin);
            kitMenu.OpenPublicKitMenu(player);
            return true;
        }
        String kitName = args[0];
        KitManager.get().loadPublicKit(player, kitName);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            KitManager.get().getPublicKitList().forEach(kit -> list.add(kit.id));
            return list;
        }
        return null;
    }
}

