/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas;

import java.util.Objects;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.ItemStack;
import org.ipvp.canvas.Menu;

public class CursorDropInformation {
    private final InventoryAction inventoryAction;
    private final ClickType clickType;
    private final Menu clickedMenu;
    private final ItemStack cursorItem;
    private Event.Result result;

    CursorDropInformation(InventoryAction inventoryAction, ClickType clickType, Menu clickedMenu, Event.Result result, ItemStack cursorItem) {
        this.inventoryAction = inventoryAction;
        this.clickType = clickType;
        this.clickedMenu = clickedMenu;
        this.result = result;
        this.cursorItem = cursorItem;
    }

    public Menu getClickedMenu() {
        return this.clickedMenu;
    }

    public InventoryAction getAction() {
        return this.inventoryAction;
    }

    public ClickType getClickType() {
        return this.clickType;
    }

    public Event.Result getResult() {
        return this.result;
    }

    public void setResult(Event.Result result) {
        Objects.requireNonNull(result);
        this.result = result;
    }

    public ItemStack getCursorItem() {
        return this.cursorItem == null ? null : new ItemStack(this.cursorItem);
    }

    public int getItemAmount() {
        switch (this.getAction()) {
            case DROP_ALL_CURSOR: {
                return this.getCursorItem().getAmount();
            }
            case DROP_ONE_CURSOR: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }
}

