/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas;

import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.ipvp.canvas.ClickInformation;
import org.ipvp.canvas.CursorDropInformation;
import org.ipvp.canvas.Menu;
import org.ipvp.canvas.slot.ClickOptions;
import org.ipvp.canvas.slot.Slot;
import org.ipvp.canvas.type.AbstractMenu;
import org.ipvp.canvas.type.MenuHolder;

public final class MenuFunctionListener
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void handleGuiDrag(InventoryDragEvent event) {
        InventoryView view = event.getView();
        Inventory top = view.getTopInventory();
        if (top.getHolder() instanceof MenuHolder) {
            Menu menu = ((MenuHolder)top.getHolder()).getMenu();
            ClickType clickType = event.getType() == DragType.EVEN ? ClickType.LEFT : ClickType.RIGHT;
            Map newItems = event.getNewItems();
            for (Map.Entry entry : newItems.entrySet()) {
                int index = (Integer)entry.getKey();
                ItemStack item = (ItemStack)entry.getValue();
                if (index >= top.getSize()) continue;
                InventoryAction action = item.getAmount() > 1 ? InventoryAction.PLACE_SOME : InventoryAction.PLACE_ONE;
                this.passClickToSlot((InventoryInteractEvent)event, action, clickType, top, menu, index, (ItemStack)event.getNewItems().get(index));
                if (event.getResult() != Event.Result.DENY) continue;
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void handleGuiClick(InventoryClickEvent event) {
        InventoryView view = event.getView();
        Inventory top = view.getTopInventory();
        if (top.getHolder() instanceof MenuHolder) {
            Menu menu = ((MenuHolder)top.getHolder()).getMenu();
            Inventory clicked = event.getClickedInventory();
            InventoryAction action = event.getAction();
            switch (action) {
                case UNKNOWN: 
                case NOTHING: {
                    break;
                }
                case DROP_ALL_CURSOR: 
                case DROP_ONE_CURSOR: {
                    event.setResult(Event.Result.DENY);
                    if (menu.getCursorDropHandler().isPresent()) {
                        CursorDropInformation dropInformation = new CursorDropInformation(action, event.getClick(), menu, event.getResult(), event.getCursor());
                        menu.getCursorDropHandler().get().click((Player)event.getWhoClicked(), dropInformation);
                        event.setResult(dropInformation.getResult());
                        break;
                    }
                    event.setCancelled(true);
                    break;
                }
                case COLLECT_TO_CURSOR: {
                    event.setResult(Event.Result.DENY);
                    event.setCancelled(true);
                    return;
                }
                case DROP_ALL_SLOT: 
                case DROP_ONE_SLOT: 
                case PICKUP_ALL: 
                case PICKUP_HALF: 
                case PICKUP_ONE: 
                case PICKUP_SOME: 
                case HOTBAR_MOVE_AND_READD: 
                case PLACE_ALL: 
                case PLACE_ONE: 
                case PLACE_SOME: 
                case HOTBAR_SWAP: 
                case SWAP_WITH_CURSOR: {
                    if (clicked != top) break;
                    this.passClickToSlot(event, menu, event.getSlot());
                    break;
                }
                case MOVE_TO_OTHER_INVENTORY: {
                    int maxAvailable;
                    if (clicked == top) {
                        this.passClickToSlot(event, menu, event.getSlot());
                        break;
                    }
                    ItemStack moving = event.getCurrentItem();
                    int nextAvailableSlot = this.getNextAvailableSlot(top, moving);
                    for (int amountLeft = moving.getAmount(); nextAvailableSlot > -1 && amountLeft > 0 && event.getResult() != Event.Result.DENY; amountLeft -= maxAvailable) {
                        ItemStack inSlot = top.getItem(nextAvailableSlot);
                        maxAvailable = inSlot == null || inSlot.getType() == Material.AIR ? moving.getMaxStackSize() : inSlot.getMaxStackSize() - inSlot.getAmount();
                        maxAvailable = Math.min(maxAvailable, amountLeft);
                        ItemStack adding = new ItemStack(moving);
                        adding.setAmount(maxAvailable);
                        this.passClickToSlot((InventoryInteractEvent)event, event.getAction(), event.getClick(), event.getClickedInventory(), menu, nextAvailableSlot, adding);
                        nextAvailableSlot = this.getNextAvailableSlot(top, moving, nextAvailableSlot + 1);
                    }
                    break;
                }
            }
        }
    }

    private int getNextAvailableSlot(Inventory inventory, ItemStack moving) {
        return this.getNextAvailableSlot(inventory, moving, 0);
    }

    private int getNextAvailableSlot(Inventory inventory, ItemStack moving, int startPosition) {
        for (int targetSlot = startPosition; targetSlot < inventory.getSize(); ++targetSlot) {
            ItemStack inSlot = inventory.getItem(targetSlot);
            if (!moving.isSimilar(inSlot) || inSlot.getAmount() >= inSlot.getMaxStackSize()) continue;
            return targetSlot;
        }
        return inventory.firstEmpty();
    }

    private void passClickToSlot(InventoryClickEvent event, Menu menu, int slotIndex) {
        this.passClickToSlot((InventoryInteractEvent)event, event.getAction(), event.getClick(), event.getClickedInventory(), menu, slotIndex);
    }

    private void passClickToSlot(InventoryInteractEvent handle, InventoryAction inventoryAction, ClickType clickType, Inventory clicked, Menu menu, int slotIndex) {
        this.passClickToSlot(handle, inventoryAction, clickType, clicked, menu, slotIndex, null);
    }

    private void passClickToSlot(InventoryInteractEvent handle, InventoryAction inventoryAction, ClickType clickType, Inventory clicked, Menu menu, int slotIndex, ItemStack addingItem) {
        Slot slot = menu.getSlot(slotIndex);
        ClickOptions options = slot.getClickOptions();
        if (!options.isAllowedClickType(clickType) || !options.isAllowedAction(inventoryAction)) {
            handle.setResult(Event.Result.DENY);
        }
        ClickInformation clickInformation = new ClickInformation(handle, inventoryAction, clickType, clicked, menu, slot, handle.getResult(), addingItem);
        if (slot.getClickHandler().isPresent()) {
            slot.getClickHandler().get().click((Player)handle.getWhoClicked(), clickInformation);
        }
        handle.setResult(clickInformation.getResult());
    }

    @EventHandler(ignoreCancelled=true)
    public void preventShiftClickInCustomTiles(InventoryClickEvent event) {
        Inventory top = event.getView().getTopInventory();
        if (top.getHolder() instanceof MenuHolder && this.isShiftClickingBlocked(top.getType()) && event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            event.setCancelled(true);
        }
    }

    private boolean isShiftClickingBlocked(InventoryType type) {
        switch (type) {
            case HOPPER: 
            case WORKBENCH: 
            case DROPPER: 
            case DISPENSER: {
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void triggerCloseHandler(InventoryCloseEvent event) {
        Inventory closed = event.getInventory();
        if (closed.getHolder() instanceof MenuHolder) {
            Menu menu = ((MenuHolder)closed.getHolder()).getMenu();
            ((AbstractMenu)menu).closedByPlayer((Player)event.getPlayer(), true);
        }
    }
}

