/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas.paginate;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.inventory.ItemStack;
import org.ipvp.canvas.Menu;
import org.ipvp.canvas.mask.Mask;
import org.ipvp.canvas.slot.Slot;
import org.ipvp.canvas.template.ItemStackTemplate;
import org.ipvp.canvas.template.StaticItemTemplate;

public abstract class AbstractPaginatedMenuBuilder<T extends AbstractPaginatedMenuBuilder<T>> {
    private final Menu.Builder<?> pageBuilder;
    private final List<Consumer<Menu>> newMenuModifiers;
    private int previousButtonSlot = -1;
    private int nextButtonSlot = -1;
    private ItemStackTemplate previousButton;
    private ItemStackTemplate previousButtonEmpty;
    private ItemStackTemplate nextButton;
    private ItemStackTemplate nextButtonEmpty;

    public AbstractPaginatedMenuBuilder(Menu.Builder<?> pageBuilder) {
        this.pageBuilder = pageBuilder;
        this.newMenuModifiers = new LinkedList<Consumer<Menu>>();
    }

    public Menu.Builder<?> getPageBuilder() {
        return this.pageBuilder;
    }

    public T newMenuModifier(Consumer<Menu> newMenuModifier) {
        if (newMenuModifier == null) {
            throw new IllegalArgumentException("Menu modifier cannot be null");
        }
        this.newMenuModifiers.add(newMenuModifier);
        return (T)this;
    }

    public T newMenuModifiers(Collection<Consumer<Menu>> newMenuModifiers) {
        newMenuModifiers.forEach(this::newMenuModifier);
        return (T)this;
    }

    public List<Consumer<Menu>> getNewMenuModifiers() {
        return this.newMenuModifiers;
    }

    public int getPreviousButtonSlot() {
        return this.previousButtonSlot;
    }

    public T previousButtonSlot(int previousButtonSlot) {
        this.previousButtonSlot = previousButtonSlot;
        return (T)this;
    }

    public T previousButtonSlot(Mask previousButtonSlot) {
        return this.previousButtonSlot(AbstractPaginatedMenuBuilder.indexFromMask(previousButtonSlot));
    }

    public int getNextButtonSlot() {
        return this.nextButtonSlot;
    }

    public T nextButtonSlot(int nextButtonSlot) {
        this.nextButtonSlot = nextButtonSlot;
        return (T)this;
    }

    public T nextButtonSlot(Mask nextButtonSlot) {
        return this.nextButtonSlot(AbstractPaginatedMenuBuilder.indexFromMask(nextButtonSlot));
    }

    private static int indexFromMask(Mask mask) {
        if (mask.getSlots().isEmpty()) {
            return -1;
        }
        return mask.getSlots().iterator().next();
    }

    public ItemStackTemplate getPreviousButton() {
        return this.previousButton;
    }

    public T previousButton(ItemStack item) {
        return this.previousButton(new StaticItemTemplate(item));
    }

    public T previousButton(ItemStackTemplate item) {
        this.previousButton = item;
        return (T)this;
    }

    public ItemStackTemplate getPreviousButtonEmpty() {
        return this.previousButtonEmpty;
    }

    public T previousButtonEmpty(ItemStack item) {
        return this.previousButtonEmpty(new StaticItemTemplate(item));
    }

    public T previousButtonEmpty(ItemStackTemplate item) {
        this.previousButtonEmpty = item;
        return (T)this;
    }

    public ItemStackTemplate getNextButton() {
        return this.nextButton;
    }

    public T nextButton(ItemStack item) {
        return this.nextButton(new StaticItemTemplate(item));
    }

    public T nextButton(ItemStackTemplate item) {
        this.nextButton = item;
        return (T)this;
    }

    public ItemStackTemplate getNextButtonEmpty() {
        return this.nextButtonEmpty;
    }

    public T nextButtonEmpty(ItemStack item) {
        return this.nextButtonEmpty(new StaticItemTemplate(item));
    }

    public T nextButtonEmpty(ItemStackTemplate item) {
        this.nextButtonEmpty = item;
        return (T)this;
    }

    void linkPages(List<Menu> pages) {
        for (int i = 1; i < pages.size(); ++i) {
            Menu page = pages.get(i);
            Menu prev = pages.get(i - 1);
            this.setPaginationIcon(prev, this.nextButtonSlot, this.nextButton, (p, c) -> page.open(p));
            this.setPaginationIcon(page, this.previousButtonSlot, this.previousButton, (p, c) -> prev.open(p));
        }
    }

    void setPaginationIcon(Menu menu, int slotIndex, ItemStackTemplate icon) {
        this.setPaginationIcon(menu, slotIndex, icon, null);
    }

    void setPaginationIcon(Menu menu, int slotIndex, ItemStackTemplate icon, Slot.ClickHandler clickHandler) {
        if (slotIndex >= 0 && slotIndex < menu.getDimensions().getArea()) {
            Slot slot = menu.getSlot(slotIndex);
            slot.setItemTemplate(icon);
            slot.setClickHandler(clickHandler);
        }
    }
}

