/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas.slot;

import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.ipvp.canvas.slot.ClickOptions;
import org.ipvp.canvas.slot.Slot;
import org.ipvp.canvas.template.ItemStackTemplate;
import org.ipvp.canvas.template.StaticItemTemplate;

public class SlotSettings {
    private ClickOptions clickOptions;
    private Slot.ClickHandler clickHandler;
    private ItemStackTemplate itemTemplate;

    SlotSettings(ClickOptions clickOptions, Slot.ClickHandler clickHandler, ItemStackTemplate itemTemplate) {
        this.clickOptions = clickOptions;
        this.clickHandler = clickHandler;
        this.itemTemplate = itemTemplate;
    }

    public ClickOptions getClickOptions() {
        return this.clickOptions;
    }

    public Slot.ClickHandler getClickHandler() {
        return this.clickHandler;
    }

    public ItemStackTemplate getItemTemplate() {
        return this.itemTemplate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ClickOptions clickOptions;
        private Slot.ClickHandler clickHandler;
        private ItemStackTemplate itemTemplate;

        private Builder() {
        }

        public Builder clickOptions(ClickOptions clickOptions) {
            this.clickOptions = clickOptions;
            return this;
        }

        public Builder clickHandler(Slot.ClickHandler clickHandler) {
            this.clickHandler = clickHandler;
            return this;
        }

        public Builder item(ItemStack itemStack) {
            return this.itemTemplate(itemStack == null ? null : new StaticItemTemplate(itemStack));
        }

        public Builder item(Supplier<ItemStack> itemStack) {
            return this.item(itemStack.get());
        }

        public Builder itemTemplate(ItemStackTemplate itemTemplate) {
            this.itemTemplate = itemTemplate;
            return this;
        }

        public SlotSettings build() {
            return new SlotSettings(this.clickOptions, this.clickHandler, this.itemTemplate);
        }
    }
}

