/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo;

import com.lunarclient.apollo.ApolloPlatform;
import com.lunarclient.apollo.module.ApolloModuleManager;
import com.lunarclient.apollo.player.ApolloPlayerManager;
import com.lunarclient.apollo.world.ApolloWorldManager;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class Apollo {
    private static ApolloPlatform platform = null;
    private static ApolloModuleManager moduleManager = null;
    private static ApolloWorldManager worldManager = null;
    private static ApolloPlayerManager playerManager = null;

    public static ApolloPlatform getPlatform() {
        return Apollo.checkEnabled(platform);
    }

    public static ApolloModuleManager getModuleManager() {
        return Apollo.checkEnabled(moduleManager);
    }

    public static ApolloWorldManager getWorldManager() {
        return Apollo.checkEnabled(worldManager);
    }

    public static ApolloPlayerManager getPlayerManager() {
        return Apollo.checkEnabled(playerManager);
    }

    static void initialize(@NonNull ApolloPlatform platform, @NonNull ApolloModuleManager moduleManager, @NonNull ApolloWorldManager worldManager, @NonNull ApolloPlayerManager playerManager) {
        if (platform == null) {
            throw new NullPointerException("platform is marked non-null but is null");
        }
        if (moduleManager == null) {
            throw new NullPointerException("moduleManager is marked non-null but is null");
        }
        if (worldManager == null) {
            throw new NullPointerException("worldManager is marked non-null but is null");
        }
        if (playerManager == null) {
            throw new NullPointerException("playerManager is marked non-null but is null");
        }
        Apollo.platform = platform;
        Apollo.moduleManager = moduleManager;
        Apollo.worldManager = worldManager;
        Apollo.playerManager = playerManager;
    }

    private static <T> T checkEnabled(@Nullable T object) {
        if (object == null) {
            throw new UnsupportedOperationException("Apollo has not started yet!");
        }
        return object;
    }

    private Apollo() {
    }
}

