/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.api;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.api.ApiRequest;
import com.lunarclient.apollo.api.ApiRequestType;
import com.lunarclient.apollo.api.ApiResponse;
import com.lunarclient.apollo.api.request.DownloadFileRequest;
import com.lunarclient.apollo.api.response.DownloadFileResponse;
import com.lunarclient.apollo.async.Future;
import com.lunarclient.apollo.async.future.UncertainFuture;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public final class ApolloHttpManager {
    private final ExecutorService requestExecutor = Executors.newSingleThreadExecutor();

    public <T extends ApiResponse> Future<T> request(ApiRequest<T> request) {
        UncertainFuture future = new UncertainFuture();
        ApiRequestType requestType = request.getType();
        Type responseType = request.getResponseType();
        this.requestExecutor.submit(() -> {
            block50: {
                try {
                    URL url = new URL("https://" + request.getService().getUrl() + request.getRoute());
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setRequestMethod(requestType.name());
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(5000);
                    try {
                        int responseCode;
                        if (requestType == ApiRequestType.POST) {
                            connection.setDoOutput(true);
                            try (OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());){
                                ApolloManager.GSON.toJson((Object)request, (Appendable)out);
                            }
                        }
                        if ((responseCode = connection.getResponseCode()) == 200) {
                            ApiResponse response;
                            String rawResponse;
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                                rawResponse = in.readLine();
                                response = (ApiResponse)ApolloManager.GSON.fromJson(rawResponse, responseType);
                            }
                            if (response == null) {
                                Throwable error = new Throwable(String.format("Failed to parse %s with output %s", responseType.getTypeName(), rawResponse));
                                future.handleFailure(error);
                                return;
                            }
                            future.handleSuccess(response);
                            break block50;
                        }
                        StringBuilder response = new StringBuilder();
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getErrorStream()));){
                            String rawResponse;
                            while ((rawResponse = in.readLine()) != null) {
                                response.append(rawResponse);
                            }
                        }
                        future.handleFailure(new Throwable(String.format("Failed to send %s with output %s", responseType.getTypeName(), response)));
                    }
                    catch (IOException e) {
                        ApolloHttpManager.handleError("Failed to parse request!", e, request);
                    }
                    finally {
                        connection.disconnect();
                    }
                }
                catch (Throwable t) {
                    ApolloHttpManager.handleError("Failed to open connection!", t, request);
                }
            }
        });
        return future;
    }

    public Future<DownloadFileResponse> download(DownloadFileRequest request) {
        UncertainFuture<DownloadFileResponse> future = new UncertainFuture<DownloadFileResponse>();
        String url = request.getUrl();
        this.requestExecutor.submit(() -> {
            try {
                InputStream in = new URL(url).openStream();
                Files.copy(in, request.getTarget(), StandardCopyOption.REPLACE_EXISTING);
                future.handleSuccess(new DownloadFileResponse());
            }
            catch (Throwable t) {
                future.handleFailure(new Throwable(String.format("Failed to download file %s", url)));
                t.printStackTrace();
            }
        });
        return future;
    }

    public static void handleError(String message, Throwable throwable, @Nullable ApiRequest<?> request) {
        Logger logger = Apollo.getPlatform().getPlatformLogger();
        if (request == null) {
            logger.log(Level.SEVERE, message, throwable);
            return;
        }
        logger.severe(message);
        logger.log(Level.SEVERE, String.format("%s (%s) [%s]: %s", new Object[]{request.getClass().getSimpleName(), request.getRoute(), request.getType(), request}), throwable);
    }
}

