/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.libs.configurate.yaml;

import com.lunarclient.apollo.libs.configurate.loader.CommentHandlers;
import java.util.stream.Stream;

final class YamlCommentHandler
extends CommentHandlers.AbstractPrefixHandler {
    static final YamlCommentHandler INSTANCE = new YamlCommentHandler();
    private static final char PREFIX = '#';

    public static boolean applyPadding(String line) {
        char first;
        return !line.isEmpty() && (first = line.charAt(0)) != ' ' && first != '#' && first != '-';
    }

    private YamlCommentHandler() {
        super(String.valueOf('#'));
    }

    @Override
    public Stream<String> toComment(Stream<String> lines) {
        return lines.map(line -> {
            if (!YamlCommentHandler.applyPadding(line)) {
                return this.commentPrefix + line;
            }
            return this.commentPrefix + ' ' + line;
        });
    }
}

