/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.listener;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.metadata.VelocityMetadataManager;
import com.lunarclient.apollo.util.ByteBufUtil;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.player.PlayerClientBrandEvent;
import com.velocitypowered.api.event.player.PlayerResourcePackStatusEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.net.InetSocketAddress;
import java.util.Map;

public final class ApolloMetadataListener {
    public static final MinecraftChannelIdentifier FML_HANDSHAKE_CHANNEL = MinecraftChannelIdentifier.create((String)"fml", (String)"handshake");

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        if (!(event.getSource() instanceof Player)) {
            return;
        }
        if (!event.getIdentifier().equals(FML_HANDSHAKE_CHANNEL)) {
            return;
        }
        this.handleFml(event.getData());
    }

    @Subscribe
    public void onPlayerClientBrand(PlayerClientBrandEvent event) {
        String brand = event.getBrand();
        VelocityMetadataManager manager = (VelocityMetadataManager)ApolloManager.getMetadataManager();
        Map<String, Integer> brands = manager.getClientBrands();
        brands.put(brand, brands.getOrDefault(brand, 0) + 1);
    }

    @Subscribe
    public void onPreLogin(PreLoginEvent event) {
        InetSocketAddress host = event.getConnection().getVirtualHost().orElse(null);
        if (host == null) {
            return;
        }
        VelocityMetadataManager manager = (VelocityMetadataManager)ApolloManager.getMetadataManager();
        manager.getServerAddress().add(host.getHostString() + ":" + host.getPort());
    }

    @Subscribe
    public void onResourcePackStatus(PlayerResourcePackStatusEvent event) {
        String status = event.getStatus().name();
        VelocityMetadataManager manager = (VelocityMetadataManager)ApolloManager.getMetadataManager();
        Map<String, Integer> statuses = manager.getResourcePackStatuses();
        statuses.put(status, statuses.getOrDefault(status, 0) + 1);
    }

    private void handleFml(byte[] data) {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        try {
            byte discriminator = in.readByte();
            if (discriminator != 2) {
                return;
            }
            VelocityMetadataManager manager = (VelocityMetadataManager)ApolloManager.getMetadataManager();
            Map<String, Integer> mods = manager.getMods();
            int count = ByteBufUtil.readVarInt(in);
            for (int i = 0; i < count; ++i) {
                String modId = ByteBufUtil.readString(in);
                String version = ByteBufUtil.readString(in);
                String key = modId + ":" + version;
                mods.put(key, mods.getOrDefault(key, 0) + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

