/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.listener;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.ApolloVelocityPlatform;
import com.lunarclient.apollo.player.ApolloPlayerManagerImpl;
import com.lunarclient.apollo.wrapper.VelocityApolloPlayer;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.PlayerChannelRegisterEvent;
import com.velocitypowered.api.proxy.Player;

public final class ApolloPlayerListener {
    @Subscribe
    public void onPlayerRegisterChannel(PlayerChannelRegisterEvent event) {
        if (!event.getChannels().contains(ApolloVelocityPlatform.PLUGIN_CHANNEL)) {
            return;
        }
        Player player = event.getPlayer();
        ((ApolloPlayerManagerImpl)Apollo.getPlayerManager()).addPlayer(new VelocityApolloPlayer(player));
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        if (!event.getIdentifier().equals(ApolloVelocityPlatform.PLUGIN_CHANNEL)) {
            return;
        }
        if (!(event.getSource() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getSource();
        ApolloManager.getNetworkManager().receivePacket(player.getUniqueId(), event.getData());
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent event) {
        Player player = event.getPlayer();
        ((ApolloPlayerManagerImpl)Apollo.getPlayerManager()).removePlayer(player.getUniqueId());
    }
}

