/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module;

import com.lunarclient.apollo.ApolloConfig;
import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.event.EventBus;
import com.lunarclient.apollo.libs.configurate.CommentedConfigurationNode;
import com.lunarclient.apollo.module.ApolloModule;
import com.lunarclient.apollo.module.ApolloModuleManager;
import com.lunarclient.apollo.option.ConfigOptions;
import com.lunarclient.apollo.option.Option;
import com.lunarclient.apollo.option.Options;
import com.lunarclient.apollo.option.OptionsImpl;
import com.lunarclient.apollo.util.ConfigTarget;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class ApolloModuleManagerImpl
implements ApolloModuleManager {
    private final Map<Class<? extends ApolloModule>, ApolloModule> modules = new LinkedHashMap<Class<? extends ApolloModule>, ApolloModule>();

    @Override
    public boolean isEnabled(@NonNull Class<? extends ApolloModule> moduleClass) {
        if (moduleClass == null) {
            throw new NullPointerException("moduleClass is marked non-null but is null");
        }
        return this.modules.containsKey(moduleClass);
    }

    @Override
    public <T extends ApolloModule> T getModule(@NonNull Class<T> moduleClass) {
        if (moduleClass == null) {
            throw new NullPointerException("moduleClass is marked non-null but is null");
        }
        return (T)this.modules.get(moduleClass);
    }

    @Override
    public Collection<ApolloModule> getModules() {
        return Collections.unmodifiableCollection(this.modules.values());
    }

    public void enableModules() throws Throwable {
        for (ApolloModule module : this.modules.values()) {
            module.setOptions(new OptionsImpl(module));
            List<Option<?, ?, ?>> options = module.getOptionKeys();
            this.loadConfiguration(module, options);
            if (module.isEnabled() || module.getOptions().get(ApolloModule.ENABLE_OPTION_ON) == Boolean.FALSE) continue;
            EventBus.getBus().register(module);
            module.enable();
        }
    }

    public void reloadModules() throws Throwable {
        for (ApolloModule module : this.modules.values()) {
            List<Option<?, ?, ?>> options = module.getOptionKeys();
            this.loadConfiguration(module, options);
            Boolean enable = (Boolean)module.getOptions().get(ApolloModule.ENABLE_OPTION_ON);
            if (enable == Boolean.valueOf(module.isEnabled())) continue;
            if (enable == Boolean.TRUE) {
                EventBus.getBus().register(module);
                module.enable();
                continue;
            }
            EventBus.getBus().unregister(module);
            module.disable();
        }
        this.saveConfiguration();
    }

    public void disableModules() {
        for (ApolloModule module : this.modules.values()) {
            if (!module.isEnabled()) continue;
            EventBus.getBus().unregister(module);
            module.disable();
        }
    }

    public <T extends ApolloModule> ApolloModuleManagerImpl addModule(@NonNull Class<T> moduleClass) {
        if (moduleClass == null) {
            throw new NullPointerException("moduleClass is marked non-null but is null");
        }
        this.modules.computeIfAbsent(moduleClass, key -> {
            try {
                Constructor constructor = moduleClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (ApolloModule)constructor.newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
        return this;
    }

    public <T extends ApolloModule> ApolloModuleManagerImpl addModule(Class<T> moduleClass, @NonNull T module) {
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        this.modules.putIfAbsent(moduleClass, module);
        return this;
    }

    public void saveConfiguration() throws Throwable {
        for (ApolloModule module : this.modules.values()) {
            ConfigTarget configTarget = module.getConfigTarget();
            ApolloConfig config = ApolloConfig.get(configTarget);
            CommentedConfigurationNode node = config.node();
            CommentedConfigurationNode modules = (CommentedConfigurationNode)node.node(configTarget.getModulesNode());
            CommentedConfigurationNode moduleNode = (CommentedConfigurationNode)modules.node(new Object[]{module.getId().toLowerCase(Locale.ROOT)});
            Options optionsContainer = module.getOptions();
            ConfigOptions.saveOptions(optionsContainer, moduleNode, module.getOptionKeys());
        }
    }

    private void loadConfiguration(ApolloModule module, List<Option<?, ?, ?>> options) throws Throwable {
        ConfigTarget configTarget = module.getConfigTarget();
        ApolloConfig config = ApolloConfig.compute(ApolloManager.getConfigPath(), configTarget);
        CommentedConfigurationNode node = config.node();
        CommentedConfigurationNode modules = (CommentedConfigurationNode)node.node(configTarget.getModulesNode());
        CommentedConfigurationNode moduleNode = (CommentedConfigurationNode)modules.node(new Object[]{module.getId().toLowerCase(Locale.ROOT)});
        if (moduleNode.virtual()) {
            return;
        }
        Options optionsContainer = module.getOptions();
        ConfigOptions.loadOptions(optionsContainer, moduleNode, options);
    }

    @Generated
    public ApolloModuleManagerImpl() {
    }
}

