/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.chat;

import com.lunarclient.apollo.chat.v1.DisplayLiveChatMessageMessage;
import com.lunarclient.apollo.chat.v1.RemoveLiveChatMessageMessage;
import com.lunarclient.apollo.common.ApolloComponent;
import com.lunarclient.apollo.module.chat.ChatModule;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public final class ChatModuleImpl
extends ChatModule {
    @Override
    public void displayLiveChatMessage(@NonNull Recipients recipients, @NonNull Component text, int messageId) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        DisplayLiveChatMessageMessage message = DisplayLiveChatMessageMessage.newBuilder().setAdventureJsonLines(ApolloComponent.toJson(text)).setMessageId(messageId).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void removeLiveChatMessage(@NonNull Recipients recipients, int messageId) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        RemoveLiveChatMessageMessage message = RemoveLiveChatMessageMessage.newBuilder().setMessageId(messageId).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

