/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.notification;

import com.lunarclient.apollo.common.ApolloComponent;
import com.lunarclient.apollo.module.notification.Notification;
import com.lunarclient.apollo.module.notification.NotificationModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.notification.v1.DisplayNotificationMessage;
import com.lunarclient.apollo.notification.v1.ResetNotificationsMessage;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public final class NotificationModuleImpl
extends NotificationModule {
    @Override
    public void displayNotification(@NonNull Recipients recipients, @NonNull Notification notification) {
        String resourceLocation;
        Component descriptionComponent;
        Component titleComponent;
        String description;
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (notification == null) {
            throw new NullPointerException("notification is marked non-null but is null");
        }
        DisplayNotificationMessage.Builder builder = DisplayNotificationMessage.newBuilder().setDisplayTime(NetworkTypes.toProtobuf(notification.getDisplayTime()));
        String title = notification.getTitle();
        if (title != null) {
            builder.setTitle(title);
        }
        if ((description = notification.getDescription()) != null) {
            builder.setDescription(description);
        }
        if ((titleComponent = notification.getTitleComponent()) != null) {
            builder.setTitleAdventureJsonLines(ApolloComponent.toJson(titleComponent));
        }
        if ((descriptionComponent = notification.getDescriptionComponent()) != null) {
            builder.setDescriptionAdventureJsonLines(ApolloComponent.toJson(descriptionComponent));
        }
        if ((resourceLocation = notification.getResourceLocation()) != null) {
            builder.setResourceLocation(resourceLocation);
        }
        DisplayNotificationMessage message = builder.build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetNotifications(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetNotificationsMessage message = ResetNotificationsMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

