/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.tntcountdown;

import com.lunarclient.apollo.common.ApolloEntity;
import com.lunarclient.apollo.module.tntcountdown.TntCountdownModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import com.lunarclient.apollo.tntcountdown.v1.SetTntCountdownMessage;
import com.lunarclient.apollo.util.Ranges;
import lombok.NonNull;

public final class TntCountdownModuleImpl
extends TntCountdownModule {
    @Override
    public void setTntCountdown(@NonNull ApolloEntity entity, int ticks) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        this.setTntCountdown(Recipients.ofEveryone(), entity, ticks);
    }

    @Override
    public void setTntCountdown(@NonNull Recipients recipients, @NonNull ApolloEntity entity, int ticks) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        SetTntCountdownMessage message = SetTntCountdownMessage.newBuilder().setEntityId(NetworkTypes.toProtobuf(entity)).setDurationTicks(Ranges.checkPositive(ticks, "TntCountdown#ticks")).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

