/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.vignette;

import com.lunarclient.apollo.module.vignette.Vignette;
import com.lunarclient.apollo.module.vignette.VignetteModule;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import com.lunarclient.apollo.util.Ranges;
import com.lunarclient.apollo.vignette.v1.DisplayVignetteMessage;
import com.lunarclient.apollo.vignette.v1.ResetVignetteMessage;
import lombok.NonNull;

public final class VignetteModuleImpl
extends VignetteModule {
    @Override
    public void displayVignette(@NonNull Recipients recipients, @NonNull Vignette vignette) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (vignette == null) {
            throw new NullPointerException("vignette is marked non-null but is null");
        }
        DisplayVignetteMessage message = DisplayVignetteMessage.newBuilder().setResourceLocation(vignette.getResourceLocation()).setOpacity(Ranges.checkRange(vignette.getOpacity(), 0.0f, 1.0f, "Vignette#opacity")).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetVignette(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetVignetteMessage message = ResetVignetteMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

