/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.waypoint;

import com.lunarclient.apollo.common.location.ApolloBlockLocation;
import com.lunarclient.apollo.event.player.ApolloRegisterPlayerEvent;
import com.lunarclient.apollo.libs.configurate.ConfigurationNode;
import com.lunarclient.apollo.libs.configurate.serialize.SerializationException;
import com.lunarclient.apollo.libs.configurate.serialize.TypeSerializer;
import com.lunarclient.apollo.module.waypoint.Waypoint;
import com.lunarclient.apollo.module.waypoint.WaypointModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.option.config.Serializer;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.player.ApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import com.lunarclient.apollo.waypoint.v1.DisplayWaypointMessage;
import com.lunarclient.apollo.waypoint.v1.RemoveWaypointMessage;
import com.lunarclient.apollo.waypoint.v1.ResetWaypointsMessage;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class WaypointModuleImpl
extends WaypointModule
implements Serializer {
    public WaypointModuleImpl() {
        this.serializer(Waypoint.class, new WaypointSerializer());
        this.handle(ApolloRegisterPlayerEvent.class, this::onPlayerRegister);
    }

    @Override
    public void displayWaypoint(@NonNull Recipients recipients, @NonNull Waypoint waypoint) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (waypoint == null) {
            throw new NullPointerException("waypoint is marked non-null but is null");
        }
        DisplayWaypointMessage message = this.toProtobuf(waypoint);
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void removeWaypoint(@NonNull Recipients recipients, @NonNull String waypointName) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (waypointName == null) {
            throw new NullPointerException("waypointName is marked non-null but is null");
        }
        RemoveWaypointMessage message = RemoveWaypointMessage.newBuilder().setName(waypointName).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void removeWaypoint(@NonNull Recipients recipients, @NonNull Waypoint waypoint) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (waypoint == null) {
            throw new NullPointerException("waypoint is marked non-null but is null");
        }
        this.removeWaypoint(recipients, waypoint.getName());
    }

    @Override
    public void resetWaypoints(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetWaypointsMessage message = ResetWaypointsMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    private void onPlayerRegister(ApolloRegisterPlayerEvent event) {
        ApolloPlayer player = event.getPlayer();
        List waypoints = (List)this.getOptions().get(player, WaypointModule.DEFAULT_WAYPOINTS);
        if (waypoints != null) {
            for (Waypoint waypoint : waypoints) {
                ((AbstractApolloPlayer)player).sendPacket(this.toProtobuf(waypoint));
            }
        }
    }

    private DisplayWaypointMessage toProtobuf(Waypoint waypoint) {
        return DisplayWaypointMessage.newBuilder().setName(waypoint.getName()).setLocation(NetworkTypes.toProtobuf(waypoint.getLocation())).setColor(NetworkTypes.toProtobuf(waypoint.getColor())).setPreventRemoval(waypoint.isPreventRemoval()).setHidden(waypoint.isHidden()).build();
    }

    private static final class WaypointSerializer
    implements TypeSerializer<Waypoint> {
        private WaypointSerializer() {
        }

        @Override
        public Waypoint deserialize(Type type, ConfigurationNode node) throws SerializationException {
            return Waypoint.builder().name(this.virtualNode(node, "name").getString()).location(ApolloBlockLocation.builder().world(this.virtualNode(node, "location", "world").getString()).x(this.virtualNode(node, "location", "x").getInt()).y(this.virtualNode(node, "location", "y").getInt()).z(this.virtualNode(node, "location", "z").getInt()).build()).color(Color.decode(this.virtualNode(node, "color").getString("#FFFFFF"))).preventRemoval(this.virtualNode(node, "prevent-removal").getBoolean()).hidden(this.virtualNode(node, "hidden").getBoolean()).build();
        }

        @Override
        public void serialize(Type type, @Nullable Waypoint waypoint, ConfigurationNode node) throws SerializationException {
            if (waypoint == null) {
                node.raw(null);
                return;
            }
            node.node("name").set(waypoint.getName());
            node.node("location", "world").set(waypoint.getLocation().getWorld());
            node.node("location", "x").set(waypoint.getLocation().getX());
            node.node("location", "y").set(waypoint.getLocation().getY());
            node.node("location", "z").set(waypoint.getLocation().getZ());
            node.node("color").set(String.format("#%06X", 0xFFFFFF & waypoint.getColor().getRGB()));
            node.node("prevent-removal").set(waypoint.isPreventRemoval());
            node.node("hidden").set(waypoint.isHidden());
        }

        private ConfigurationNode virtualNode(ConfigurationNode source, Object ... path) throws SerializationException {
            if (!source.hasChild(path)) {
                throw new SerializationException("Required field " + Arrays.toString(path) + " not found!");
            }
            return source.node(path);
        }
    }
}

